/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Include .h file
#include "DependenciesState.h"
#include "DependenciesWidget.h"
#include "DorothyMainWindow.h"

// Includes from cepgenerator
#include <ClassNameHandler.h>

// includes from coreschema
#include <Cep.hxx>
#include <Dependencies.hxx>
#include <Libraries.hxx>
#include <ComponentExtensions.hxx>
#include <ActionExtensions.hxx>

// temporary include
#include <iostream>

/**  Constructor */
DependenciesState::DependenciesState(QString name, DependenciesWidget * widget, DorothyMainWindow * mainWindow, cepcoreschema::Cep * domCep, QState * parent)
    : WizardState(name, widget, mainWindow, parent)
{
    this->domCep = domCep;
}

/**  Destructor */
DependenciesState::~DependenciesState() {}


void DependenciesState::onEntry(QEvent *event) {
    WizardState::onEntry(event);
    DependenciesWidget * dependenciesWidget = dynamic_cast<DependenciesWidget *> (widget);
    if (dependenciesWidget != NULL)
    {
        // Update existing Libraries
        QStringList cepLibraries;
        if (domCep->libraries().present()) {
            cepcoreschema::Libraries::library_sequence domLibrary = domCep->libraries().get().library();
            cepcoreschema::Libraries::library_const_iterator it;
            for (it = domLibrary.begin(); it != domLibrary.end(); it++) {
                cepLibraries << (*it).name().c_str();
            }
        }
        dependenciesWidget->updateCEPLibraries(cepLibraries);
        
        // Update existing Components
        QStringList cepComponents;
        if (domCep->componentExtensions().present()) {
            cepcoreschema::ComponentExtensions::componentExtension_sequence domComponents = domCep->componentExtensions().get().componentExtension();
            cepcoreschema::ComponentExtensions::componentExtension_iterator it;
            for (it = domComponents.begin(); it != domComponents.end(); it++) {
                cepComponents << (*it).name().c_str();
            }
        }
        dependenciesWidget->updateCEPComponents(cepComponents);
        
        // Update existing Actions
        QStringList cepActions;
        if (domCep->actionExtensions().present()) {
            cepcoreschema::ActionExtensions::actionExtension_sequence domActions = domCep->actionExtensions().get().actionExtension();
            cepcoreschema::ActionExtensions::actionExtension_iterator it;
            for (it = domActions.begin(); it != domActions.end(); it++) {
                cepActions << (*it).name().c_str();
            }
        }
        dependenciesWidget->updateCEPActions(cepActions);
        
    }
    
}

cepcoreschema::Dependencies * DependenciesState::getDependencies() {
    cepcoreschema::Dependencies * domDependencies = new cepcoreschema::Dependencies();
    DependenciesWidget * dependenciesWidget = dynamic_cast<DependenciesWidget *> (widget);
    if (dependenciesWidget != NULL)
    {
        // Get Internal CEP dependencies
        QStringList cepLibraries = dependenciesWidget->getCEPLibrariesDependencies();
        foreach (QString lib, cepLibraries) {
            QString libName = ClassNameHandler::getDirectoryName(lib);
            cepcoreschema::Dependency dep("cepLibrary", libName.toStdString());
            domDependencies->dependency().push_back(dep);
        }
        QStringList cepComponents = dependenciesWidget->getCEPComponentsDependencies();
        foreach(QString comp, cepComponents) {
            QString compName = ClassNameHandler::getDirectoryName(comp);
            cepcoreschema::Dependency dep("component", compName.toStdString());
            domDependencies->dependency().push_back(dep);
        }
        QStringList cepActions = dependenciesWidget->getCEPActionsDependencies();
        foreach (QString action, cepActions) {
            QString actionName = ClassNameHandler::getDirectoryName(action);
            cepcoreschema::Dependency dep("action", actionName.toStdString());
            domDependencies->dependency().push_back(dep);
        }
        
        // Get CamiTK dependencies
        QStringList camitkLibraries = dependenciesWidget->getCamiTKLibrariesDependencies();
        foreach (QString lib, camitkLibraries) {
            QString libName = ClassNameHandler::getDirectoryName(lib);
            cepcoreschema::Dependency dep("cepLibrary", libName.toStdString());
            domDependencies->dependency().push_back(dep);
        }
        QStringList camitkComponents = dependenciesWidget->getCamiTKComponentsDependencies();
        foreach(QString comp, camitkComponents) {
            QString compName = ClassNameHandler::getDirectoryName(comp);
            cepcoreschema::Dependency dep("component", compName.toStdString());
            domDependencies->dependency().push_back(dep);
        }
        QStringList camitkActions = dependenciesWidget->getCamiTKActionsDependencies();
        foreach (QString action, camitkActions) {
            QString actionName = ClassNameHandler::getDirectoryName(action);
            cepcoreschema::Dependency dep("action", actionName.toStdString());
            domDependencies->dependency().push_back(dep);
        }
        
        // Get Other libraries dependencies
        QStringList externalLibs = dependenciesWidget->getExternalLibsDependencies();
        foreach (QString lib, externalLibs) {
            cepcoreschema::Dependency dep("library", lib.toStdString());
            domDependencies->dependency().push_back(dep);
        }
    }
    return domDependencies;
}

void DependenciesState::onExit( QEvent * event )
{
    WizardState::onExit(event);
}

