/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Include .h file
#include "ActionAddParameterState.h"
#include "ActionAddParameterWidget.h"
#include "DorothyMainWindow.h"
#include "ActionCreationState.h"
#include "ActionParameterWidget.h"

// includes from coreschema
#include <Action.hxx>
#include <Parameters.hxx>
#include <Parameter.hxx>


/**  Constructor */
ActionAddParameterState::ActionAddParameterState(QString name, ActionAddParameterWidget * widget, DorothyMainWindow * mainWindow, ActionCreationState * parent)
    : WizardState(name, widget, mainWindow, parent)
{
    this->domAction = NULL;
}
/**  Destructor */
ActionAddParameterState::~ActionAddParameterState() {}

void ActionAddParameterState::resetDomAction(cepcoreschema::Action * domAction)
{
    this->domAction = domAction;
    ActionAddParameterWidget * actionAddParameterWidget = dynamic_cast<ActionAddParameterWidget *>(widget);
    if (actionAddParameterWidget != NULL)
    {
        actionAddParameterWidget->setToDefault();
    }
}

void ActionAddParameterState::onEntry(QEvent *event)
{
    WizardState::onEntry(event);
}

void ActionAddParameterState::onExit( QEvent * event )
{
    addDomParameters();
    WizardState::onExit(event);
}


void ActionAddParameterState::addDomParameters() {
    ActionAddParameterWidget * addParameterWidget = dynamic_cast<ActionAddParameterWidget*>( (this->widget) );
    QList<ActionParameterWidget *> parameterWidgets = addParameterWidget->getActionParameterWidgets();
    
    if (parameterWidgets.size() > 0) {
        cepcoreschema::Parameters domParameters;
        
        foreach(ActionParameterWidget * p, parameterWidgets) {
            QString name = p->getName();
            QString type = p->getType();
            QString defValue = p->getDefaultValue();
            QString description = p->getDescription();
            cepcoreschema::Parameter domParam(name.toStdString().c_str(), type.toStdString().c_str());
            domParam.defaultValue(defValue.toStdString().c_str());
            // TODO uncomment as soon as a cepcoreschema parameter is allowed to have a description
            // domParam.description(description.toStdString().c_str());
            
            domParameters.parameter().push_back(domParam);
        }
        this->domAction->parameters(domParameters);
    }
}