/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
// Qt
#include <QMainWindow>
#include <QString>
#include <QStringList>

#include "RemovableLineEdit.h"
// Include GUI  automatically generated from the file 
// ExtensionWindow.ui (to be modified via QtDesigner).
#include "ui_ExtensionWindow.h"

#ifndef EXTENSIONWINDOW_H
#define EXTENSIONWINDOW_H

enum ExtTypeType {
	Action		= 1,
	Application	= 2,
	Component	= 3,
	Viewer		=4
};

class ExtensionWindow : public QMainWindow  {
    Q_OBJECT	

	
public:
	ExtensionWindow(QMainWindow * dad, QString workingDirectory, ExtTypeType extType);
    
    void addExtTypeFile(QString extTypeFileName);
    void removeExtTypeFile(RemovableLineEdit * extTypeRLE);
    QString getExtensionClassName();
	void rleToggle(RemovableLineEdit * rle,  bool res);
	void addItkDependency();


public slots:
    virtual void addExtTypeButtonClicked();
	virtual void addExtFileButtonClicked(); 
    virtual void okClicked();
    virtual void cancelClicked();

private:

	void personnalizeInterface();

	 Ui_ExtensionWindow ui;

	 ExtTypeType extType;

     QMainWindow * dad;
     QString workingDirectory;
     QList<RemovableLineEdit *> extTypeFiles;
	 QList<RemovableLineEdit *> fileExts;

};
#endif
