/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef AtomDCWidget_H
#define AtomDCWidget_H

#include <QWidget>

class QLabel;

class QTableWidget;

class QListWidgetItem;

class AtomDC;

//***************************************************************************
/**
 *  @ingroup group_cepmodeling_components_physicalmodel
 *  
 *  @brief
 *  The class AtomDCWidget defines a widget controling the properties of
 *  an instance of an AtomDC.
 *
 *  This widget is special as there is only one AtomDCWidget instance for ALL the atoms
 *  of a physical model.
 *  When the user selects an atom for the first time, the widget
 *  is created and displayed. When the user selects another atom, the widget is updated
 *  with the property of the selected atom (via method updateProperties(...) ).
 *  see PMManagerDC for the control of the instance.
 * 
 * 
 **/
class AtomDCWidget : public QWidget {
    Q_OBJECT

  public:

    /** Default construtor */
    AtomDCWidget(AtomDC *, QWidget* parent = 0);
    ~AtomDCWidget() {}

    /// change the currently managed AtomDC and update the value of the properties
    void updateProperties(AtomDC*);

  public slots:
    void usedInTableClicked(int, int);

  private:
    /// the currently selected atom's AtomDC
    AtomDC* myDC;

    QLabel* infoLabel;
    QTableWidget* usedInTable;
};


#endif
