/*
  imho_german.pike v0.1 for IMHO v0.96.1
  
  Copyright  
  Michael Stenitzer <stenitzer@eva.wsr.ac.at> 1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.
  
*/

#include <camas/language.h>

string imho_lang() {
  return "deutsch";
}

string imho_lang_short() {
  return "de";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
// Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Benutzerkennung:";
  case M_PASSWORD:
    //return "Password:";
    return "Passwort:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Sie konnten nicht angemeldet werden:</b> Benutzerkennung oder Passwort sind falsch. Versuchen Sie es nochmals. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Die Verbindung mit dem Mail-/IMAP-Server konnte nicht hergestellt werden. Kontaktieren Sie Ihre SystemadministratorIn.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Beim Versenden der Nachricht gab es ein Problem bei der Verbindung zum (SMTP) Mailserver. Die Empf&auml;ngerIn dieser Nachricht exisitiert unter Umst&auml;nden nicht.";
   case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    //???
    return "Von Einstellungen";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Benutzer-Interface:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";
   
  case M_NEWMAIL:
    //return "New mail";
    return "Neue Nachricht";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Ordner: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Ordner";
  case M_FILES:
    //return "Files";
    return "Dateien";
  case M_PREFS:
    //return "Preferences";
    return "Einstellungen";
  case M_LOGOUT:
    //return "Logout";
    // return "Abmelden";
    return "Logout";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktueller Ordner";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Ueberpruefe aktuellen Ordner";


  case M_FROM:
    //return "From";
    return "Von";
  case M_TO:
    //return "To";
    return "An";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Betreff";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Attachments";
  case M_TIME:
    //return "Time";
    return "Zeit";
  case M_DATE:
    //return "Date";
    return "Datum";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "A";
    
    
  case M_SEND:
    //return "Send";
    return "Senden";
  case M_CANCELSEND:
    //return "Cancel";
    return "Abbrechen";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "W&auml;hlen Sie eine Datei zum versenden. Dr&uuml;cken Sie 'Ctrl'/'Strg' f&uuml;r mehrere Dateien.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Nachricht verfassen";
  case M_SPELLCHECK:
    return "Rechtschreibung pr&uuml;fen";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Diese Nachricht nicht speichern.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Eine Datei als Attachment beif&uuml;gen";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Keine Attachments";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Ein Attachment beif&uuml;gen...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Markierte Attachments l&ouml;schen";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Attachment laden";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Markierte Dateien als Attachment hinzuf&uuml;gen";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Zu den Attachments laden";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Zur&uuml;ck zum Verfassen einer Nachricht";
  case M_NOATTACHFILES:
    //return "No files";
    return "Keine Dateien";
  case  M_ATTACHMENTSHEADER:
    return "Attachments";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "E-Mail erfolgreich versendet, speichern in Postausgang fehlgeschlagen.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Sie muessen eine EmpfaengerIn fuer die Nachricht angegeben.";
    
  case M_DELETEMARKED:
    //return "Delete marked";
    return "Markierte l&ouml;schen";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Markierte Nachrichten in folgenden Ordner verschieben";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "[Ordner ausw&auml;hlen]";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Neue Nachrichten?";
  case M_MAILSHOWN:
    // return sprintf("Mail <b>%d-%d of %d</b>", @arg);
    return sprintf("E-Mail <b>%d-%d von %d</b>", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Vorherige %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[N&auml;chste %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Sind Sie sicher, dass Sie die %d markierten Nachrichten l&ouml;schen m&ouml;chten?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Bitte markieren Sie zuerst die entsprechenden Nachrichten.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Reihenfolge &auml;ndern";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Markierte Nachrichten in den 'Papierkorb' verschieben";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "'Papierkorb' entleeren";
  case M_NOMAILS:
    // return "[No mails]";
    return "[Keine Nachrichten]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Ordner";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Markierte l&ouml;schen";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Neuen Ordner erstellen";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "[Name]";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Sind Sie sicher, dass Sie die folgenden Ordner l&ouml;schen m&ouml;chten?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Markieren Sie zumindest einen Ordner.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Geben Sie zuerst einen Namen an.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Ordner konnte nicht angelegt werden. Der Name k&ouml;nnte ung&uuml;ltig sein oder bereits existieren.";
  case M_INBOX:
    //return "Inbox";
    return "Posteingang";
  case M_PREVIOUS_LEVEL:
    //return "[Previuos level]";
    return "[Vorige Ebene]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Pfad:";
	
  case M_FILENAME:
    //return "Filename";
    return "Dateiname";
  case M_SIZE:
    //return "Size";
    return "Gr&ouml;&szlig;e";
  case M_MIMETYPE:
    //return "Type";
    return "Typ";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Zum L&ouml;schen markiert";
  case M_UPLOAD:
    //return "Upload";
    return "Laden";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Sie haben %d Kb Speicherplatz f&uuml;r Ihre Dateien.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "ACHTUNG WINDOWS-ANWENDER! Wegen eines Fehlers in manchen Browsern, k&ouml;nnen Dateinamen verst&uuml;mmelt werden. Um das zu vermeiden ersetzen Sie den LETZTEN '\\' durch '\\\\' bevor Sie 'Laden' dr&uuml;cken.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Sie haben keine Dateien ausgew&auml;hlt.";

  case M_PNAME:
    //return "Name";
    return "Name";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "E-Mail Adresse";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Mailpfad (kann leer sein)";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Beim Antworten Original-Nachricht beif&uuml;gen";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Signatur";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Logout nach Unt&auml;tigkeit (Minuten)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Speichern";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Anzahl der angezeigten Nachrichten";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Reihenfolge";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return (["backward":"aktuellste zuerst", "forward": "chronologisch"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Papierkorb";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Pfad f&uuml;r gesendete Nachrichten";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Standard Bcc-Adresse";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Attachments speichern";
  case M_PLANGUAGE:
    //return "Language";
    return "Sprache";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Benutzer-Interface";
  case M_SPELLDONE:
    //return "Done";
    return "Erledigt";
  case M_SPELLPREV:
    //return "Previous";
    return "Vorherige";
  case M_SPELLNEXT:
    //return "Next";
    return "Weiter";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "ndern in";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Vorschlag";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Sie sind abgemeldet. Damit niemand Ihre E-Mails missbr&auml;uchlich lesen kann, schlie&szlig;en Sie das Browser-Fenster.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Abgemeldet";

  case M_QUESTION:
    //return "Question"; 
    return "Frage";

  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Antworten";
  case M_READPREV:
    //return "Read previous";
    return "Vorherige lesen";
  case M_READNEXT:
    //return "Read next";
    return "N&auml;chste lesen";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sAttachment vom Typ %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Fehler:</b> Nachricht konnte nicht ge&ouml;ffnet werden. Versuchen Sie es nochmals.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Zur&uuml;ck";
  case M_DELETE:
    //return "Delete";
    return "L&ouml;schen";
  case M_FORWARD:
    //return "Forward";
    return "Weiterleiten";
  case M_MAIL:
    // return "Mail";
    return "E-Mail";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "E-Mail Header anzeigen";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "E-Mail Header ausblenden";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "E-Mail ist zu gro&szlig; um angezeigt zu werden. Sie koennen die E-Mail hier herunterladen.";

  case M_ADDRESSBOOKTITLE:
    //return("Address Book");         
    return("Adressbuch");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Adressbuch...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Name (klicken, um als Empfaenger hinzuzufuegen)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Name (klicken zum Aendern)");
  case M_ADDRESS:
    //return("Address");
    return("Adresse");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Keine Adresse");
  case M_NEWADDRESS:
    //return("New address...");
    return("Neue Adresse...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Adresse aendern");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Zum Adressbuch hinzufuegen");
  case M_INDEXNAME:
    //return("Index name");
    return("Name");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("E-Mail-Adresse/n (mehrere durch Komma trennen)");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Speichern und verwenden");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Adresse loeschen");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Abbrechen");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Kann dieses Adressbuch nicht importieren,\nda das Format unbekannt ist.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Adressbuch importieren");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Ein \"Pine\"- oder ein \"exportiertes Netscape\"-Adressbuch (.ldif) importieren");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("(Das \"Pine\"-Adressbuch liegt meistens unter \"~/.addressbook\")");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Importieren");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Adressbuch importieren...");

case M_YES:
    //return "Yes";
    return "Ja";
  case M_NO:
    //return "No";
    return "Nein";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Abbrechen";
   
  }
  return 0;
}




