/*

  imho_estonian.pike v0.1 for IMHO v0.97.1
  
  Copyright  
  Bilbo <bilbo@blastnet.ee> 2000
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

#include <camas/language.h>

string imho_lang() {
  return "eesti";
}

string imho_lang_short() {
  return "et";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  return "";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Login:";
  case M_PASSWORD:
    //return "Password:";
    return "Parool:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Kahjuks ei saa sisse logida:</b> Vale kasutaja vi parool";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Mingi probleem serveriga suhtlemisel";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Mingi probleem vljuva maili (SMTP) serveriga. Kontakteeru administraatoriga";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Isiklik konfiguratsioon";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Kasutaja intrerface";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "Compose";
    return "Saada";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Postkast: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Postkastid";
  case M_FILES:
    //return "Files";
    return "Failid";
  case M_PREFS:
    //return "Preferences";
    return "Konfiguratsioon";
  case M_LOGOUT:
    //return "Logout";
    return "Logi vlja";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktiivne postkast";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Vaata aktiivseid postkaste";

  case M_FROM:
    //return "From";
    return "Kellelt";
  case M_TO:
    //return "To";
    return "Kellele";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Subjekt";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Failid";
  case M_TIME:
    //return "Time";
    return "Aeg";
  case M_DATE:
    //return "Date";
    return "Kuupev";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "A";
    
    
  case M_SEND:
    //return "Send";
    return "Saada";
  case M_CANCELSEND:
    //return "Cancel";
    return "Katkesta";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Vali failid mida saata. Vajuta 'Ctrl' et valida mitu faili.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Saada kiri";
  case M_SPELLCHECK:
    return "Speller";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "ra seda kirja salvesta.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Lisa fail";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Faile pole";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Lisa fail...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Eemalda mrgitud failid";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Uploadi fail";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Lisa mrgitud fail kirja";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Uploadi fail";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Tagasi kirjutama";
  case M_NOATTACHFILES:
    //return "No files";
    return "Faile pole";
  case  M_ATTACHMENTSHEADER:
    return "Lisad";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Kiri on saadetud, aga salvestamine kataloogi ebannestus";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Kellele see kiri peaks minema?";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    return "Viivitus saatmisel";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    return "Edukalt saadetud";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Kustuta mrgitud kirjad";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Paiguta mrgitud kirjad";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Vali postkast)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Kontrolli posti";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Kiri %d-%d av %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Eelmine %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Jrgmine %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Oled sa kindel, et sa tahad kustutada %d mrgitud teate(d)?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Mrgi ikka mni teade ra ka.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Vaheta sortimisviisi";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Saada mrgitud teated trash'i(prahikataloog)";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Kustuta kik praht";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Kirju pole]";
  case M_MARKALL:
    //return "Mark all";
    return "Mrgi kik";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Postkast";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Kustuta mrgitud";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Tee uus postkast";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nimi)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Oled sa kindel, et sa soovid kustutada seda postkasti?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Mrgi vhemalt ks postkast.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Kigepealt kirjuta nimi.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Ei sa postkasti teha. Postkasti nimi pole korrektne vi on juba olemas.";
  case M_INBOX:
    //return "Inbox";
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    //return "[Previous level]";
    return "[Eelmine tase]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Rada:";
	
  case M_FILENAME:
    //return "Filename";
    return "Failinimi";
  case M_SIZE:
    //return "Size";
    return "Suurus";
  case M_MIMETYPE:
    //return "Type";
    return "Tp";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Kustuta mrgitud";
  case M_UPLOAD:
    //return "Upload";
    return "Upload";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Sul on uploadimise jaoks %d Kb vaba ruumi ",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Pole midagi uploadida.";

  case M_PNAME:
    //return "Name";
    return "Nimi";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Kirja aadress";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Kirjakataloog";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Vastus sisaldab teksti kirjast";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Signatuur";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Tegevusetuse logout (minutites)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Salvesta ja kasuta";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Kirjad on nhtavad postkastis";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Kirjade sorteerimine";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "edasi": "edasi", "tagasi":"tagasi"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Prahi kataloog";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Saadetud kirjade kataloog";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return " Default Bcc aadress";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Salvesta fail";
  case M_PLANGUAGE:
    //return "Language";
    return "Keel";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Kasutaja interface";
  case M_PHEADER:
    //return "Extra headers";
    return "Ekstra pealkirjad";
  case M_PHEADERDESC:
    //return "(Lines with headers in this format: header:value )";
    return "(Lines with headers in this format: header:value )";

  case M_SPELLDONE:
    //return "Done";
    return "Valmis";
  case M_SPELLPREV:
    //return "Previous";
    return "Eelmine";
  case M_SPELLNEXT:
    //return "Next";
    return "Jrgmine";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Muuda";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Ettepanekud";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "Sa logisid vlja.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Logisid vlja";

  case M_QUESTION:
    //return "Question"; 
    return "Ksimus";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Reply";
  case M_READPREV:
    //return "Read previous";
    return "Loe eelmist";
  case M_READNEXT:
    //return "Read next";
    return "Loe jrgmist";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%slisa tp %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Viga:</b> Proovi uuesti.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Tagasi";
  case M_DELETE:
    //return "Delete";
    return "Kustuta";
  case M_FORWARD:
    //return "Forward";
    return "Saada edasi";
  case M_MAIL:
    // return "Mail";
    return "Mail";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Nita kiki pealkirju";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "ra nita kiki pealkirju";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Kiri on liiga suur et vaadata. Vajuta siia et see downloadida.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Vasta kigile";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "Saada prgikasti";
  case M_CHARSETWARNING:
    //return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    return sprintf("Hoiatus! Ei saa kiki thti dekodeerida \"%s\". Kiri on lahti kodeeritud.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Aaddress Book");         
    return("Aadressi raamat");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Aadressi raamat...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Indeksi nimi (vajuta et lisada kirja saaja)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Indeksi nimi (vajuta et muuta)");
  case M_ADDRESS:
    //return("Address");
    return("Aadress");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Pole aadressi");
  case M_NEWADDRESS:
    //return("New address...");
    return("Uus aadress...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Muuda aadressi");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Lisa aadressi raamatusse");
  case M_INDEXNAME:
    //return("Index name");
    return("Indeksi nimi");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Aadressite vahele pane koma");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Salvesta ja kasuta");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Kustuta aadress");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Katkesta");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Ei oska selle aadressiraamatuga midagi peale hakata.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Impordi aadressiraamat");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Uploadi Pine'i vi eksporditud Netscape aadressi raamat");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("Pine'i aadressiraaamat asub tavaliselt ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Uploadi ja impordi");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Impordi aadressiraamat...");
  case M_GLOBALADDRESSES:
    return("Gemensamma adresser:");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("LDAP aadressid");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("otsi LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Otsi nime:");
  case M_OU:
    //return("OU");
    return("OU");

  case M_YES:
    //return "Yes";
    return "Jah";
  case M_NO:
    //return "No";
    return "Ei";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Katkesta";
   
  }
  return 0;
}
