/*

  imho_dutch.pike v0.1 for IMHO v0.97.1 (dutch language file)

  Copyright  
  Martijn Damen <damen@scintilla.utwente.nl> 1999

  IMHO:

  Copyright  
  Stefan Wallstrm <stewa@lysator.liu.se>
  & Bosse Lincoln <lincoln@lysator.liu.se> 1998-1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

#include <camas/language.h>

string imho_lang() {
  return "nederlands";
}

string imho_lang_short() {
  return "nl";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  return "";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Login:";
  case M_PASSWORD:
    //return "Password:";
    return "Paswoord:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Inloggen mislukt:</b> Verkeerde inlognaam of paswoord. Probeer het opnieuw. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Er zijn problemen met het contact met de email- (IMAP) server. Neem contact op met de systeembeheerder.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Er heeft zich een probleem voorgedaan met de uitgaande email-server(SMTP) De ontvanger van de email bestaat mischien niet.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Van instellingen";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Gebruikers interface:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "Compose";
    return "Opstellen";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Mailbox: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Mailboxes";
  case M_FILES:
    //return "Files";
    return "Bestanden";
  case M_PREFS:
    //return "Preferences";
    return "Instellingen";
  case M_LOGOUT:
    //return "Logout";
    return "Uitloggen";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Huidige Mailbox";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Controleer actieve mailboxen";

  case M_FROM:
    //return "From";
    return "Van";
  case M_TO:
    //return "To";
    return "Aan";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Onderwerp";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Bijlagen";
  case M_TIME:
    //return "Time";
    return "Tijd";
  case M_DATE:
    //return "Date";
    return "Datum";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "A";
    
    
  case M_SEND:
    //return "Send";
    return "Versturen";
  case M_CANCELSEND:
    //return "Cancel";
    return "Afbreken";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Selecteer de bestanden die verstuurd moeten worden. Druk 'Ctrl' om meerdere bestanden te selecteren.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Nieuw bericht opstellen";
  case M_SPELLCHECK:
    return "Spellingscontrole";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Bewaar dit bericht niet.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Voeg bestand bij als bijlage";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Geen bijlagen";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Voeg bijlage toe...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Verwijder gemarkeerde berichten";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Upload bijlage";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Voeg gemarkeerde items toe als bijlage";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Upload naar bijlagen";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Terug naar opstellen";
  case M_NOATTACHFILES:
    //return "No files";
    return "Geen bestanden";
  case  M_ATTACHMENTSHEADER:
    return "Bijlage";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Bericht met succes verstuurd, maar bewaren in map mislukt.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "U moet een ontvanger aangeven.";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    return "Rapporteer vertraagd afleveren.";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    return "Rapporteer succesvol afleveren.";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Verwijder gemarkeerde berichten";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Verplaats gemarkeerde naar";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Selecteer een mailbox)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Controleer op nieuwe berichten";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Bericht %d-%d av %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Vorige %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Volgende %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Weet u zeker dat u de %d geselecteerde berichten wilt verwijderen?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Selecteer eerst een bericht.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Verander sorteervolgorde";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Verplaats geselecteerden naar de prullebak";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Verwijder alle berichten uit de prullebak";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Geen berichten]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Mailbox";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Verwijder geselecteerde";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Maak een nieuwe mailbox";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Naam)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Weet u zeker dat u de volgende mailboxen wilt verwijderen?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Selecteer minstens n mailbox.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Geef eerst een naam op..";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Mailbox aanmaken mislukt. De mailbox bestaat mischien al of de naam is incorrect.";
  case M_INBOX:
    //return "Inbox";
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    //return "[Previous level]";
    return "[Voorgaand niveau]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Pad:";
	
  case M_FILENAME:
    //return "Filename";
    return "Bestandsnaam";
  case M_SIZE:
    //return "Size";
    return "Grootte";
  case M_MIMETYPE:
    //return "Type";
    return "Type";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Verwijder geselecteerde";
  case M_UPLOAD:
    //return "Upload";
    return "Upload";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("U heeft %d Kb ruimte beschikbaar voor uploaden.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Windowsgebruikers: Door een fout in sommige browsers kunnen bestandsnamen verminkt zijn. Voorkom dit door de laatste '\\' te vervangen door '\\\\' voor u op 'Upload' drukt.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "U heeft geen bestanden geuploaded.";

  case M_PNAME:
    //return "Name";
    return "Naam";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Email adres";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Email zoekpad";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Voeg bericht bij bij beantwoorden";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Handtekening";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Uitlogtijd bij inactiviteit (in minuten)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Bewaar en gebruik";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Berichten weergeven in mailbox";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Sorteervolgorde";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "vooruit", "backward":"terug"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Prullebak";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Verzonden mail";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Standaard Bcc adres";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Bewaar bijlagen";
  case M_PLANGUAGE:
    //return "Language";
    return "Taal";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Gebruikers weergave";
  case M_SPELLDONE:
    //return "Done";
    return "Klaar";
  case M_SPELLPREV:
    //return "Previous";
    return "Voorgaande";
  case M_SPELLNEXT:
    //return "Next";
    return "Volgende";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "verander in";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Suggesties";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "U bent nu uitgelogd. Sluit dit window om te voorkomen dat iemand uw email kan lezen. Ververs deze pagina om opnieuw in te loggen.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Uitgelogged";

  case M_QUESTION:
    //return "Question"; 
    return "Vraag";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Beantwoorden";
  case M_READPREV:
    //return "Read previous";
    return "Lees voorgaande";
  case M_READNEXT:
    //return "Read next";
    return "Lees volgende";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sbijlage van het type %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Error:</b> Mail ophalen mislukt. Probeer opnieuw.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Terug";
  case M_DELETE:
    //return "Delete";
    return "Verwijder";
  case M_FORWARD:
    //return "Forward";
    return "Doorsturen";
  case M_MAIL:
    // return "Mail";
    return "bericht";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Laat alle berichtinfo zien";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Verberg berichtinfo";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Het bericht is te groot om weer te geven. Klik hier om het bericht te downloaden.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Beantwoord aan allen";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "Verplaats naar Prullebak";
  case M_CHARSETWARNING:
    //return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    return sprintf("Waarschuwing! Decoderen van de karakterset \"%s\" mislukt. Bericht is ongedecodeerd weergegeven.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Adresboek");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Adresboek...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Indexnaam (klik om toe te voegen als ontvanger)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Indexnaam (klik om te bewerken)");
  case M_ADDRESS:
    //return("Address");
    return("Adres");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Geen adressen");
  case M_NEWADDRESS:
    //return("New address...");
    return("Nieuw adres...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Bewerk adres");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Voeg toe aan adresboek");
  case M_INDEXNAME:
    //return("Index name");
    return("Indexnaam");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Adres(sen), gescheiden door komma's");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Bewaar en gebruik");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Verwijder adres");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Afbreken");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Kan dit adresboek niet importeren, het \n formaat is onbekend.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importeer adresboek");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Upload een Pine of geexporteerd Netcape (.ldif) adresboek");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("Het Pine adresboek staat vaak in ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Upload en importeer");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importeer adresboek...");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("LDAP adressen");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Zoek LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Zoek naam met:");
  case M_OU:
    //return("OU");
    return("OU");

  case M_YES:
    //return "Yes";
    return "Ja";
  case M_NO:
    //return "No";
    return "Nee";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Afbreken";
   
  }
  return 0;
}





