#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  NOTIFY screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  CSESSION->screen = "notify";				// Admin screen name

  contents = CAMAS.Parse.parse_html(contents,
                        ([
			  "camas_checkmail"	: tag_notify_screen,
                         ]),
                        ([
			  "camas_mailstatus"	: container_notify_screen,
                         ]),
                        id);


  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);
  
  contents += "<!-- End of screen_NOTIFY -->";
  return contents;
}

//! container: 
//!  Zone for case there is no errors
//! note: screen: spellcheck
/* code for notify screen tags */
/*	  <camas_reloadpage time="1000" />
*/
string tag_notify_screen(string tag_name, mapping args, object id)
{
  string out = "";                                              // HTML to output
  string href = CAMAS.Tools.make_get_url(id, ([ "screen":"notify" ]), ([ "actioncheckactivemailboxes":"1" ]));

  switch(tag_name)
  {
  case "camas_checkmail":
    //! tag: camas_reloadpage
    //!  Javascript method to automaticaly reload page every time (or 6000) ms
    //! note: screen: notify
    out += "<script language=\"JavaScript\" type=\"text/javascript\">\n";
    out += "  window.setTimeout('window.location=\""+href+"\";',";
    out += (args -> timeout ? args -> timeout : "6000")+");\n";
    out += "</script>\n";

    break;

  default:
    out += "<!-- " + tag_name + " is not supported yet -->";
    CDEBUG("tag_notify_screen: " + tag_name + "is not supported yet");
  }

  return out;
}


//! container: camas_mailstatus
//!  Zone for displaying mail/no mail status
//! childcontainer: nonew
//! childcontainer: new
//! note: screen: notify
string container_notify_screen(string tag_name, mapping args, string contents, 
			       object id)
{
  return CAMAS.Parse.parse_html(contents, ([ ]),
                        ([
		       "camas_new"	: container_notify_screen_newmail,
		       "camas_nonew" : container_notify_screen_nonewmail,
                         ]),
                        id);
}

//! container: camas_new
//!  Zone displayed when they are new mail
//! parentcontainer: camas_mailstatus
//! note: screen: notify
string container_notify_screen_newmail(string tag_name, mapping args, 
				       string contents, object id)
{
  if (CSESSION->hasnewmail > 0) {
    contents = CAMAS.Parse.parse_html(contents, ([ ]), 
			([ 
		       "camas_action" : container_notify_screen_camas_action
			]), id);

    return /*reload_parent + */contents;
  }
  else return "<!-- no new mail -->";
}

//! container: camas_action
//!  To do some actions
//! attribute: action
//!   The action to perform, can be checknewmail
//! parentcontainer: camas_new
//! note: screen: notify
string container_notify_screen_camas_action(string tag_name, mapping args, 
					    string contents, object id)
{

  switch(args->action)
  {
  case "reloadmail":
    args -> href = CAMAS.Tools.make_get_url(id, ([ "screen":"notify" ]), ([ "actionreloadactivemailboxes":"1" ]));
    break;
  default: 
    return sprintf("<!-- unknown tag %s -->\n", args->action);
  }

  if (!args->target && id->misc->camas->target != "")
    args->target = id->misc->camas->target;
  m_delete(args,"action");

  // Build an <a></> if the output isn't a button
  return CAMAS.Tools.make_container("a",args,contents);
}

//! container: camas_nonew
//!  Zone displayed when they aren't new mail
//! parentcontainer: camas_mailstatus
//! note: screen: notify
string container_notify_screen_nonewmail(string tag_name, mapping args, 
					 string contents, object id)
{
  if (CSESSION->hasnewmail < 1)
    return contents;
  else return "<!-- new mail -->";
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
