#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  FOLDERLIST screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out;
  CDEBUG("Folderlist SCREEN");
  CSESSION->screen = "folderlist";	// Admin screen name
  out = "<!-- Parsed by CAMAS tag module -->\n<!-- Beginning of screen_FOLDERLIST -->\n";
  contents = CAMAS.Parse.parse_html(contents,
                        ([
                         ]),
                        ([
			  "camas_folderlist"           : container_camas_folderlist,
                         ]),
                        id);
  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camasfolderlistform";

  args = CAMAS.Tools.set_target(id, args);
 
  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<!-- End of screen_FOLDERLIST -->";
  return out;
}

//! container: camas_folderlist
//!  Container for listing folders
//! childcontainer : folder
//! childcontainer : nofolder
//! note: screen: folderlist
string container_camas_folderlist(string tag_name, mapping args, string contents, object id)
{
  string out = "<!-- Begining of camas_folderlist -->";   // HTML to output
#define IM_CREATE 1
#define IM_DELETE 2
#define IM_RENAME 4

  int imap_operation = 0;

  string path = id->variables->path || CSESSION->lastpath;
  array mbox_path = ({ });

  // find the currently selected folder
  int mbox_idx = Array.search_array (CSESSION->mailboxes,
				     lambda (array a, string path) {
				       if (a[MB_FOLDERNAME_IDX] == path)
					 return 1;
				       return 0;
				     },
				     path);
  if (mbox_idx == -1)
    path = "";
  else
    mbox_path = CSESSION->mailboxes[mbox_idx][MB_HIERARCHY_IDX];
  // user can create mailboxes only under the namespace of the IMAP server
  // or if they already come from an existing mailbox
  if (!(CSESSION->mailbox[MB_FLAGS_IDX] & MB_IMPLICIT_FOLDER)
       && (path != "" || search(path, CSESSION->mailpath) == 0))
    imap_operation |= IM_CREATE;

  CSESSION->lastpath = path;

  // find the mailboxes at the current hierarchy level
  array mboxes_to_show = Array.filter (CSESSION->mailboxes,
                                       lambda (array a, array mbox_path) {
                                         if ((sizeof (a[MB_HIERARCHY_IDX])) <= (sizeof (mbox_path)) ||
					                                  (sizeof (a[MB_HIERARCHY_IDX])) > (sizeof (mbox_path)+1))
                                           return 0;
                                         for (int i = 0; i < sizeof (mbox_path); i++)
                                           if (mbox_path[i] != a[MB_HIERARCHY_IDX][i])
                                             return 0;
					 string mbname = a[MB_HIERARCHY_IDX][-1];
					 if (!(a[MB_FLAGS_IDX] & (MB_IMPLICIT_FOLDER)) &&
					       !(CAMAS.FolderTools.is_a_top_level_mailbox(a, CSESSION)
					          || CAMAS.FolderTools.is_a_special_folder(a, CSESSION)))
					   imap_operation |= (IM_RENAME | IM_DELETE);
                                         return 1;
                                       },
                                       mbox_path);

  if (path != "") { // if we're not at the top level, add a "up" pseudo folder
    array up_folder =
      ({
	({ "", // foldername
	   (CSESSION->mailboxes[mbox_idx][MB_HIERARCHY_IDX][0..sizeof(CSESSION->mailboxes[mbox_idx][MB_HIERARCHY_IDX])-2]) * CSESSION->mailboxes[mbox_idx][MB_SEPARATOR_IDX], // folder to select to go up in the hierarchy
	   MB_NOSELECT | MB_PREVIOUS_FOLDER, // flags
	   "", // no separator
            ({ MSG(M_PREVIOUS_LEVEL) })
	})
      });
    // write (sprintf ("up folder= %O\n", up_folder));
    mboxes_to_show = up_folder + mboxes_to_show;
    out += CAMAS.Tools.make_tag("input", ([ "type":"hidden", "name":"path", "value": path ]));
  }

  mapping containers =
    ([
      "camas_folder"     : container_camas_folderlist_folder,
      "camas_nofolder"   : container_camas_folderlist_nofolder,
      "camas_loop_quota" : container_camas_folderlist_loop_quota,
      ]);
  
  mapping tags =
    ([
      "camas_deletemarked"     : tag_camas_folderlist,
      "camas_create"           : tag_camas_folderlist,
      "camas_rename"           : tag_camas_folderlist,
      "camas_createfield"      : tag_camas_folderlist,
      "camas_rename_fromlist"  : tag_camas_folderlist,
      "camas_rename_tofield"   : tag_camas_folderlist,
    ]);
  
  out += CAMAS.Parse.parse_html(contents, tags, containers, 
				id, path, mboxes_to_show, imap_operation);
  out += "<!-- End of camas_folderlist -->";
  return out;
}

//! subcontainer : camas_folder
//! parentcontainer : camas_folderlist
//! childcontainer : camas_title
//! childcontainer : camas_contents
//!  &lt;camas_mail&gt;contents&lt;/camas_mail&gt; is displayed if there are mails to display
//! note: screen: folderlist
string container_camas_folderlist_folder(string tag_name, mapping args, string contents, object id, string path, array mboxes)
{
  int folders = sizeof(mboxes);
  string out = "<!-- Begining of folder -->";

  if(folders)
  {
    mapping containers =
    ([ 
      "camas_title"          : container_camas_folderlist_folder_title,
      "camas_contents"       : container_camas_folderlist_folder_contents,
    ]);
    
    out += CAMAS.Parse.parse_html(contents, ([ ]), containers, id, path, mboxes);
  }

  out += "<!-- End of folder -->";
  return out;
}

//! subcontainer : camas_nomail
//! parentcontainer : camas_mailindex
//!  &lt;camas_nomail&gt;contents&lt;/camas_nomail&gt; is displayed is there are no mails to display
//! note: screen: folderlist
string container_camas_folderlist_nofolder(string tag_name, mapping args, string contents, object id, string path, array mboxes)
{
  int folders = sizeof(mboxes);
  string out = "<!-- Begining of nofolder -->";
  string searchresult;

  if(!folders)
  {
    out += "<pre>No folder to list</pre>";
  }

  out += "<!-- End of nofolder -->";
  return out;
}

//! subcontainer : camas_folder
//! parentcontainer : camas_folderlist
//! variable : #quota# (the quota root name)
//! variable : #type# (the type of quota, for now message or storage)
//! variable : #current_value#
//! variable : #of# ('of' translated)
//! variable : #max_value# (the max value for this quota)
//! variable : #percent# 
//! variable : #used#
string container_camas_folderlist_loop_quota(string tag_name, mapping args, string contents, object id)
{
  string out = "";
  if(CSESSION->quota)
  {
    mapping type2translation = 
      ([ 
        "MESSAGE": MSG(M_MESSAGES),
        "STORAGE": MSG(M_SIZE)
      ]);
    string of = MSG(M_OF);
    string used = MSG(M_USED);
    string quota_name = MSG(M_QUOTA);
    foreach(indices(CSESSION->quota), string quotaroot)
    {
      foreach(indices(CSESSION->quota[quotaroot]), string type)
      {
        string current_value, max_value;
        [ current_value, max_value ] = CSESSION->quota[quotaroot][type];
        int int_current_value = (int) current_value;
        int int_max_value     = (int) max_value;
        if(type == "STORAGE")
        {
          current_value = CAMAS.Tools.display_size(int_current_value * 1000);
          max_value     = CAMAS.Tools.display_size(int_max_value * 1000);
        }
        if(type2translation[type])
          type = type2translation[type];
        string percent = (string)((int)((float) int_current_value / int_max_value * 100));
        array outlet =
        ({
          ([
             "quota_name"   : quota_name,
             "quota"        : quotaroot,
             "type"         : type,
             "of"           : of,
             "current_value": current_value,
             "max_value"    : max_value,
             "percent"      : percent,
             "used"         : used,
           ])
        });
        out += do_output_tag(args, outlet, contents, id);
      }
    }
  }
  return out;
}

//! subcontainer : camas_title
//! parentcontainer : camas_folder
//!  &lt;camas_title&lt;contents&gt;/camas_title&gt; is displayed one time
//!   variable : #folder#
//!   variable : #messages#
//!   variable : #unseen#
//!   variable : #size#
//!   variable : #path#
//!   variable : #quota#
//! note: screen: mailindex
string container_camas_folderlist_folder_title(string tag_name, mapping args, string contents, object id, string path)
{
  string out = "<!-- Begining of title -->";

  // TODO: maybe setting these stings outside this function would be more efficient
  string tsize_field    = MSG(M_TOTALSIZE);
  string of_field       = MSG(M_OF);
  string quota_field    = MSG(M_QUOTA);
  string folder_field   = MSG(M_FOLDER);
  string messages_field = MSG(M_MESSAGES);
  string unseen_field   = MSG(M_UNSEEN);
  string recent_field   = MSG(M_NEW);
  string size_field     = MSG(M_SIZE);

  array outlet =
  ({
    ([
      "folder"    : folder_field,
      "messages"  : messages_field,
      "recent"    : recent_field,
      "unseen"    : unseen_field,
      "size"      : size_field,
      "quota"     : quota_field,
      "path"	    : HTML_ENCODE_STRING(path),
    ])
  });

  out += do_output_tag(args, outlet, contents, id);
  out += "<!-- End of title -->";
  return out;
}

//! subcontainer : camas_contents
//! parentcontainer : camas_folder
//!  &lt;camas_contents&gt;contents&lt;/camas_contents&gt; is displayed as many times as there are visible folder/mbox
//! variable : ##
//! childcontainer : camas_href
//! note: screen: folderlist
string container_camas_folderlist_folder_contents(string tag_name, mapping args, string contents, object id, string path, array mboxes_to_show)
{
  object camas_main = CAMAS_MODULE;
  if (!objectp(camas_main))
  {
    CDEBUG("module camas_main is not present");
    return "foobar";
  }
  string out = "<!-- Begining of contents -->";

  string mark_field, name_field, messages_field, recent_field, unseen_field, size_field, quota_field;
  mapping args2 = ([ ]);

  foreach (mboxes_to_show, array mbox_a)
  {
    int haschildren;
    if (CSESSION->imapclient->capabilities["children"]) 
      // quick version 
      haschildren = !(mbox_a[MB_FLAGS_IDX] & MB_NOINFERIORS);
    else
      // For old imap server without the children extension
      // we can't rely on flag MB_NOINFERIORS
      haschildren = Array.search_array (CSESSION->mailboxes,
					lambda(array a,array mbox_path) {
					  if (sizeof(a[MB_HIERARCHY_IDX]) <= sizeof (mbox_path))
					    return 0;
					  int i;
					  for(i=0;i<sizeof(mbox_path);i++)
					    if(mbox_path[i]!=a[MB_HIERARCHY_IDX][i])
					      return 0;
					  return 1;
					},
					mbox_a[MB_HIERARCHY_IDX])
      != -1;
    int deletable=!((mbox_a[MB_FLAGS_IDX] & MB_PREVIOUS_FOLDER) ||
		    CAMAS.FolderTools.is_inbox(mbox_a,CSESSION) ||
                    CAMAS.FolderTools.is_a_special_folder(mbox_a,CSESSION) ||
                    (mbox_a[MB_FLAGS_IDX] & MB_IMPLICIT_FOLDER) ||
                    // folder has children?
                    (haschildren));

    string mbox_name = CAMAS.FolderTools.translate_frommbox (id, mbox_a);
    string mbname = mbox_a[MB_FOLDERNAME_IDX];

    if (deletable)
    {
      args2 -> type = "checkbox";
      args2 -> name = "delf_"+mbox_a[MB_FOLDERNAME_IDX];
      args2 -> value= "1";
      
      mark_field = CAMAS.Tools.make_tag("input", args2);
    }
    else
      mark_field = "&nbsp;";
    
    if (!(mbox_a[MB_FLAGS_IDX] & MB_PREVIOUS_FOLDER)) 
    {
      messages_field = (string)CSESSION->foldersinfo[mbname][MB_MESSAGES_IDX];
      recent_field = (string)CSESSION->foldersinfo[mbname][MB_RECENT_IDX];
      unseen_field = (string)CSESSION->foldersinfo[mbname][MB_UNSEEN_IDX];
      if(CSESSION->foldersinfo[mbname][MB_SIZE_IDX] != MB_UNKNOWN_SIZE)
        size_field = CAMAS.Tools.display_size(CSESSION->foldersinfo[mbname][MB_SIZE_IDX]);
      else
        size_field = "?";
      if(CSESSION->quota && CSESSION->quota[CSESSION->mailbox2rootname[mbox_a[MB_FOLDERNAME_IDX]]])
      {
       quota_field = CSESSION->mailbox2rootname[mbox_a[MB_FOLDERNAME_IDX]];
      }
      else
        quota_field = "";
    }
    else
    {
      messages_field = "";
      recent_field = "";
      unseen_field = "";
      size_field = "";
      quota_field = "";
    }
    name_field = mbox_name;
    
    array outlet = ({
      ([
    	"mark"         : mark_field,
    	"name"         : name_field,
    	"messages"     : messages_field,
    	"recent"       : recent_field,
    	"unseen"       : unseen_field,
    	"size"         : size_field,
    	"quota"        : quota_field,
      ])
    });
    
    out += do_output_tag(args, outlet, contents, id);
    
    out = CAMAS.Parse.parse_html(out,
				 ([ ]),
				 ([
				   "camas_href" : container_camas_folderlist_folder_contents_href,
				 ]),
				 id, mbox_a);
    
  }
  
  out += "<!-- End of contents -->";
  return out;
}

//! subcontainer : camas_href
//! parentcontainer : camas_contents
//!  Clickable zone delimiter
//! attribute: action
//!  The action to perform either opendir or openfld
//! attribute: invalid
//!  What to do if href is invalid (by default output nothing, if 
//!           set to 'content' output the content of the container)
//! note: screen: folderlist
string container_camas_folderlist_folder_contents_href(string tag_name, mapping args, string contents, object id, array mbox_a)
{
  mapping vars = ([ ]);
  string out = "";
  int    output_content = 0;

  if (args -> invalid == "content")
    output_content = 1;
  m_delete(args,"invalid");

  switch(args->action)
  {
  case "openfld":
    if (!(mbox_a[MB_FLAGS_IDX] & (MB_NOSELECT | MB_IMPLICIT_FOLDER))) 
    {
      vars = ([ 
	"actionmailindex" : "1", 
	"mbox" : HTML_ENCODE_STRING(mbox_a[MB_FOLDERNAME_IDX]) 
      ]);
      args -> href = CAMAS.Tools->make_get_url(id, args, vars);
    }
    else
    {
      out += "<!-- Not a folder -->";
      if (output_content)
	out += contents;
      return out;
    }
    break;
  case "opendir":
    if (!(mbox_a[MB_FLAGS_IDX] & MB_NOINFERIORS)) 
    {
      vars = ([ 
	"actionfolderlist" : "1", 
	"path" : HTML_ENCODE_STRING(mbox_a[MB_FOLDERNAME_IDX]),
      ]);
      if (mbox_a[MB_FLAGS_IDX] & MB_PREVIOUS_FOLDER)
	vars -> path = HTML_ENCODE_STRING(mbox_a[MB_DISPLAYNAME_IDX]);
      args -> href = CAMAS.Tools->make_get_url(id, args, vars);
    }
    else 
    {
      out += "<!-- Not a directory -->";
      if (output_content)
	out += contents;
      return out;
    }
    break;

  default:
    CDEBUG("The arg "+args->action+" in container_camas_folderlist_folder_contents_href isn't available");
  }
  m_delete(args,"action");

  out += CAMAS.Tools.make_container("a", args, contents);
  return out;
}


/* code for most folderlist screen tags */
string tag_camas_folderlist(string tag_name, mapping args, object id, string path, array mboxes, int imap_operation)
{
/*  object camas_main = CAMAS_MODULE;
  if (!objectp (camas_main)) {
    CDEBUG("module camas_main is not present");
    return "foobar";
  }

  object camas_features = id->conf->get_provider("camas_features");
  if (!objectp (camas_features)) {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }
*/  string out;

  switch(tag_name)
  {
  case "camas_deletemarked":
    //! tag: camas_deletemaked
    //!  Button for permanently deleting the selected mails.
    //! screen : folderlist
    if (imap_operation & IM_DELETE)
      out = CAMAS.Tools.formdrawbutton(id,"m_deletemarkedmbox", "actiondeletefolder", MSG(M_DELETEMARKEDMBOX), args);
    else
      out = "<!-- tag_camas_folderlist: folder creation impossible here -->";
    break;

  case "camas_create":
    //! tag: camas_create
    //!  Button for creating folder
    //! screen : folderlist

    if (imap_operation & IM_CREATE)
      out = CAMAS.Tools.formdrawbutton(id,"m_creatembox", "actioncreatefolder", MSG(M_CREATEMBOX), args);
    else
      out = "<!-- tag_camas_folderlist: folder creation impossible here -->";
    break;

  case "camas_createfield":
    //! tag: camas_createfield
    //!  Field for the creation
    //! screen : folderlist
    if (imap_operation & IM_CREATE) 
    {
      args -> name = "foldername";
      args -> value= MSG(M_NEWMBOXNAME);
      if (id->supports->javascript)
	args -> onchange = "this.form.actioncreatefolder.click()";
      
      out = CAMAS.Tools.make_tag("input", args);
    }
    else
    {
      out = "<!-- tag_camas_folderlist: folder creation impossible here -->";
    }
    break;

  case "camas_rename":
    //! tag: camas_rename
    //!  Button for permanently renaming a folder.
    //! screen : folderlist
    if (imap_operation & IM_RENAME)
      out = CAMAS.Tools.formdrawbutton(id,"m_renamembox", "actionrenamefolder", MSG(M_RENAMEMBOX), args);
    else
      out = "<!-- folder rename impossible here -->";
    break;

  case "camas_rename_fromlist":
    //! tag: camas_rename_fromlist
    //!  Field for selecting the folder to be renamed..
    //! screen : folderlist
    // find the renamable mailboxes
    if (imap_operation & IM_RENAME)
    {
      array folders = Array.filter (mboxes,
				    lambda (array a) {
				      string mbname = a[MB_HIERARCHY_IDX][-1];
				      if (a[MB_FLAGS_IDX] & (MB_IMPLICIT_FOLDER) ||
					  (mbname == "INBOX") ||
					  (mbname == CSESSION->sentfolder) ||
					  (mbname == CSESSION->trashfolder) ||
					  (mbname == CSESSION->draftsfolder) ||
					  (mbname == CSESSION->answeredfolder) ||
					  (mbname == CSESSION->prefsbox))
					return 0;
				      return 1;
				    });
      
      mapping optionargs = CAMAS.Tools.extract_html_attributes(args, "option");
      
      optionargs->value = "imhonomailbox";
      string contents = CAMAS.Tools.make_container("option", optionargs, MSG(M_SELECT)+"...")+"\n";
      if(folders)
        foreach(folders, array f)
        {
	  optionargs->value = HTML_ENCODE_STRING (f[MB_FOLDERNAME_IDX]);	  
       	  contents += CAMAS.Tools.make_container("option", optionargs, HTML_ENCODE_STRING(CAMAS.FolderTools.translate_frommbox(id, f)));
        }
      
      m_delete(args, "value");
      args->name = "oldfoldername";
      
      out = CAMAS.Tools.make_container("select", args, contents) + "\n";
    }
    else
      out = "<!-- folder rename impossible here -->";
    break;

  case "camas_rename_tofield":
    //! tag: camas_renamoe_tofield
    //!  Field for storing the new name.
    //! screen : folderlist
    if (imap_operation & IM_RENAME)
    {
      args -> name = "newfoldername";
      args -> value= MSG(M_NEWMBOXNAME);
      if (id->supports->javascript)
	args -> onchange = "this.form.actionrenamefolder.click()";
      
      out = CAMAS.Tools.make_tag("input", args);
    }
    else
      out = "<!-- folder rename impossible here-->";
    break;

  default:
    out += "<!-- " + tag_name + " is not supported yet -->";
    CDEBUG("tag_camas_folderlist: " + tag_name + " is not supported yet");
  } // switch
  
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
