/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: compat.h,v 1.6 2004/01/13 11:01:36 vida Exp $
 */

/* This file provide compatibility between Caudium 1.2 and 1.4 */

#ifndef __COMPAT_H
#define __COMPAT_H

#if constant (_Roxen.http_decode_string)
#define HTTP_DECODE_STRING _Roxen.http_decode_string
#else
#define HTTP_DECODE_STRING http_decode_string
#endif

#if constant(_Roxen.html_encode_string)
#define HTML_ENCODE_STRING _Roxen.html_encode_string
#else
#define HTML_ENCODE_STRING html_encode_string
#endif

#if constant(Protocols.HTTP.unentity)
#define HTML_DECODE_STRING Protocols.HTTP.unentity
#else
#define HTML_DECODE_STRING html_decode_string
#endif

#if constant(Caudium.http_encode_string)
#define HTTP_ENCODE_STRING Caudium.http_encode_string
#else
#define HTTP_ENCODE_STRING http_encode_string
#endif

#if constant(Caudium.HTTP.decode_url)
#define HTTP_DECODE_URL Caudium.HTTP.decode_url
#else
#define HTTP_DECODE_URL http_decode_url
#endif

#if constant(Caudium.http_encode_url)
#define HTTP_ENCODE_URL Caudium.http_encode_url
#else
#define HTTP_ENCODE_URL http_encode_url
#endif

#if constant(Caudium.http_encode_cookie)
#define HTTP_ENCODE_COOKIE Caudium.http_encode_cookie
#else
#define HTTP_ENCODE_COOKIE http_encode_cookie
#endif

#if constant(Caudium.HTTP.cern_date)
#define CERN_HTTP_DATE Caudium.HTTP.cern_date
#else
#define CERN_HTTP_DATE cern_http_date
#endif

#if constant(Caudium.HTTP.date)
#define HTTP_DATE Caudium.HTTP.date
#else
#define HTTP_DATE http_date
#endif

#if constant(Caudium.HTTP.res_to_string)
#define HTTP_RES_TO_STRING Caudium.HTTP.res_to_string
#else
#define HTTP_RES_TO_STRING http_res_to_string
#endif

#if constant(Caudium.HTTP.low_answer)
#define HTTP_LOW_ANSWER Caudium.HTTP.low_answer
#else
#define HTTP_LOW_ANSWER http_low_answer
#endif

#if constant(Caudium.HTTP.pipe_in_progress) 
#define HTTP_PIPE_IN_PROGRESS Caudium.HTTP.pipe_in_progress
#else 
#define HTTP_PIPE_IN_PROGRESS http_pipe_in_progress
#endif 

#if constant(Caudium.HTTP.rxml_answer) 
#define HTTP_RXML_ANSWER Caudium.HTTP.rxml_answer 
#else 
#define HTTP_RXML_ANSWER http_rxml_answer
#endif 

#if constant(Caudium.HTTP.error_answer) 
#define HTTP_ERROR_ANSWER Caudium.HTTP.error_answer
#else
#define HTTP_ERROR_ANSWER http_error_answer
#endif
 
#if constant(Caudium.HTTP.string_answer) 
#define HTTP_STRING_ANSWER Caudium.HTTP.string_answer
#else
#define HTTP_STRING_ANSWER http_string_answer
#endif
 
#if constant(Caudium.HTTP.make_htmldoc_string) 
#define MAKE_HTMLDOC_STRING Caudium.HTTP.make_htmldoc_string
#else
#define MAKE_HTMLDOC_STRING make_html_doc_string
#endif

#if constant(Caudium.HTTP.htmldoc_answer) 
#define HTTP_HTMLDOC_ANSWER Caudium.HTTP.htmldoc_answer
#else
#define HTTP_HTMLDOC_ANSWER http_htmldoc_answer 
#endif

#if constant(Caudium.HTTP.file_answer) 
#define HTTP_FILE_ANSWER Caudium.HTTP.file_answer
#else
#define HTTP_FILE_ANSWER http_file_answer
#endif

#if constant(Caudium.HTTP.redirect) 
#define HTTP_REDIRECT Caudium.HTTP.redirect
#else
#define HTTP_REDIRECT http_redirect
#endif

#if constant(Caudium.HTTP.stream) 
#define HTTP_STREAM Caudium.HTTP.stream
#else
#define HTTP_STREAM http_stream
#endif

#if constant(Caudium.HTTP.auth_required) 
#define HTTP_AUTH_REQUIRED Caudium.HTTP.auth_required
#else
#define HTTP_AUTH_REQUIRED http_auth_required
#endif

#if constant(Caudium.HTTP.auth_required)
#define HTTP_PROXY_AUTH_REQUIRED Caudium.HTTP.auth_required
#else
#define HTTP_PROXY_AUTH_REQUIRED http_proxy_auth_required
#endif

#if constant(Caudium.HTTP.proxy_auth_needed)
#define HTTP_PROXY_AUTH_NEEDED Caudium.HTTP.proxy_auth_needed
#else
#define HTTP_PROXY_AUTH_NEEDED proxy_auth_needed
#endif

#if constant(Caudium.add_pre_state) 
#define ADD_PRE_STATE Caudium.add_pre_state
#else
#define ADD_PRE_STATE add_pre_state
#endif

#if constant(Caudium._match) 
#define _MATCH Caudium._match
#else
#define _MATCH _match
#endif

#if constant(Caudium.short_name)
#define SHORT_NAME Caudium.short_name
#else
#define SHORT_NAME short_name
#endif

#if constant(Caudium.strip_config)
#define STRIP_CONFIG Caudium.strip_config
#else
#define STRIP_CONFIG strip_config
#endif

#if constant(Caudium.strip_prestate)
#define STRIP_PRESTATE Caudium.strip_prestate
#else 
#define STRIP_PRESTATE strip_prestate
#endif 

#if constant(Caudium.short_date)
#define SHORT_DATE Caudium.short_date
#else  
#define SHORT_DATE short_date
#endif  

#if constant(Caudium.is_modified)
#define IS_MODIFIED Caudium.is_modified
#else  
#define IS_MODIFIED is_modified
#endif  

#if constant(Caudium.html_to_unicode)
#define HTML_TO_UNICODE Caudium.html_to_unicode
#else  
#define HTML_TO_UNICODE html_to_unicode
#endif  

#if constant(Caudium.unicode_to_html)
#define UNICODE_TO_HTML Caudium.unicode_to_html
#else  
#define UNICODE_TO_HTML unicode_to_html
#endif  

#if constant(Caudium.is_safe_string)
#define IS_SAFE_STRING Caudium.is_safe_string
#else  
#define IS_SAFE_STRING is_safe_string
#endif  

#if constant(Caudium.simplify_path)
#define SIMPLIFY_PATH Caudium.simplify_path
#else  
#define SIMPLIFY_PATH simplify_path
#endif  

#if constant(Caudium.httpdate_to_time)
#define HTTPDATE_TO_TIME Caudium.httpdate_to_time
#else  
#define HTTPDATE_TO_TIME httpdate_to_time
#endif  

#if constant(Caudium.int2roman)
#define INT2ROMAN Caudium.int2roman
#else  
#define INT2ROMAN int2roman
#endif  

#if constant(Caudium.number2string)
#define NUMBER2STRING Caudium.number2string
#else  
#define NUMBER2STRING number2string
#endif  

#if constant(Caudium.image_from_type)
#define IMAGE_FROM_TYPE Caudium.image_from_type
#else  
#define IMAGE_FROM_TYPE image_from_type
#endif  

#if constant(Caudium.html_encode_tag_value)
#define HTML_ENCODE_TAG_VALUE Caudium.html_encode_tag_value
#else  
#define HTML_ENCODE_TAG_VALUE html_encode_tag_value
#endif  

#if constant(Caudium.get_modfullname)
#define GET_MODFULLNAME Caudium.get_modfullname
#else  
#define GET_MODFULLNAME get_modfullname
#endif  

#if constant(Caudium.File.decode_mode)
#define DECODE_MODE Caudium.File.decode_mode
#else  
#define DECODE_MODE decode_mode
#endif  

#if constant(Caudium.fix_relative)
#define FIX_RELATIVE Caudium.fix_relative
#else  
#define FIX_RELATIVE fix_relative
#endif  

#if constant(Caudium.strftime)
#define STRFTIME Caudium.strftime
#else  
#define STRFTIME strftime
#endif  

#if constant(Caudium.Env.build_vars)
#define BUILD_ENV_VARS Caudium.Env.build_vars
#else  
#define BUILD_ENV_VARS build_env_vars
#endif  

#if constant(Caudium.Env.build_caudium_vars)
#define BUILD_CAUDIUM_ENV_VARS Caudium.Env.build_caudium_vars
#else
#define BUILD_CAUDIUM_ENV_VARS build_caudium_env_vars
#endif  

#endif // __COMPAT_H
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

