#include "%{APPNAMELC}_converter.h"

#include <kapplication.h>

#include <kio/netaccess.h>
#include <kio/deletejob.h>

#include <kis_doc2.h>
#include <kis_image.h>
#include <kis_paint_layer.h>


%{APPNAME}Converter::%{APPNAME}Converter(KisDoc2 *doc)
{
    m_doc = doc;
    m_job = 0;
    m_stop = false;
}

%{APPNAME}Converter::~%{APPNAME}Converter()
{
}

KisImageBuilder_Result %{APPNAME}Converter::decode(const KUrl& uri)
{
    // open the file
#if 0
     FILE *fp = fopen(QFile::encodeName(uri.toLocalFile()), "rb");
    if (!fp)
    {
        return (KisImageBuilder_RESULT_NOT_EXIST);
    }
    // Creating the KisImageWSP
    if(!m_image) {
        m_image = new KisImage(m_doc->createUndoStore(),  cinfo.image_width,  cinfo.image_height, cs, "built image");
        Q_CHECK_PTR(m_image);
        m_image->lock();
    }
    KisPaintLayerSP layer = new KisPaintLayer(m_image.data(), m_image->nextLayerName(), quint8_MAX));
#endif

    return KisImageBuilder_RESULT_OK;
}



KisImageBuilder_Result %{APPNAME}Converter::buildImage(const KUrl& uri)
{
    if (uri.isEmpty())
        return KisImageBuilder_RESULT_NO_URI;

    if (!KIO::NetAccess::exists(uri, false, QApplication::activeWindow())) {
        return KisImageBuilder_RESULT_NOT_EXIST;
    }

    // We're not set up to handle asynchronous loading at the moment.
    KisImageBuilder_Result result = KisImageBuilder_RESULT_FAILURE;
    QString tmpFile;

    if (KIO::NetAccess::download(uri, tmpFile, qApp->activeWindow())) {
        KUrl uriTF;
        uriTF.setPath( tmpFile );
        result = decode(uriTF);
        KIO::NetAccess::removeTempFile(tmpFile);
    }

    return result;
}


KisImageWSP %{APPNAME}Converter::image()
{
    return m_image;
}


KisImageBuilder_Result %{APPNAME}Converter::buildFile(const KUrl& uri, KisPaintLayerSP layer)
{
    if (!layer)
        return KisImageBuilder_RESULT_INVALID_ARG;

    KisImageWSP image = layer->image();
    if (!image)
        return KisImageBuilder_RESULT_EMPTY;

    if (uri.isEmpty())
        return KisImageBuilder_RESULT_NO_URI;

    if (!uri.isLocalFile())
        return KisImageBuilder_RESULT_NOT_LOCAL;
    // Open file for writing
#if 0
    FILE *fp = fopen(QFile::encodeName(uri.path()), "wb");
    if (!fp)
    {
        return (KisImageBuilder_RESULT_FAILURE);
    }
    uint height = image->height();
    uint width = image->width();
#endif

    return KisImageBuilder_RESULT_OK;
}


void %{APPNAME}Converter::cancel()
{
    m_stop = true;
}

#include "%{APPNAMELC}_converter.moc"

