"""
COMMAND-LINE SPECIFIC STUFF
=============================================================================

The rest of the code is specifically for handling the case where Python
Markdown is called from the command line.
"""

import markdown
import sys
import logging
from logging import DEBUG, INFO, CRITICAL

EXECUTABLE_NAME_FOR_USAGE = "python markdown.py"
""" The name used in the usage statement displayed for python versions < 2.3.
(With python 2.3 and higher the usage statement is generated by optparse
and uses the actual name of the executable called.) """

OPTPARSE_WARNING = """
Python 2.3 or higher required for advanced command line options.
For lower versions of Python use:

      %s INPUT_FILE > OUTPUT_FILE

""" % EXECUTABLE_NAME_FOR_USAGE

def parse_options():
    """
    Define and parse `optparse` options for command-line usage.
    """

    try:
        optparse = __import__("optparse")
    except:
        if len(sys.argv) == 2:
            return {'input': sys.argv[1],
                    'output': None,
                    'safe': False,
                    'extensions': [],
                    'encoding': None }, CRITICAL
        else:
            print OPTPARSE_WARNING
            return None, None

    parser = optparse.OptionParser(usage="%prog INPUTFILE [options]")
    parser.add_option("-f", "--file", dest="filename", default=sys.stdout,
                      help="write output to OUTPUT_FILE",
                      metavar="OUTPUT_FILE")
    parser.add_option("-e", "--encoding", dest="encoding",
                      help="encoding for input and output files",)
    parser.add_option("-q", "--quiet", default = CRITICAL,
                      action="store_const", const=CRITICAL+10, dest="verbose",
                      help="suppress all messages")
    parser.add_option("-v", "--verbose",
                      action="store_const", const=INFO, dest="verbose",
                      help="print info messages")
    parser.add_option("-s", "--safe", dest="safe", default=False,
                      metavar="SAFE_MODE",
                      help="safe mode ('replace', 'remove' or 'escape'  user's HTML tag)")
    parser.add_option("-o", "--output_format", dest="output_format",
                      default='xhtml1', metavar="OUTPUT_FORMAT",
                      help="Format of output. One of 'xhtml1' (default) or 'html4'.")
    parser.add_option("--noisy",
                      action="store_const", const=DEBUG, dest="verbose",
                      help="print debug messages")
    parser.add_option("-x", "--extension", action="append", dest="extensions",
                      help = "load extension EXTENSION", metavar="EXTENSION")

    (options, args) = parser.parse_args()

    if not len(args) == 1:
        parser.print_help()
        return None, None
    else:
        input_file = args[0]

    if not options.extensions:
        options.extensions = []

    return {'input': input_file,
            'output': options.filename,
            'safe_mode': options.safe,
            'extensions': options.extensions,
            'encoding': options.encoding,
            'output_format': options.output_format}, options.verbose

def run():
    """Run Markdown from the command line."""

    # Parse options and adjust logging level if necessary
    options, logging_level = parse_options()
    if not options: sys.exit(0)
    if logging_level: logging.getLogger('MARKDOWN').setLevel(logging_level)

    # Run
    markdown.markdownFromFile(**options)
