#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Wasabi <wasabi at tnxm.net>'
'''
tnxm.net
'''

from calibre.web.feeds.news import BasicNewsRecipe

class TNXM(BasicNewsRecipe):
    title          = u'Thanh Nien Xa Me'
    __author__     = 'Wasabi'
    description    = 'Vietnam news and current affairs from TNXM - the finest Vietnamese bulletin board.'
    no_stylesheets = True
    language = 'vi'

    encoding = 'utf-8'
    recursions = 0

    remove_tags    = [dict(name='div', attrs={'class':'footer'})]
    extra_css      = '.headline {font-size: x-large;} \n .fact { padding-top: 10pt  }' 

    feeds          = [
                      ('Index', 'http://tnxm.net/external.php?type=RSS'), 
                    ]

    def print_version(self, url):
        return url.replace('showthread.php?', 'printthread.php?pp=160&')
