#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import with_statement

__license__   = 'GPL v3'
__copyright__ = '2009, Kovid Goyal <kovid@kovidgoyal.net> edited by Huan T'

from calibre.web.feeds.news import BasicNewsRecipe

class Slashdot(BasicNewsRecipe):
             title          = u'Slashdot.org'
             oldest_article = 7
             max_articles_per_feed = 100
             language = 'en'

             __author__ = 'floweros edited by Huan T'
             no_stylesheets = True
#             keep_only_tags = [
#                 dict(name='div',attrs={'class':'article'}),
#                 dict(name='div',attrs={'class':'commentTop'}),
#                 ]

             feeds          = [
                 (u'Slashdot',
 u'http://rss.slashdot.org/Slashdot/slashdot'),
                 (u'/. IT',
 u'http://rss.slashdot.org/Slashdot/slashdotIT'),
                 (u'/. Hardware',
 u'http://rss.slashdot.org/Slashdot/slashdotHardware'),
                 (u'/. Linux',
 u'http://rss.slashdot.org/Slashdot/slashdotLinux'),
                 (u'/. Your Rights Online',
 u'http://rss.slashdot.org/Slashdot/slashdotYourRightsOnline')
                 ]

             def get_article_url(self, article):
                          return article.get('feedburner_origlink', None)
