#!/usr/bin/perl -w

# $Id: Cabot.pm.in 145 2004-04-26 21:22:59Z weasel $

# Copyright (c) 2001, 2003, 2004 Peter Palfrader
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Privacy Guard; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#

package Cabot;

use warnings;
use strict;
use IO::Handle;
use IO::Select;
use English;
use File::Path;
use GnuPG::Interface;

BEGIN {
	use Exporter ();
	our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

	$VERSION = '0.0.20040411';
	@ISA = qw(Exporter);
	@EXPORT = qw(%CONFIG $VERSION &getkeydir &makekeydir &mkfds &readwritegpg &ask);
	@EXPORT_OK = qw(%CONFIG $VERSION &getkeydir &makekeydir &mkfds &readwritegpg &ask);
	%EXPORT_TAGS = ( );
	push @EXPORT_OK, '&genrandstring';
	%EXPORT_TAGS = ( );
}

our @EXPORT_OK;

our %CONFIG;

sub getkeydir($$;$) {
	my ($what, $keyid, $uid) = @_;
	$keyid =~ s/[^A-Za-z0-9 +_@<>()'.-]/_/g;
	$uid =~ s/[^A-Za-z0-9 +_@<>()'.-]/_/g  if defined $uid;
	return $CONFIG{$what}.'/'.$keyid. ( defined $uid ? '/'.$uid : '' );
}

sub makekeydir($$;$) {
	my ($what, $keyid, $uid) = @_;
	unless ( -d $CONFIG{$what} ) {
		mkpath($CONFIG{$what}, 0, 0711) or
			die "Cannot create dir ".$CONFIG{$what}."\n";
	}
	unless ( -d getkeydir($what, $keyid) ) {
		mkpath(getkeydir($what, $keyid), 0, 0711) or
			die "Cannot create dir ".getkeydir($what, $keyid)."\n";
	}
	return unless defined $uid;
	unless ( -d getkeydir($what, $keyid, $uid) ) {
		mkpath(getkeydir($what, $keyid, $uid), 0, 0711) or
			die "Cannot create dir ".getkeydir($what, $keyid, $uid)."\n";
	}
}

sub mkfds() {
	my %fds = (
		stdin => IO::Handle->new(),
		stdout => IO::Handle->new(),
		stderr => IO::Handle->new(),
		status => IO::Handle->new() );
	my $handles = GnuPG::Handles->new( %fds );
	return ($fds{'stdin'}, $fds{'stdout'}, $fds{'stderr'}, $fds{'status'}, $handles);
};

sub readwritegpg($$$$$) {
	my ($in, $inputfd, $stdoutfd, $stderrfd, $statusfd) = @_;
	local $INPUT_RECORD_SEPARATOR = undef;
	my $sout = IO::Select->new();
	my $sin = IO::Select->new();
	my $offset = 0;

	$inputfd->blocking(0);
	$stdoutfd->blocking(0);
	$statusfd->blocking(0);
	$stderrfd->blocking(0);
	$sout->add($stdoutfd);
	$sout->add($stderrfd);
	$sout->add($statusfd);
	$sin->add($inputfd);

	my ($stdout, $stderr, $status) = ("", "", "");

	my ($readyr, $readyw, $written);
	while ($sout->count() > 0) {
		($readyr, $readyw, undef) = IO::Select::select($sout, $sin, undef, 42);
		foreach my $wfd (@$readyw) {
			$written = $wfd->syswrite($in, length($in) - $offset, $offset);
			$offset += $written;
			if ($offset == length($in)) {
				close $wfd;
				$sin->remove($wfd);
				$sin = undef;
			}
		}

		next unless (defined(@$readyr)); # Wait some more.

		for my $rfd (@$readyr) {
			if ($rfd->eof) {
				$sout->remove($rfd);
				close($rfd);
				next;
			}
			if ($rfd == $stdoutfd) {
				$stdout .= <$rfd>;
				next;
			}
			if ($rfd == $statusfd) {
				$status .= <$rfd>;
				next;
			}
			if ($rfd == $stderrfd) {
				$stderr .= <$rfd>;
				next;
			}
		}
	}
	return ($stdout, $stderr, $status);
}

sub ask($$) {
	my ($question, $default) = @_;
	my $answer;
	while (1) {
		print $question,' ',($default ? '[Y/n]' : '[y/N]'), ' ';
		$answer = <STDIN>;
		chomp $answer;
		last if ((defined $answer) && (length $answer <= 1));
		print "grrrrrr.\n";
		sleep 1;
	};
	my $result = $default;
	$result = 1 if $answer =~ /y/i;
	$result = 0 if $answer =~ /n/i;
	return $result;
};

sub genrandstring($) {
	my ($size) = @_;
	my $ret = "";
	return "" if ($size <= 0);
	for (my $i = 0; $i < $size; $i++) {
		$ret .= ("A" .. "Z", "a" .."z")[rand 52];
	}
	return $ret;
}

1;
