#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "list.h"

List
NewList (void)
{
  List l = malloc (sizeof (node));
  l->next = NULL;
  return l;
}

void
DeleteList (List l)
{
  Ptrnode p, tmp;

  p = l->next;
  l->next = NULL;
  while (p != NULL)
    {
      tmp = p->next;
      free (p);
      p = tmp;
    }
}

Ptrnode
NextInList (Ptrnode p)
{
  return p->next;
}

Ptrnode
FirstInList (List l)
{
  return l->next;
}


Ptrnode
HeaderList (List l)
{
  return l;
}

void
InsertInList (elementT t, Ptrnode p, List l)
{
  Ptrnode tmp;

  tmp = malloc (sizeof (node));
  tmp->elemento = t;
  tmp->next = p->next;
  p->next = tmp;
}

void
DeleteOfList (Ptrnode p, List l)
{
  Ptrnode tmp;

  tmp = FirstInList (l);
  while ((tmp->next != p) && (tmp))
    tmp = NextInList (tmp);

  if (tmp)
    {
      tmp->next = p->next;
      free (p);
    }
}

elementT
RetrieveFromList (Ptrnode p)
{
  return p->elemento;
}

char *
FindSelectedJidResourceInList (int selected, List roster)
{
  Ptrnode p;
  elementT elemento;
  int c;

  p = FirstInList (roster);
  for (c = 0; c < selected; c++)
    p = NextInList (p);

  elemento = RetrieveFromList (p);
  return elemento->resource;
}

char *
FindSelectedJidJidInList (int selected, List l)
{
  Ptrnode p;
  elementT elemento;
  int c;

  p = FirstInList (l);
  for (c = 0; c < selected; c++)
    p = NextInList (p);

  elemento = RetrieveFromList (p);
  return elemento->jid;
}

char *
FindSelectedJidInList (int selected, List l)
{
  Ptrnode p;
  elementT elemento;
  int c;

  p = FirstInList (l);
  for (c = 0; c < selected; c++)
    p = NextInList (p);

  elemento = RetrieveFromList (p);
  return elemento->name;
}

char *
FindJidInList (char *jid, List l)
{
  Ptrnode p;
  elementT elemento;
  char *aux;

  aux = strchr (jid, '/');
  if (aux)
    {
      aux = '\0';
    }

  p = FirstInList (l);
  while (p != NULL)
    {
      elemento = RetrieveFromList (p);
      if (!strcmp (jid, elemento->jid))
	return elemento->jid;
      p = NextInList (p);
    }
  return NULL;
}

char *
FindJidNameInList (char *jid, List l)
{
  Ptrnode p;
  elementT elemento;
  char *aux;

  aux = strchr (jid, '/');
  if (aux)
    {
      *aux = '\0';
    }

  p = FirstInList (l);
  while (p != NULL)
    {
      elemento = RetrieveFromList (p);
      p = NextInList (p);
      if (!strncmp (elemento->jid, jid, strlen (jid)))
	return elemento->name;
    }
  return NULL;
}

int
compara (const char *str1, const char *str2)
{
  int i, lim;

  if (strlen (str1) < strlen (str2))
    lim = strlen (str1);
  else
    lim = strlen (str2);

  for (i = 0; i < lim; i++)
    {
      if (str1[i] < str2[i])
	return 1;		// str1 < str2
      if (str1[i] > str2[i])
	return 2;		// str1 > str2
    }
  return 0;			// str1 == str2
}

void
SortListByName (List l)
{
  int i, j;
  int tam = 1;
  elementT temp, temp2;
  Ptrnode p;

  // count elements
  p = FirstInList (l);
  while ((p = NextInList (p)))
    tam++;

  for (i = 1; i < tam; i++)
    {
      for (j = 1; j < tam; j++)
	{
	  if (j == 1)
	    p = FirstInList (l);
	  else if (p)
	    p = NextInList (p);
	  else
	    break;

	  if (p)
	    temp = RetrieveFromList (p);
	  else
	    break;

	  p = NextInList (p);
	  if (p)
	    temp2 = RetrieveFromList (p);
	  else
	    break;

	  //p=Previous(p);
	  {
	    int co;
	    p = FirstInList (l);
	    for (co = 0; co < j - 1; co++)
	      p = NextInList (p);
	  }

	  if ((temp) && (temp2))
	    {
	      switch (compara (temp->name, temp2->name))
		{
		case 2:
		  {
		    elementT tmp;

		    tmp = malloc (sizeof (element));

		    memcpy (tmp, temp2, sizeof (element));
		    memcpy (temp2, temp, sizeof (element));
		    memcpy (temp, tmp, sizeof (element));

		    free (tmp);
		    break;
		  }

		default:
		  break;
		}
	    }
	}
    }
}
