'\"t
.\" The first line of this file must contain the '"[e][r][t][v] line
.\" to tell man to run the appropriate filter "t" for table.
.\"
.\"	$Id$
.\"
.\"######################################################################
.\"#									#
.\"#			   Copyright (C)  2004				#
.\"#	     			Internet2				#
.\"#			   All Rights Reserved				#
.\"#									#
.\"######################################################################
.\"
.\"	File:		bwctld.limits.man
.\"
.\"	Author:		Jeff Boote
.\"			Internet2
.\"
.\"	Date:		Fri Feb 13 12:45:52 MST 2004
.\"
.\"	Description:
.\"
.TH bwctld.limits 5 "$Date$"
.SH NAME
bwctld.limits \- \fBB\fRand\fBw\fRidth \fBC\fRon\fBt\fRro\fBl\fR
\fBd\fRaemon policy configuration file
.SH DESCRIPTION
The \fBbwctld.limits\fR file is used to define the policy configuration
for the \fBbwctld\fR program. It allows the system administrator to
allocate the resources in a variety of ways.
.PP
There are two parts to the policy configuration:
.TP
Authentication
Who is making the request? This can be very specific to an individual
user or it can be more general in that the connection is coming from
some particular network.
.TP
Authorization
Now that the connection has been generally identified, what will \fBbwctld\fR
allow it to do?
.PP
The authentication is done by assigning a \fIuserclass\fR to each new
connection as it comes in. Each \fIuserclass\fR has a set of limits
associated with it. The \fIuserclass\fRes are hierarchical, so a connection
must pass the limit restrictions of the given \fIuserclass\fR as well as all
parent classes.
.PP
Within the \fBbwcltd.limits\fR file, \fIassign\fR lines are used to
assign a \fIuserclass\fR to a given connection. \fIlimit\fR lines are
used to define a \fIuserclass\fR and set the limits associated with that
\fIuserclass\fR. The file is read sequentially, and it is not permitted
to use a \fIclassname\fR before it is defined using a limit line.
.PP
The format of this file is:
.RS
.IP \(bu
Comment lines are any line where the first non-whitespace character is '#'.
These lines are counted to return line numbers in error
messages but are otherwise ignored by \fBbwctld\fR.
.IP \(bu
Lines may be continued using the semi-standard '\\' character followed
immediately by a newline. This is the only valid place for the '\\'
character. If it is found elsewhere a syntax error is reported.
.IP \(bu
Blank lines are treated as comment lines.
.IP \(bu
All other lines must conform to the syntax of a \fIlimit\fR line or
an \fIassign\fR line.
.RE
.SH CONFIGURATION OPTIONS
.TP
\fIlimit\fR
This directive is used to define the \fIuserclass\fR hierarchy. It
defines the \fIclassname\fR as well as the limits associated with
that class. A \fIclassname\fR may only be defined once. The
format of the \fIlimit\fR directive is:
.PP
.RS
limit \fIclassname\fR with \fIlimtype\fR=\fIvalue\fR[,\fIlimtype\fR=\fIvalue\fR]*
.PP
\fIclassname\fR defines the name of the class with the given
limits. Whitespace is used as a separator but is otherwise
ignored. \fIclassname\fR may be used as a directory name component
within \fBbwctld\fR, so take care not to use characters that would be
invalid. (i.e. '*' or '/' would be particularly bad.)
.PP
\fIlimtype\fR and \fIvalue\fR indicate the particular type of limit and
value to apply to this \fIuserclass\fR. The available settings for
\fIlimtype\fR are:
.TS
li li li
_ _ _
li l l .

limtype	valid values	default
allow_open_mode	on/off	on
allow_tcp	on/off	on
allow_udp	on/off	off
bandwidth	integer (b/s)	0 (unlimited)
duration	integer (seconds)	0 (unlimited)
event_horizon	integer (seconds)	0 (unlimited)
max_time_error	integer (seconds)	0 (unlimited)
parent	previously defined \fIclassname\fR	null
pending	integer	0 (unlimited)
.TE
.TP
.I allow_open_mode
This limit is only useful if the class is assigned
to a netmask. It is used to limit specific IP/netmask identities
to only encrypted or authenticated mode transactions or
to allow open mode.
.TP
.I allow_tcp
Allow TCP \fBIperf\fR tests for \fIuserclass\fR.
.TP
.I allow_udp
Allow UDP \fBIperf\fR tests for \fIuserclass\fR.
.TP
.I bandwidth
Maximum amount of bandwidth to allow \fIuserclass\fR
to use in a UDP \fBIperf\fR test.  0 indicates unlimited
by policy, but remember this is checked all the way to
the root of the hierarchy. (If you want an unlimited \fIuserclass\fR, your
root must be unlimited, and the whole path down
to the given \fIuserclass\fR.)
.TP
.I duration
Maximum duration of a single \fBIperf\fR test for this
\fIuserclass\fR.
.TP
.I event_horizon
Maximum window into the future to look when trying to schedule
a test for this \fIuserclass\fR.
.TP
.I max_time_error
Maximum amount of time error to allow for tests in this class. The time
error is the sum of the errors reported by NTP on the two involved systems.
The larger the time error, the larger the duration of the reservation
because the time error is used to ensure tests don't overlap. There is a
limit on this to defend against DOS attacks where a client could
report large errors to ensure other clients can not allocate test
reservations.
.TP
.I parent     
The first \fIlimit\fR line cannot have a parent since
none have been defined yet. As such, the first
line defines the root of your class hierarchy.
All remaining limit lines \fBMUST\fR assign a parent.
(It is hierarchical, after all.)
.TP
.I pending
Maximum number of \fIpending\fR reservations for this \fIuserclass\fR.
.RE
.TP
\fIassign\fR
The \fIassign\fR directive is used to assign a \fIuserclass\fR to a
given connection. Basically, it authenticates the connection.
The format of the \fIassign\fR directive is:
.PP
.RS
assign \fIauthtype\fR [\fIargs\fR] \fIclassname\fR
.PP
\fIauthtype\fR identifies the type of authentication being used. Whitespace
is used as a separator but is otherwise ignored. \fIclassname\fR must 
have been previously defined with the \fIlimit\fR directive earlier
in the file.
.PP
The available settings for \fIauthtype\fR are:
.TP
.B default
Used if no other assignment matches. It takes no \fIargs\fR.
.TP
.BI net " subnet"
Assign a specific \fIsubnet\fR to a given \fIuserclass\fR.
\fIsubnet\fR must be specified using VLSM notation (IP/nbits).
The only \fIarg\fR is the \fIsubnet\fR.
For example:
.RS
.TP
127.0.0.1/32
would match only the loopback IPv4 address.
.TP
::1/128
would match only the loopback IPv6 address.
.TP
192.168.1.0/24
would match all hosts on the 192.168.1.XXX network.
.PP
There must be no set bits in the non-masked portion of the address part
of the \fIsubnet\fR specification. i.e., 192.168.1.1/24 would be
an invalid \fIsubnet\fR due to the bit set in the fourth octet.
.RE
.TP
.BI user " user"
Assign a specific \fIuser\fR to a given \fIuserclass\fR.
The \fIuser\fR must be defined in the \fBbwctld.keys\fR file.
.SH AUTHENTICATION PROCESS
\fBbwctld\fR determines if it should allow a connection from
the client based upon the authentication mode of the request and the source
IP address of the connection. If the client connection is in authenticated or
encrypted mode, the daemon does not do any filtering based upon the
source address of the connection. (See the \fB\-A\fR option to \fBbwctl\fR
and the \fIauthmode\fR option in \fBbwctld.conf\fR.)
In these modes, \fBbwctld\fR simply uses the \fIidentity\fR of the
connection to determine the \fIuserclass\fR limits. If the connection
is made in open mode,  then \fBbwctld\fR first uses the source address to
determine if \fBbwctld\fR should allow an open mode connection from
that subnet at all. (This is
the purpose of the \fIallow_open_mode limtype\fR described above.)
If open mode is allowed from this subnet, then the \fIuserclass\fR
is determined by the closest subnet match defined by the \fIassign net\fR
lines in the \fBbwctld.limits\fR file.
.SH EXAMPLES
An initial \fIlimit\fR line might look like:
.RS
.HP
limit root with \\
.br
bandwidth=900m, \\
.br
duration=0, \\
.br
allow_udp=on, \\
.br
allow_tcp=on, \\
.br
allow_open_mode=off
.RE
.PP
This would create a \fIuserclass\fR named \fBroot\fR. Because no \fIparent\fR is
specified, this must be the first \fIuserclass\fR defined in the
file. This \fIuserclass\fR has very liberal limits (UDP enabled with
900m limit). However, open mode authentication is not enabled for
this \fIuserclass\fR, so the connections that get these limits must
successfully authenticate using an AES key.
.PP
If an administrator also wants to create a \fIuserclass\fR that is used
to deny all requests, they might add:
.RS
.HP
limit jail with \\
.br
parent=root, \\
.br
allow_udp=off, \\
.br
allow_tcp=off, \\
.br
allow_open_mode=off
.RE
.PP
This would create a \fIuserclass\fR named \fBjail\fR. Because UDP and TCP
tests have both been denied, no tests will be allowed. Also,
\fIallow_open_mode\fR is off, so initial connections that are not in
authenticated or encrypted mode would be dropped immediately anyway.
(It would not make much sense to assign a \fIuser\fR identity to this
\fIuserclass\fR. If you don't want connections from a particular \fIuser\fR,
the best thing to do is to remove that \fIuser\fR from the \fBbwctld.keys\fR
file.
.PP
If the administrator wanted to allow a limited amount of open tests, they
could define a \fIuserclass\fR like:
.RS
.HP
limit open with \\
.br
parent=root, \\
.br
allow_open_mode=on, \\
.br
allow_udp=off, \\
.br
allow_tcp=on, \\
.br
duration=30, \\
.br
event_horizon=300, \\
.br
pending=5
.RE
.PP
This could be used to allow TCP throughput tests by random connections.
It limits those tests to 30 seconds in duration, and only allows them to
be scheduled within the next 5 minutes (\fIevent_horizon\fR=300). Additionally,
it only allows this \fIuserclass\fR to have 5 currently \fIpending\fR
reservations. This ensures that this \fIuserclass\fR can only schedule 50%
of the next 5 minutes. The advantage of this kind of setup is that the
administrator can define other \fIuserclasses\fR with a larger
\fIevent_horizon\fR allowing then to have priority over this class.
(Suggestions for other methods of priority scheduling should be sent to
bwctl\-users@internet2.edu.)
.PP
Now, these three \fIuserclasses\fR might be assigned to specific connections
in the following ways:
.RS
.PP
# default open
.br
assign default \fBopen\fR
.PP
# badguys subnet
.br
assign net 192.168.1.0/24 \fBjail\fR
.PP
# network admins
.br
assign user joe \fBroot\fR
.br
assign user jim \fBroot\fR
.br
assign user bob \fBroot\fR
.br
.RE
.PP
This set of \fIassign\fR lines specifically denies access from any
open mode connection from the \fBbadguys\fR subnet. It specifically
allows access to authenticated or encrypted mode transactions that can
authenticate as the \fIidentities\fR \fBjoe jim\fR or \fBbob\fR (even from
the \fBbadguys\fR subnet). All other connections would match the
\fIassign default\fR rule and get the limits associated with the \fBopen\fR
\fIuserclass\fR.
.SH SEE ALSO
bwctl(1), bwctld(8), bwctld.limits(5), bwctld.keys(5),
and the \%http://e2epi.internet2.edu/bwctl/ web site.
.PP
For details on \fBIperf\fR, see the \%http://sourceforge.net/projects/iperf
web site.
.PP
For details on \fBNuttcp\fR, see the \%http://www.wcisd.hpc.mil/nuttcp/Nuttcp\-HOWTO.html
web site.
.PP
For details on \fBThrulay\fR, see the \%http://e2epi.internet2.edu/thrulay/
web site.
.SH ACKNOWLEDGMENTS
This material is based in part on work supported by the National Science
Foundation (NSF) under Grant No. ANI-0314723. Any opinions, findings, and
conclusions or recommendations expressed in this material are those of
the author(s) and do not necessarily reflect the views of the NSF.
