# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>
#
# Russian translation: Vitaly Fedrushkov <fedrushkov@users.sourceforge.net>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'любая',
    blacklisted => '(в черном списке)',
    checking_for => 'Проверка',
    checking_dbd      => 'Проверка установленных модулей Perl DBD...',
    checking_optional => 'Следующие модули Perl рекомендуются:',
    checking_modules  => 'Проверка модулей Perl...',
    chmod_failed      => '##path##: Ошибка изменения прав доступа: ##error##',
    chown_failed      => '##path##: Ошибка изменения владельца: ##error##',
    commands_dbd      => <<EOT,
ВЫПОЛНИТЕ ОДНУ ИЗ ЭТИХ КОМАНД (в зависимости от используемой
базы данных):
EOT
    commands_optional => 'КОМАНДЫ УСТАНОВКИ РЕКОМЕНДУЕМЫХ МОДУЛЕЙ:',
    commands_required => <<EOT,
КОМАНДЫ УСТАНОВКИ ОБЯЗАТЕЛЬНЫХ МОДУЛЕЙ (Обязательно выполните их все 
и затем запустите этот сценарий снова):
EOT
    done => 'Готово.',
    extension_must_return_name => <<END,
##file## вернул ##returned##, что не является корректным именем для расширения.
Расширения должны возвращать своё имя, а не <code>1</code> или какое-либо число.
Для получения более подробной информации обратитесь к документации Bugzilla::Extension.
END

    feature_auth_ldap         => 'Аутентификация LDAP',
    feature_auth_radius       => 'Аутентификация RADIUS',
    feature_graphical_reports => 'Диаграммы',
    feature_html_desc         => 'Использование HTML в описаниях продуктов и групп',
    feature_inbound_email     => 'Входящая электронная почта',
    feature_jobqueue          => 'Очередь электронной почты',
    feature_jsonrpc           => 'Интерфейс JSON-RPC',
    feature_new_charts        => 'Диаграммы нового образца',
    feature_old_charts        => 'Диаграммы старого образца',
    feature_mod_perl          => 'mod_perl',
    feature_moving            => 'Перемещение ошибок между экземплярами Bugzilla',
    feature_patch_viewer      => 'Просмотр патчей',
    feature_smtp_auth         => 'Аутентификация SMTP',
    feature_updates           => 'Автоматическое уведомление о новых версиях',
    feature_xmlrpc            => 'Интерфейс XML-RPC',

    header => "* Bugzilla ##bz_ver## на Perl ##perl_ver##\n"
            . "* Запущена на ##os_name## ##os_ver##",
    install_all => <<EOT,

Попробуйте установить все требуемые и рекомендуемые модули одной
командой:

  ##perl## install-module.pl --all

EOT
    install_data_too_long => <<EOT,
ВНИМАНИЕ: Некоторые данные в поле ##table##.##column## длинней чем
размер поля в текущей версии (##max_length## символов). Данные, которые следует
перечислены ниже (сначала значение кода ##id_column##, затем 
значение поля ##column##, которое следует исправить):

EOT
    install_module => 'Установка модуля ##module## версии ##version##...',
    installation_failed => '*** Установка прервана. Изучите сообщения об ошибках выше. ***',
    max_allowed_packet => <<EOT,
ВНИМАНИЕ: Установите значение параметра max_allowed_packet сервера MySQL
не менее ##needed##. Текущее значение -- ##current##.
Параметр настраивается в секции [mysqld] файла конфигурации MySQL.
EOT
    min_version_required => "Требуется версия не ниже: ",

# Note: When translating these "modules" messages, don't change the formatting
# if possible, because there is hardcoded formatting in 
# Bugzilla::Install::Requirements to match the box formatting.
    modules_message_db => <<EOT,
***********************************************************************
* ДОСТУП К БАЗЕ ДАННЫХ                                                *
***********************************************************************
* Для доступа к базе данных Bugzilla требуется установка модуля       *
* "DBD", соответствующего используемой модели базы данных.            *
* Ниже приведена команда установки требуемого модуля.                 *
EOT
    modules_message_optional => <<EOT,
***********************************************************************
* РЕКОМЕНДУЕМЫЕ МОДУЛИ                                                *
***********************************************************************
* Некоторые модули Perl не требуются для работы Bugzilla, но          *
* их установка позволит использовать дополнительные возможности.      *
*                                                                     *
* Ниже перечислены модули, которые пока не установлены, и             *
* возможности, обеспечиваемые этими модулями. Далее приведены         *
* команды установки недостающих модулей.                              *
EOT
    modules_message_required => <<EOT,
***********************************************************************
* ОБЯЗАТЕЛЬНЫЕ МОДУЛИ                                                 *
***********************************************************************
* Для работы Bugzilla требуются модули Perl, которые либо отсутствуют *
* в данной системе, либо требуют обновления до более новой версии.    *
* Команды установки недостающих модулей описаны ниже.                 *
EOT

    module_found => "найден v##ver##",
    module_not_found => "не найден",
    module_ok => 'ОК',
    module_unknown_version => "найдена неизвестная версия",
    no_such_module => "На CPAN нет модуля Perl с именем ##module##.",
    ppm_repo_add => <<EOT,
***********************************************************************
* Примечание для пользователей Windows                                *
***********************************************************************
* Перед установкой перечисленных ниже модулей необходимо выполнить    *
* с правами администратора следующую команду:                         *
*                                                                     *
*   ppm repo add theory58S ##theory_url##
EOT
    ppm_repo_up => <<EOT,
*                                                                     *
* Далее следует выполнить (также с правами администратора):           *
*                                                                     *
*   ppm repo up theory58S                                             *
*                                                                     *
* Эту команду повторять до тех пор, пока "theory58S" не окажется      *
* вверху списка.                                                      *
EOT
    template_precompile   => "Компиляция шаблонов...",
    template_removal_failed => <<END,
ВНИМАНИЕ: Каталог '##datadir##/template' не может быть удален.
         Он переименован в '##datadir##/deleteme', его следует
         удалить вручную для экономии дискового пространства.
END
    template_removing_dir => "Удаление скомпилированных шаблонов...",
);

1;
