#ifndef BUFFYCONFIG_H
#define BUFFYCONFIG_H

#pragma interface

#include <libbuffy/Exception.h>
#include <MailProgram.h>
#include <libxml++/libxml++.h>

class Config
{
protected:
	xmlpp::DomParser _xmlparser;

	xmlpp::Document* doc_conf;
	xmlpp::Element* _root;
	xmlpp::Element* _general;
	xmlpp::Element* _view;
	xmlpp::Element* _view_empty;
	xmlpp::Element* _view_read;
	xmlpp::Element* _view_important;
	xmlpp::Element* _locations;
	xmlpp::Element* _interval;
	xmlpp::Element* _programs;

	// State directory
	std::string rcfile;

	xmlpp::Element* el_root() throw ();
	xmlpp::Element* el_general() throw ();
	xmlpp::Element* el_view() throw ();
	xmlpp::Element* el_view_empty() throw ();
	xmlpp::Element* el_view_read() throw ();
	xmlpp::Element* el_view_important() throw ();
	xmlpp::Element* el_locations() throw ();
	xmlpp::Element* el_interval() throw ();
	xmlpp::Element* el_programs() throw ();

public:
	Config() throw (SystemException, ConsistencyCheckException);

	bool get_view_read() throw ();
	bool get_view_empty() throw ();
	bool get_view_important() throw ();

	void set_view_read(bool val) throw ();
	void set_view_empty(bool val) throw ();
	void set_view_important(bool val) throw ();

	int get_update_interval() throw ();
	void set_update_interval(int val) throw ();

	std::vector<std::string> get_folder_locations() throw ();
	void set_folder_locations(const std::vector<std::string>& locations) throw ();

	std::vector<MailProgram> get_mail_programs() throw ();
	void set_mail_programs(const std::vector<MailProgram>& programs) throw ();
	MailProgram get_selected_mail_program() throw ();

	void save() throw (ConsistencyCheckException);
};


// vim:set ts=4 sw=4:
#endif
