#ifndef MAILFOLDER_H
#define MAILFOLDER_H

/*
 * Abstract interface to mail folders
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <libbuffy/Consumer.h>
#include <libbuffy/SmartPointer.h>
#include <string>

class MailFolderImpl : public SmartPointerItem
{
public:
	virtual const std::string& name() const throw () = 0;
	virtual const std::string& path() const throw () = 0;

	virtual int getMsgTotal() const throw () = 0;
	virtual int getMsgUnread() const throw () = 0;
	virtual int getMsgNew() const throw () = 0;
	virtual int getMsgFlagged() const throw () = 0;

	virtual bool changed() = 0;

	virtual void updateStatistics() = 0;
};

class MailFolder : public SmartPointer<MailFolderImpl>
{
public:
	MailFolder() throw () : SmartPointer<MailFolderImpl>() {}
	MailFolder(const MailFolder& mf) throw () : SmartPointer<MailFolderImpl>(mf) {}
	MailFolder(MailFolderImpl* otherimpl) throw () : SmartPointer<MailFolderImpl>(otherimpl) {}

	const std::string& name() const throw () { return impl->name(); }
	const std::string& path() const throw () { return impl->path(); }

	int getMsgTotal() const throw () { return impl->getMsgTotal(); }
	int getMsgUnread() const throw () { return impl->getMsgUnread(); }
	int getMsgNew() const throw () { return impl->getMsgNew(); }
	int getMsgFlagged() const throw () { return impl->getMsgFlagged(); }

	/// Return true if the folder has been changed since the last updateStatistics
	bool changed() { return impl->changed(); }

	/// Rescan the folder to update its statistics
	void updateStatistics()
	{
		impl->updateStatistics();
	}

	static void enumerateFolders(const std::string& path, Consumer<MailFolder>& cons);
};

typedef Consumer<MailFolder> MailFolderConsumer;
typedef Filter<MailFolder> MailFolderFilter;

// vim:set ts=4 sw=4:
#endif
