#ifndef FOLDER_LIST_H
#define FOLDER_LIST_H

/*
 * Folder list widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <buffy/MailFolder.h>

#include <sigc++/sigc++.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/treemodelsort.h>
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include <gtkmm/menu.h>

namespace buffy {
namespace config {
	class Config;
}
}

class FolderList : public Gtk::VBox, public buffy::MailFolderConsumer
{
public:
	typedef SigC::Signal1<void, buffy::MailFolder> type_signal_open_folder;

protected:
	Gtk::TreeView folderList;
	Glib::RefPtr<Gtk::ListStore> folderListModel;
	Glib::RefPtr<Gtk::TreeModelFilter> filteredModel;
	Glib::RefPtr<Gtk::TreeModelSort> sortedModel;
	Gtk::ScrolledWindow scrolledFolderList;

	Gtk::Menu itemPopup;

	// Tree model columns
	class FolderListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		FolderListModelColumns() { add(folder); add(name); add(msg_new); add(msg_unread); add(msg_total); add(msg_flagged); add(view_flags); }

		Gtk::TreeModelColumn<buffy::MailFolder> folder;
		Gtk::TreeModelColumn<Glib::ustring> name;
		Gtk::TreeModelColumn<int> msg_new;
		Gtk::TreeModelColumn<int> msg_unread;
		Gtk::TreeModelColumn<int> msg_total;
		Gtk::TreeModelColumn<int> msg_flagged;
		Gtk::TreeModelColumn<int> view_flags;
	};

	FolderListModelColumns folderListModelColumns;

	type_signal_open_folder _signal_open_folder;

	bool on_event(GdkEvent* e);
	void on_row_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn*);
	bool filter_row(const Gtk::TreeModel::const_iterator& iter);

	void on_sort_column_changed();

	void toggle_hide_always(const buffy::MailFolder& folder);
	void toggle_view_always(const buffy::MailFolder& folder);

public:
	FolderList();
	virtual ~FolderList() {}

	void consume(buffy::MailFolder& folder);

	void clear();
	int size() { return folderListModel->children().size(); }
	void do_update();
	bool do_timer_tick();

	void configureFilter(buffy::config::Config& conf);

	type_signal_open_folder signal_open_folder() throw ()
		{ return _signal_open_folder; }
};

// vim:set ts=4 sw=4:
#endif
