/* ClockApplet.c generated by valac 0.32.1, the Vala compiler
 * generated from ClockApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2014-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>


#define TYPE_CLOCK_PLUGIN (clock_plugin_get_type ())
#define CLOCK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_PLUGIN, ClockPlugin))
#define CLOCK_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_PLUGIN, ClockPluginClass))
#define IS_CLOCK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_PLUGIN))
#define IS_CLOCK_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_PLUGIN))
#define CLOCK_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_PLUGIN, ClockPluginClass))

typedef struct _ClockPlugin ClockPlugin;
typedef struct _ClockPluginClass ClockPluginClass;
typedef struct _ClockPluginPrivate ClockPluginPrivate;

#define TYPE_CLOCK_APPLET (clock_applet_get_type ())
#define CLOCK_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_APPLET, ClockApplet))
#define CLOCK_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_APPLET, ClockAppletClass))
#define IS_CLOCK_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_APPLET))
#define IS_CLOCK_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_APPLET))
#define CLOCK_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_APPLET, ClockAppletClass))

typedef struct _ClockApplet ClockApplet;
typedef struct _ClockAppletClass ClockAppletClass;

#define TYPE_CLOCK_FORMAT (clock_format_get_type ())
typedef struct _ClockAppletPrivate ClockAppletPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ClockPlugin {
	PeasExtensionBase parent_instance;
	ClockPluginPrivate * priv;
};

struct _ClockPluginClass {
	PeasExtensionBaseClass parent_class;
};

typedef enum  {
	CLOCK_FORMAT_TWENTYFOUR = 0,
	CLOCK_FORMAT_TWELVE = 1
} ClockFormat;

struct _ClockApplet {
	BudgieApplet parent_instance;
	ClockAppletPrivate * priv;
	GtkEventBox* widget;
	GtkLabel* clock;
	gboolean ampm;
	gboolean show_seconds;
	gboolean show_date;
	GSettings* settings;
};

struct _ClockAppletClass {
	BudgieAppletClass parent_class;
};

struct _ClockAppletPrivate {
	GDateTime* time;
	GtkPopover* popover;
	GAppInfo* calprov;
	GSimpleAction* cal;
	BudgiePopoverManager* manager;
};


static gpointer clock_plugin_parent_class = NULL;
static BudgiePluginIface* clock_plugin_budgie_plugin_parent_iface = NULL;
static GType clock_plugin_type_id = 0;
static gpointer clock_applet_parent_class = NULL;
static GType clock_applet_type_id = 0;

GType clock_plugin_get_type (void) G_GNUC_CONST;
GType clock_plugin_register_type (GTypeModule * module);
enum  {
	CLOCK_PLUGIN_DUMMY_PROPERTY
};
static BudgieApplet* clock_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid);
ClockApplet* clock_applet_new (void);
ClockApplet* clock_applet_construct (GType object_type);
GType clock_applet_get_type (void) G_GNUC_CONST;
GType clock_applet_register_type (GTypeModule * module);
ClockPlugin* clock_plugin_new (void);
ClockPlugin* clock_plugin_construct (GType object_type);
GType clock_format_get_type (void) G_GNUC_CONST;
#define CALENDAR_MIME "text/calendar"
#define CLOCK_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLOCK_APPLET, ClockAppletPrivate))
enum  {
	CLOCK_APPLET_DUMMY_PROPERTY
};
static gboolean __lambda4_ (ClockApplet* self, GdkEventButton* e);
static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
gboolean clock_applet_update_clock (ClockApplet* self);
static gboolean _clock_applet_update_clock_gsource_func (gpointer self);
void clock_applet_on_settings_change (ClockApplet* self, const gchar* key);
static void _clock_applet_on_settings_change_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void clock_applet_on_date_activate (ClockApplet* self);
static void _clock_applet_on_date_activate_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void clock_applet_update_cal (ClockApplet* self);
static void _clock_applet_update_cal_g_app_info_monitor_changed (GAppInfoMonitor* _sender, gpointer self);
static void clock_applet_on_cal_activate (ClockApplet* self);
static void _clock_applet_on_cal_activate_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void clock_applet_real_update_popovers (BudgieApplet* base, BudgiePopoverManager* manager);
static void clock_applet_finalize (GObject* obj);
void peas_register_types (GTypeModule* module);


static BudgieApplet* clock_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid) {
	ClockPlugin * self;
	BudgieApplet* result = NULL;
	ClockApplet* _tmp0_ = NULL;
	self = (ClockPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = clock_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}


ClockPlugin* clock_plugin_construct (GType object_type) {
	ClockPlugin * self = NULL;
	self = (ClockPlugin*) g_object_new (object_type, NULL);
	return self;
}


ClockPlugin* clock_plugin_new (void) {
	return clock_plugin_construct (TYPE_CLOCK_PLUGIN);
}


static void clock_plugin_class_init (ClockPluginClass * klass) {
	clock_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void clock_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface) {
	clock_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*)(BudgiePlugin*, const gchar*)) clock_plugin_real_get_panel_widget;
}


static void clock_plugin_instance_init (ClockPlugin * self) {
}


GType clock_plugin_get_type (void) {
	return clock_plugin_type_id;
}


GType clock_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ClockPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockPlugin), 0, (GInstanceInitFunc) clock_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) clock_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	clock_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ClockPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, clock_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return clock_plugin_type_id;
}


GType clock_format_get_type (void) {
	static volatile gsize clock_format_type_id__volatile = 0;
	if (g_once_init_enter (&clock_format_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCK_FORMAT_TWENTYFOUR, "CLOCK_FORMAT_TWENTYFOUR", "twentyfour"}, {CLOCK_FORMAT_TWELVE, "CLOCK_FORMAT_TWELVE", "twelve"}, {0, NULL, NULL}};
		GType clock_format_type_id;
		clock_format_type_id = g_enum_register_static ("ClockFormat", values);
		g_once_init_leave (&clock_format_type_id__volatile, clock_format_type_id);
	}
	return clock_format_type_id__volatile;
}


static gboolean __lambda4_ (ClockApplet* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkPopover* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp2_ = self->priv->popover;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	if (_tmp3_) {
		GtkPopover* _tmp4_ = NULL;
		_tmp4_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		BudgiePopoverManager* _tmp5_ = NULL;
		GtkEventBox* _tmp6_ = NULL;
		_tmp5_ = self->priv->manager;
		_tmp6_ = self->widget;
		budgie_popover_manager_show_popover (_tmp5_, (GtkWidget*) _tmp6_);
	}
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda4_ ((ClockApplet*) self, event);
	return result;
}


static gboolean _clock_applet_update_clock_gsource_func (gpointer self) {
	gboolean result;
	result = clock_applet_update_clock ((ClockApplet*) self);
	return result;
}


static void _clock_applet_on_settings_change_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	clock_applet_on_settings_change ((ClockApplet*) self, key);
}


static void _clock_applet_on_date_activate_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	clock_applet_on_date_activate ((ClockApplet*) self);
}


static void _clock_applet_update_cal_g_app_info_monitor_changed (GAppInfoMonitor* _sender, gpointer self) {
	clock_applet_update_cal ((ClockApplet*) self);
}


static void _clock_applet_on_cal_activate_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	clock_applet_on_cal_activate ((ClockApplet*) self);
}


ClockApplet* clock_applet_construct (GType object_type) {
	ClockApplet * self = NULL;
	GtkEventBox* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkEventBox* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkEventBox* _tmp8_ = NULL;
	GtkPopover* _tmp9_ = NULL;
	GtkPopover* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkEventBox* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	GSimpleActionGroup* group = NULL;
	GSimpleActionGroup* _tmp15_ = NULL;
	GSimpleAction* date = NULL;
	GSimpleAction* _tmp16_ = NULL;
	GAppInfo* _tmp17_ = NULL;
	GAppInfoMonitor* monitor = NULL;
	GAppInfoMonitor* _tmp18_ = NULL;
	GSimpleAction* _tmp19_ = NULL;
	GSimpleAction* _tmp20_ = NULL;
	GAppInfo* _tmp21_ = NULL;
	GSimpleAction* _tmp22_ = NULL;
	GSimpleAction* _tmp23_ = NULL;
	GtkEventBox* _tmp24_ = NULL;
	self = (ClockApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->clock);
	self->clock = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (self->priv->time);
	self->priv->time = _tmp2_;
	_tmp3_ = self->widget;
	_tmp4_ = self->clock;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = g_menu_new ();
	menu = _tmp5_;
	_tmp6_ = _ ("Time and date settings");
	g_menu_append (menu, _tmp6_, "clock.time_and_date");
	_tmp7_ = _ ("Calendar");
	g_menu_append (menu, _tmp7_, "clock.calendar");
	_tmp8_ = self->widget;
	_tmp9_ = (GtkPopover*) gtk_popover_new_from_model ((GtkWidget*) _tmp8_, (GMenuModel*) menu);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp9_;
	_tmp10_ = self->priv->popover;
	_tmp11_ = gtk_bin_get_child ((GtkBin*) _tmp10_);
	gtk_widget_show_all (_tmp11_);
	_tmp12_ = self->widget;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "button-press-event", (GCallback) ___lambda4__gtk_widget_button_press_event, self, 0);
	g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 1, _clock_applet_update_clock_gsource_func, g_object_ref (self), g_object_unref);
	_tmp13_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->settings);
	self->settings = _tmp13_;
	_tmp14_ = self->settings;
	g_signal_connect_object (_tmp14_, "changed", (GCallback) _clock_applet_on_settings_change_g_settings_changed, self, 0);
	clock_applet_on_settings_change (self, "clock-format");
	clock_applet_on_settings_change (self, "clock-show-seconds");
	clock_applet_on_settings_change (self, "clock-show-date");
	_tmp15_ = g_simple_action_group_new ();
	group = _tmp15_;
	_tmp16_ = g_simple_action_new ("time_and_date", NULL);
	date = _tmp16_;
	g_signal_connect_object (date, "activate", (GCallback) _clock_applet_on_date_activate_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) group, (GAction*) date);
	_tmp17_ = g_app_info_get_default_for_type (CALENDAR_MIME, FALSE);
	_g_object_unref0 (self->priv->calprov);
	self->priv->calprov = _tmp17_;
	_tmp18_ = g_app_info_monitor_get ();
	monitor = _tmp18_;
	g_signal_connect_object (monitor, "changed", (GCallback) _clock_applet_update_cal_g_app_info_monitor_changed, self, 0);
	gtk_widget_insert_action_group ((GtkWidget*) self, "clock", (GActionGroup*) group);
	_tmp19_ = g_simple_action_new ("calendar", NULL);
	_g_object_unref0 (self->priv->cal);
	self->priv->cal = _tmp19_;
	_tmp20_ = self->priv->cal;
	_tmp21_ = self->priv->calprov;
	g_simple_action_set_enabled (_tmp20_, _tmp21_ != NULL);
	_tmp22_ = self->priv->cal;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) _clock_applet_on_cal_activate_g_simple_action_activate, self, 0);
	_tmp23_ = self->priv->cal;
	g_action_map_add_action ((GActionMap*) group, (GAction*) _tmp23_);
	clock_applet_update_cal (self);
	clock_applet_update_clock (self);
	_tmp24_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp24_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (monitor);
	_g_object_unref0 (date);
	_g_object_unref0 (group);
	_g_object_unref0 (menu);
	return self;
}


ClockApplet* clock_applet_new (void) {
	return clock_applet_construct (TYPE_CLOCK_APPLET);
}


static void clock_applet_update_cal (ClockApplet* self) {
	GAppInfo* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GAppInfo* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_default_for_type (CALENDAR_MIME, FALSE);
	_g_object_unref0 (self->priv->calprov);
	self->priv->calprov = _tmp0_;
	_tmp1_ = self->priv->cal;
	_tmp2_ = self->priv->calprov;
	g_simple_action_set_enabled (_tmp1_, _tmp2_ != NULL);
}


static void clock_applet_on_date_activate (ClockApplet* self) {
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_desktop_app_info_new ("gnome-datetime-panel.desktop");
	app_info = _tmp0_;
	_tmp1_ = app_info;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp2_ = NULL;
		_tmp2_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("ClockApplet.vala:120: Unable to launch gnome-datetime-panel.desktop: %" \
"s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (app_info);
}


static void clock_applet_on_cal_activate (ClockApplet* self) {
	GAppInfo* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->calprov;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		GAppInfo* _tmp1_ = NULL;
		_tmp1_ = self->priv->calprov;
		g_app_info_launch (_tmp1_, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GAppInfo* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = self->priv->calprov;
		_tmp3_ = g_app_info_get_name (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("ClockApplet.vala:132: Unable to launch %s: %s", _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void clock_applet_real_update_popovers (BudgieApplet* base, BudgiePopoverManager* manager) {
	ClockApplet * self;
	BudgiePopoverManager* _tmp0_ = NULL;
	BudgiePopoverManager* _tmp1_ = NULL;
	GtkEventBox* _tmp2_ = NULL;
	GtkPopover* _tmp3_ = NULL;
	self = (ClockApplet*) base;
	_tmp0_ = manager;
	self->priv->manager = _tmp0_;
	_tmp1_ = manager;
	_tmp2_ = self->widget;
	_tmp3_ = self->priv->popover;
	budgie_popover_manager_register_popover (_tmp1_, (GtkWidget*) _tmp2_, _tmp3_);
}


void clock_applet_on_settings_change (ClockApplet* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("clock-format")))) {
		switch (0) {
			default:
			{
				ClockFormat f = 0;
				GSettings* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				ClockFormat _tmp7_ = 0;
				_tmp4_ = self->settings;
				_tmp5_ = key;
				_tmp6_ = g_settings_get_enum (_tmp4_, _tmp5_);
				f = (ClockFormat) _tmp6_;
				_tmp7_ = f;
				self->ampm = _tmp7_ == CLOCK_FORMAT_TWELVE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("clock-show-seconds")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = self->settings;
				_tmp9_ = key;
				_tmp10_ = g_settings_get_boolean (_tmp8_, _tmp9_);
				self->show_seconds = _tmp10_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("clock-show-date")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = self->settings;
				_tmp12_ = key;
				_tmp13_ = g_settings_get_boolean (_tmp11_, _tmp12_);
				self->show_date = _tmp13_;
				break;
			}
		}
	}
}


/**
     * This is called once every second, updating the time
     */
gboolean clock_applet_update_clock (ClockApplet* self) {
	gboolean result = FALSE;
	GDateTime* _tmp0_ = NULL;
	gchar* format = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* ftime = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gchar* ctime = NULL;
	GDateTime* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (self->priv->time);
	self->priv->time = _tmp0_;
	_tmp1_ = self->ampm;
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("%l:%M");
		_g_free0 (format);
		format = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("%H:%M");
		_g_free0 (format);
		format = _tmp3_;
	}
	_tmp4_ = self->show_seconds;
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = format;
		_tmp6_ = g_strconcat (_tmp5_, ":%S", NULL);
		_g_free0 (format);
		format = _tmp6_;
	}
	_tmp7_ = self->ampm;
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = format;
		_tmp9_ = g_strconcat (_tmp8_, " %p", NULL);
		_g_free0 (format);
		format = _tmp9_;
	}
	_tmp10_ = format;
	_tmp11_ = g_strdup_printf (" <big>%s</big> ", _tmp10_);
	ftime = _tmp11_;
	_tmp12_ = self->show_date;
	if (_tmp12_) {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp13_ = ftime;
		_tmp14_ = g_strconcat (_tmp13_, " <big>%x</big>", NULL);
		_g_free0 (ftime);
		ftime = _tmp14_;
	}
	_tmp15_ = self->priv->time;
	_tmp16_ = ftime;
	_tmp17_ = g_date_time_format (_tmp15_, _tmp16_);
	ctime = _tmp17_;
	_tmp18_ = self->clock;
	gtk_label_set_markup (_tmp18_, ctime);
	result = TRUE;
	_g_free0 (ctime);
	_g_free0 (ftime);
	_g_free0 (format);
	return result;
}


static void clock_applet_class_init (ClockAppletClass * klass) {
	clock_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClockAppletPrivate));
	((BudgieAppletClass *) klass)->update_popovers = clock_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->finalize = clock_applet_finalize;
}


static void clock_applet_instance_init (ClockApplet * self) {
	self->priv = CLOCK_APPLET_GET_PRIVATE (self);
	self->ampm = FALSE;
	self->show_seconds = FALSE;
	self->show_date = FALSE;
	self->priv->popover = NULL;
	self->priv->calprov = NULL;
	self->priv->cal = NULL;
	self->priv->manager = NULL;
}


static void clock_applet_finalize (GObject* obj) {
	ClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLOCK_APPLET, ClockApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->clock);
	_g_date_time_unref0 (self->priv->time);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->calprov);
	_g_object_unref0 (self->priv->cal);
	G_OBJECT_CLASS (clock_applet_parent_class)->finalize (obj);
}


GType clock_applet_get_type (void) {
	return clock_applet_type_id;
}


GType clock_applet_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ClockAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockApplet), 0, (GInstanceInitFunc) clock_applet_instance_init, NULL };
	clock_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "ClockApplet", &g_define_type_info, 0);
	return clock_applet_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	clock_plugin_register_type (module);
	clock_applet_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_CLOCK_PLUGIN);
	_g_object_unref0 (objmodule);
}



