/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "SystemInfo.h"
#include "Shared.h"
#include "Config.h"
#include "SystemInfoDisks.h"
#include "SystemInfoMemory.h"
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtabbar.h>
#include <qwidgetstack.h>

/*------- local constants:
-------------------------------------------------------------------*/
const QString SystemInfo::Caption = QT_TR_NOOP( "System information" );
const QString SystemInfo::Disks   = QT_TR_NOOP( "&Disks" );
const QString SystemInfo::Memory  = QT_TR_NOOP( "&Memory (Mb)" );


//*******************************************************************
// SystemInfo                                            CONSTRUCTOR
//*******************************************************************
SystemInfo::SystemInfo( QWidget* const in_parent )
: QDialog( in_parent )
, d_main_layout( new QVBoxLayout( this ))
, d_data_layout( new QVBoxLayout )
, d_btn_layout( new QHBoxLayout )
, d_tab_bar( new QTabBar( this ))
, d_widget_stack( new QWidgetStack( this ))
, d_close_btn( new QPushButton( tr(Shared::CloseBtnLabel), this ))
{
	setCaption( tr( Caption ) );
	setFont( Config::instance()->lfs_default_font() );
	
	Shared::add_icon( d_close_btn, Shared::CloseIcon );
	
	d_tab_bar->insertTab( new QTab( tr( Disks ) ), 0 );
	d_tab_bar->insertTab( new QTab( tr( Memory ) ), 1 );
	
	d_data_layout->addWidget( d_tab_bar );
	d_data_layout->addWidget( d_widget_stack );
	d_widget_stack->addWidget( new SystemInfoDisks( this ), 0 );
	d_widget_stack->addWidget( new SystemInfoMemory( this ), 1 );
		
	d_btn_layout->addStretch( Shared::OverStretch );
	d_btn_layout->addWidget( d_close_btn );

	d_main_layout->setSpacing( Shared::LayoutMargin );
	d_main_layout->setMargin( Shared::LayoutMargin );
	d_main_layout->addLayout( d_data_layout );
	d_main_layout->addLayout( d_btn_layout );
	
	connect( d_close_btn, SIGNAL( clicked() ), this, SLOT( accept() ));
	connect( d_tab_bar, SIGNAL( selected( int ) ), this, SLOT( slot_set_tab( int ) ));
}
// end of SystemInfo

//*******************************************************************
// slot_set_tab                                         PRIVATE slot
//*******************************************************************
void SystemInfo::slot_set_tab( int in_idx )
{
	d_widget_stack->raiseWidget( in_idx );
	d_tab_bar->setCurrentTab( in_idx );
}
// end of slot_set_tab
