/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BSCommander; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_PACKER_H
#define INCLUDED_PACKER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QFILE_H
#include <qfile.h>
#define INCLUDED_QFILE_H
#endif // INCLUDED_QFILE_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

#ifndef INCLUDED_QFONTMETRICS_H
#include <qfontmetrics.h>
#define INCLUDED_QFONTMETRICS_H
#endif // INCLUDED_QFONTMETRICS_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- forward declarations:
-------------------------------------------------------------------*/
class InfoField;
class QPushButton;
class QProgressBar;
class QCheckBox;
class QProcess;
class QGroupBox;
class QRadioButton;
class QButtonGroup;
class QFrame;
class QGridLayout;
class QLabel;
class QHBoxLayout;
class QVBoxLayout;
class QComboBox;

/*------- class declaration:
-------------------------------------------------------------------*/
class Packer : public QDialog
{
	Q_OBJECT

// ******* TYPES *******
private:
	typedef enum {
		TAR = 0,
		GZIP,
		BZIP2,
		ZIP
	} CompressType;

// ******* CONSTRUCTION *******
public:
	Packer( QWidget* const parent, const ViewTable::SelectedItems&, const QString& );
	~Packer();
private:
	Packer( const Packer& );
	Packer& operator=( const Packer& );

// ******* MEMBERS *******
private:
	static const QString Caption;
	static const QString InfoTitel;
	static const QString SrcLabel;
	static const QString DstLabel;
	static const QString CompressLabel;
	static const QString RemoveLabel;
	static const QString InputCaption;
	static const QString InputPrompt;
	static const QString Gzip;
	static const QString Bzip2;
	static const QString Zip;
	static const QString TarExt;
	static const QString GzipExt;
	static const QString Bzip2Ext;
	static const QString ZipExt;
	
	//....................................
	const ViewTable::SelectedItems& d_items;
	const QString                   d_dst_dir;
	//....................................
	QGroupBox*    const d_info_gb;
	QFrame*       const d_info_frm;
	QGridLayout*  const d_info_gl;
	QLabel*       const d_info_src_lb;
	InfoField*    const d_info_src_fld;
	QLabel*       const d_info_dst_lb;
	InfoField*    const d_info_dst_fld;
	//....................................
	QHBoxLayout*  const d_button_layout;	
	QCheckBox*    const d_compress_cb;
	QCheckBox*    const d_remove_cb;
	QPushButton*  const d_run_btn;
	QPushButton*  const d_exit_btn;
	//....................................
	QButtonGroup* const d_compress_grp;
	QRadioButton* const d_gz_rb;
	QRadioButton* const d_bz2_rb;
	QRadioButton* const d_zip_rb;
	QComboBox*    const d_level_cbox;
	//....................................
	QVBoxLayout*  const d_main_layout;
	QString             d_pack_fname;
	QString             d_pack_fpath;
	bool                d_paused;
	bool                d_started;
	bool                d_stopped;
	QFontMetrics        d_fm;
	unsigned int        d_idx;
	QProcess*           d_process;
	CompressType        d_compress_type;

// ******* METHODS *******
private:
	void     polish          ();
	void     display         ( const QString& );
	void     display_dst     ();
	void		show            ();
	QString  path2display    ();
	void     process         ();
	void     end_process     ();
	void     pack            ();
	void     remove_ext      ( QString& ); 
private slots:
	void     break_work       ();
	void     run              ();
	void		message          ();
	void		error            ();
	void		finish           ();
	void     compress_selected();
	void     type_changed     ( bool );
	void     reject           ();
signals:
	void     start            ();
};

#endif // INCLUDED_PACKER_H
