/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "DiffViewer.h"
#include "Shared.h"
#include "Busy.h"
#include "Config.h"
#include "SystemCall.h"
#include <qtextbrowser.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <vector>
using namespace std;

/*------- local constants:
-------------------------------------------------------------------*/
const QString DiffViewer::Caption     = QT_TR_NOOP( "Diff viewer" );
const QString DiffViewer::FileMusters = QT_TR_NOOP( "Text file (*.txt)" );


//*******************************************************************
// DiffViewer                                            CONSTRUCTOR
//*******************************************************************
DiffViewer::DiffViewer( QWidget* const in_parent, const QString& in_lfile, const QString& in_rfile )
: QDialog      ( in_parent )
, d_main_layout( new QVBoxLayout( this ))
, d_btn_layout ( new QHBoxLayout )
, d_browser    ( new QTextBrowser( this ))
, d_save_btn   ( new QPushButton( tr(Shared::SaveBtnLabel), this ))
, d_close_btn  ( new QPushButton( tr(Shared::CloseBtnLabel), this ))
, d_syscall    ( new SystemCall( this ))
{
	setCaption( tr(Caption) );
	setFont( Config::instance()->lfs_font() );
	
	d_main_layout->setMargin( Shared::LayoutMargin );
	d_main_layout->setSpacing( Shared::LayoutSpacing );
	
	d_browser->setPaletteBackgroundColor( Config::instance()->lfs_default_bkg_color() );
	QFontMetrics fm( font() );
	d_browser->setTabStopWidth( 3 * fm.width( "X" ));
	d_browser->show();		
	d_main_layout->addWidget( d_browser );
	
	d_btn_layout->addStretch( Shared::OverStretch );
	d_btn_layout->addWidget( d_save_btn );
	d_btn_layout->addWidget( d_close_btn );
	d_main_layout->addLayout( d_btn_layout );
	
	connect( d_save_btn , SIGNAL( clicked()       ), this, SLOT( slot_save()     ));
	connect( d_close_btn, SIGNAL( clicked()       ), this, SLOT( accept()        ));
	connect( d_syscall  , SIGNAL( finished( int ) ), this, SLOT( finished( int ) ));
	
	vector<QString> parameters;
	parameters.push_back( "diff" );
	parameters.push_back( "-u" );
	parameters.push_back( "-w" );
	parameters.push_back( in_rfile );
	parameters.push_back( in_lfile );
	d_syscall->run( parameters );
}
// end of DiffViewer

//*******************************************************************
// ~DiffViewer                                            DESTRUCTOR
//*******************************************************************
DiffViewer::~DiffViewer()
{
	if( d_syscall ) {
		delete d_syscall;
		d_syscall = 0;
	}
}
// end of ~DiffViewer

//*******************************************************************
// slot_save                                            PRIVATE slot
//*******************************************************************
void DiffViewer::slot_save()
{
	const QString fname = QFileDialog::getSaveFileName( QDir::homeDirPath(),
															tr(FileMusters), this );
	if( FALSE == fname.isEmpty() ) {
		QFile file( fname );
		if( file.open( IO_WriteOnly ) ) {
			QTextStream out( &file );
			Busy::set_busy( TRUE );
			out << d_browser->text();
			Busy::set_busy( FALSE );
			file.close();
		}
	}
}
// end of slot_save

//*******************************************************************
// polish                                          PRIVATE inherited
//*******************************************************************
void DiffViewer::polish()
{
	Shared::polish( this, 60, 60 );
}
// end of polish

//*******************************************************************
// finished                                             PRIVATE slot
//*******************************************************************
void DiffViewer::finished( int )
{
	vector<QString> stdout_lines;
	vector<QString> stderr_lines;
		
	d_syscall->result( stdout_lines, stderr_lines );
	delete d_syscall;
	d_syscall = 0;
		
	if( FALSE == stdout_lines.empty() ) {
		vector<QString>::const_iterator it = stdout_lines.begin();
		while( it != stdout_lines.end() ) {
			d_browser->append( *it );
			++it;
		}
	}
}
// end of finished
