/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BSCommander; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_CONFIGFNBTN_H
#define INCLUDED_CONFIGFNBTN_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H

#ifndef INCLUDED_QFONT_H
#include <qfont.h>
#define INCLUDED_QFONT_H
#endif // INCLUDED_QFONT_H


/*------- forward declarations:
-------------------------------------------------------------------*/
class QHBoxLayout;
class QVBoxLayout;
class QButtonGroup;
class QRadioButton;
class QPushButton;
class QLabel;
class QGroupBox;

class ConfigFnBtn : public QFrame
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	ConfigFnBtn( QWidget* );
private:
	ConfigFnBtn( const ConfigFnBtn& );
	ConfigFnBtn& operator=( const ConfigFnBtn& );

// ******* MEMBERS *******
private:
	static const QString DescriptionDispMode;
	static const QString OnlyFunctionKey;
	static const QString F11;
	static const QString OnlyDescription;
	static const QString Description;
	static const QString FullDescription;
	static const QString F11Description;
	static const QString TwoLinesDescription;
	static const QString F11NlDescription;
	static const QString ButtonPreview;
	static const QString Font;

	QHBoxLayout*  const d_main_layout;
	QVBoxLayout*  const d_lft_layout;
	QVBoxLayout*  const d_rgt_layout;
	QButtonGroup* const d_radio_grp;
	QLabel*       const d_only_fn_lbl;
	QRadioButton* const d_only_fn_rb;
	QLabel*       const d_only_text_lbl;
	QRadioButton* const d_only_text_rb;
	QLabel*       const d_fn_text_lbl;
	QRadioButton* const d_fn_text_rb;
	QLabel*       const d_fn_nl_text_lbl;
	QRadioButton* const d_fn_nl_text_rb;
	QGroupBox*    const d_example_gb;
	QPushButton*  const d_example_btn;
	QPushButton*  const d_font_btn;
	QPushButton*  const d_apply_btn;
	QFont               d_font;
	int                 d_fn_disp_mode;

// ******* METHODS *******
private:
	void show();
	void read_config();
	void save_config();
	void update_view();
private slots:
	void font_selection();
	void apply();
	void clicked( int );
signals:
	void looks_refresh();
};

#endif // INCLUDED_CONFIGFNBTN_H
