// Brutal Chess
//
// File : boardmove.h
// Date : 05/03/2005
// Authors : Maxwell Lazaroff and Michael Cook
//
// Description : Keeps track of a move.

#include "boardmove.h"
#include "board.h"

using namespace std;

typedef unsigned int uint;
   
//******** CONSTRUCTOR ********
BoardMove::BoardMove(uint startx, uint starty, uint endx, uint endy)
{
    _startx = startx;
    _starty = starty;
    _endx = endx;
    _endy = endy;
	_isEnPassant = false;
	_isCastling = false;
}
   
void BoardMove::setStart( uint startx, uint starty )
{
	_startx = startx;
	_starty = starty;
}

void BoardMove::setStart( char sfile, uint srank )
{
	_starty = sfile - 'a';
	_startx = 8 - srank;
}

void BoardMove::setEnd( uint endx, uint endy )
{
	_endx = endx;
	_endy = endy;
}

void BoardMove::setEnd( char efile, uint erank )
{
	_endy = efile - 'a';
	_endx = 8 - erank;
}

//******** ACCESSORS ********
uint BoardMove::getStartx() const { return _startx; }
uint BoardMove::getStarty() const { return _starty; }
uint BoardMove::getEndx() const { return _endx; }
uint BoardMove::getEndy() const { return _endy; }

bool BoardMove::getIsEnPassant() { return _isEnPassant; }
void BoardMove::setIsEnPassant() { _isEnPassant = true; }
void BoardMove::unsetIsEnPassant() { _isEnPassant = false; }

bool BoardMove::getCastling() { return _isCastling; }
void BoardMove::setCastling() { _isCastling = true; }
void BoardMove::unsetCastling() { _isCastling = false; }

void BoardMove::checkFlags( const Board & board )
{
	uint srow = getStartx();
	uint scol = getStarty();
	uint erow = getEndx();
	uint ecol = getEndy();

	// En-Passant.		
	if(   board._board[erow][ecol].getUnit() == EMPTY
	   && ( ecol == scol - 1 || ecol == scol + 1 )
	   // ONLY allowed Pawn vs. Pawn!
	   && board._board[srow][scol].getUnit() == PAWN
	   && board._board[srow][ecol].getUnit() == PAWN
	   && board._board[srow][ecol].getMovecount() == 1
	   && board._board[srow][ecol].getJustMoved() == true
	   && ( ( board._board[srow][scol].getColor() == WHITE 
				&& board._board[srow][ecol].getColor() == BLACK 
				&& srow == 3)
			|| ( board._board[srow][scol].getColor() == BLACK 
				&& board._board[srow][ecol].getColor() == WHITE 
				&& srow == 4) ) )
		setIsEnPassant();

	// Castling
    if( board._board[srow][scol].getMovecount() == 0
		&& board._board[srow][scol].getUnit() == KING
		&& ( ( board._board[srow][scol].getColor() == WHITE  && erow == 7 ) 
				|| ( board._board[srow][scol].getColor() != WHITE  && erow == 0 ) )
		&& ( ( ecol == 2
		&& board._board[erow][0].getMovecount() == 0
		&& board._board[erow][1].getUnit() == EMPTY
		&& board._board[erow][2].getUnit() == EMPTY
		&& board._board[erow][3].getUnit() == EMPTY )
		|| ( ecol == 6
		&& board._board[erow][7].getMovecount() == 0
		&& board._board[erow][6].getUnit() == EMPTY
		&& board._board[erow][5].getUnit() == EMPTY ) ) ) {
		setCastling();
	}
}
