
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Palette consists of three sections. We have a set of global operators which
 * will affect any given audio stream, and we have a set of algorithms, which
 * will sequence the operators according to any desired method, and produce a
 * synthesiser.
 * Finally we have a set of effects processors for a final output stage. These
 * can potentially be mixed into any given voice, but would then need to be 
 * define in the palette as well as the FX lists.
 */

#ifndef PALETTE_H
#define PALETTE_H

#define PALETTE_SIZE 32

/*
 * Effects operators.
 */
extern bristolOP * leslieinit();

/*
 * Synth operators
 */
extern bristolOP * bristolinit();
extern bristolOP * noiseinit();
extern bristolOP * dcoinit();
extern bristolOP * envinit();
extern bristolOP * dcainit();
extern bristolOP * filterinit();
extern bristolOP * hammondinit();
extern bristolOP * resinit();
extern bristolOP * prophetdcoinit();
extern bristolOP * dxopinit();
extern bristolOP * hpfinit();
extern bristolOP * junodcoinit();
extern bristolOP * chorusinit();
extern bristolOP * vchorusinit();
extern bristolOP * filter2init();
extern bristolOP * expdcoinit();
extern bristolOP * lfoinit();
extern bristolOP * voxdcoinit();
extern bristolOP * sdcoinit();

struct bristolPalette {
	bristolOP * (*initialise)();
} bristolPalette[PALETTE_SIZE] = {
	dcoinit,
	envinit,
	dcainit,
	filterinit,
	noiseinit,
	hammondinit,
	resinit,
	leslieinit,
	prophetdcoinit,
	dxopinit,
	hpfinit,
	junodcoinit,
	chorusinit,
	vchorusinit,
	filter2init,
	expdcoinit,
	lfoinit, // 16
	voxdcoinit,
	sdcoinit,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

/*
 * Synth algorithms
 */
extern int bristolMMInit();
extern int bristolHammondInit();
extern int bristolProphetInit();
extern int bristolDXInit();
extern int bristolJunoInit();
extern int bristolExpInit();
extern int bristolHammondB3Init();
extern int bristolVoxInit();
extern int bristolSamplerInit();

struct bristolAlgos {
	int (*initialise)(audioMain *, Baudio *);
} bristolAlgos[PALETTE_SIZE] = {
	bristolMMInit,
	bristolHammondInit,
	bristolProphetInit,
	bristolDXInit,
	bristolJunoInit,
	bristolExpInit,
	bristolHammondB3Init,
	bristolVoxInit,
	bristolSamplerInit,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

struct bristolEffects {
	bristolOP * (*initialise)(audioMain *, Baudio *);
} bristolEffects[PALETTE_SIZE] = {
	leslieinit,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

#endif

