
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2009
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * This file was taken out of the engine and moved to the audio library where
 * it correctly lies however it incorporates a few flags from bristol.h header
 * file that should really be removed to keep them independent. That is for
 * later study.
 */

/*#define DEBUG */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>

#ifdef _BRISTOL_JACK
#include <jack/jack.h>

jack_client_t *handle;

static int samplecount, samplerate;

static char *regname = "bgetstats";

static int
bristolJackTest()
{
	if ((handle = jack_client_open(regname, 0, NULL)) == 0)
		return(-1);

	samplerate = jack_get_sample_rate(handle);
	samplecount = jack_get_buffer_size(handle);

	jack_client_close(handle);

	return(0);
}

/*
 * This should go out as the first release with Jack. After that the interface
 * will change - at the moment Jack subsumes Bristol, and this is the wrong
 * way around. The audiomain structure is buried inside the jack structure,
 * but I would prefer the contrary. In addition, with it the contrary then
 * it would be easier to integrate alternative distribution drivers (DSSI).
 */
#endif /* _BRISTOL_JACK */
int
main(int argc, char *argv[])
{
#ifdef _BRISTOL_JACK /* _BRISTOL_JACK */
	printf("%s connects to jack to find rate and counts\n", argv[0]);
	if (bristolJackTest() != 0)
		return(-1);

	printf("JACKSTATS: %i %i\n", samplerate, samplecount);

	return(0);
#else
	printf("This should connect to jack but it does not appear to be compiled\n");
	return(-1);
#endif /* _BRISTOL_JACK */

}

