#ifndef _KDESCOREPAINTER_H_
#define _KDESCOREPAINTER_H_

#include "prScorePainter.h"

#include <qpixmap.h>

class ScoreBar;
class ScoreGroup;
class ScoreChord;
class ScoreBreak;
class Table;
class QPainter;

/** The KdeScorePainter is instantiated only once (as asingleton)!
 *  Thus it should not contain any editor-specific members. It is
 *  thought only to provide methods to paint the ScoreObjects
 *  (bars, groups, chords and breaks).
 */
class KdeScorePainter : public PrScorePainter
{
  friend class KdeFactory;

 private:
  KdeScorePainter();
  QPainter * score;
  QPixmap imgClef[15];
  QPixmap imgFlat;
  QPixmap imgSharp;
  QPixmap imgSign[6];
  QPixmap imgNote[2];
  QPixmap arrBreak[10];
  QPixmap imgFlag[2];
  QPixmap noteAccent[21];
  QPixmap scoreSymbol[33];

  int xpos;
  int xpos1;
  int xpos2;
  int ypos;
  int ypos1;
  int ypos2;
  int common_beams;

 public:
  // factory method
  // static PrScorePainter * getScorePainterInstance();

  virtual void paintBar(ScoreBar*, PrScoreEditor*, Table*, int, int, int);
  virtual void paintGroup(ScoreGroup*, PrScoreEditor*, Table*, int, int);
  virtual void paintChord(ScoreChord*, PrScoreEditor*, Table*, int, int);
  virtual void paintBreak(ScoreBreak*, PrScoreEditor*, int, int);
  virtual int indentSystem(ScoreBar*);
};


#endif
