#ifndef _PRSCOREEDITOR_H_
#define _PRSCOREEDITOR_H_

#include "prPartEditor.h"
#include "scoreIterator.h"

class Table;
class Part;
class Track;
class Reference;

#define YDELTA 80

class PrScoreEditor : public PrPartEditor
{
 private:
  ScoreIterator * _score_iterator;
  bool _horizontal_beams;
  bool _beams_exceed_breaks;

 public:
  PrScoreEditor();
  PrScoreEditor(Part*);
  PrScoreEditor(Track*);
  virtual ~PrScoreEditor();

  bool horizontalBeams() const { return _horizontal_beams; }
  void setHorizontalBeams(bool);

  bool beamsExceedBreaks() const { return _beams_exceed_breaks; }
  void setBeamsExceedBreaks(bool);

  ScoreIterator * iterator() const { return _score_iterator; }
  void setIterator(ScoreIterator*);

  long ticks(int xpos, ScoreArea & area) const;

  int xposition(long ticks);

  int xposition(Position pos);

  virtual void update();

  virtual bool isScoreEditor() const;
};


#endif
