#ifndef _ADDTOSELECTION_CPP_
#define _ADDTOSELECTION_CPP_

#include <iostream.h>

#include "addToSelection.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;

AddToSelection::AddToSelection(Reference * ref) : Operation(), _ref(ref), _delete(0) {
  _type = ADDTOSELECTION;
  _description = "add to selection";
  _to_be_undone = false;
  if (selectioN) {
    selectioN->add(_ref); // no loop: the references following _ref will still be following _ref, after this operation
  }
}


AddToSelection::AddToSelection(const AddToSelection& el) : Operation(el)
{
  _type = ADDTOSELECTION;
  _ref = el._ref;
}

AddToSelection::~AddToSelection() {
  if (_delete) {
    Reference * r1 = 0;
    for (Reference * r = _ref; r!=0; ) {
      r1 = (Reference*) Element::next(r);
      delete r;
      r = r1;
    }
  }
}

void AddToSelection::undo() {
  if (selectioN) {
    // cut selectioN at _ref:
    selectioN->splitBefore(_ref);
    _delete = _ref;
  }
}

void AddToSelection::redo() {
  if (selectioN) {
    selectioN->add(_ref);
    _delete = 0;
  }
}



// ---------------
// virtuals:
//

ostream & AddToSelection::print(int dep, ostream & s) const {
  s << spc(dep) << "<ADDTOSELECTION ref=\"" << _ref->ctype() << "\" />" << endl;
  return s;
}

void AddToSelection::flush(const char * c) const {
  cout << c << "ADDTOSELECTION" << endl;
}

Element * AddToSelection::copy() const {
  return new AddToSelection(*this);
}

#endif
