+++
title = "Pyramid4"
+++

### Pyramid4

A truncated pyramid (frustum) with quadratic base.

<img src="/img/draw/ff/3d/Pyramid4.png" width="30%" >
<img src="/img/draw/ff/2d/Pyramid4_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Pyramid4_xz.svg" width="30%">

#### Constructor

```python
Pyramid4(L, H, alpha)
```

Parameters:
- L, edge length of the quadratic base
- H, height
- alpha, dihedral angle $\alpha$ between the base and a side face.

Constraint:

$H \le \dfrac{\tan\alpha}{2} L$

#### Usage

As for any other [Form factor](/py/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Pyramid4" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron
provided by {{% link-libformfactor %}}.


Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{L^3\tan\alpha}{6}\Big[1-\Big(1-\dfrac{2H}{L\tan\alpha}\Big)^3\Big]. $$

#### Related shapes

More general:
- [Pyramid2](/py/sample/particle/ff/hard/pyramid2), if base is rectangular.

#### Example

Scattering by uncorrelated, oriented pyramids for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/Pyramid4.png">

Generated by {{% ref-ex "ff/Pyramid4.py" %}}.

#### History

Was named "Pyramid" up to BornAgain 1.19.

Corresponds to "Pyramid" form factor of IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.25] and "Square basis pyramid" [[Renaud 2009](/lit/renaud2009), Eq. 215],
except for different parametrization $L = 2R_{IsGISXAXS}$ and a corrected sign.

Reimplemented in BornAgain 1.6 using the generic form factor of a polyhedron
[[Wuttke 2021](/lit/wuttke2021)],
to achieve numerical stability near the removable singularity at $q \to 0$.
