+++
title = "Prism6"
+++

### Prism6

A prism based on regular hexagon.

<img src="/img/draw/ff/3d/Prism6.png" width="30%" >
<img src="/img/draw/ff/2d/Prism6_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Prism6_xz.svg" width="30%">

#### Constructor

```python
Prism6(L, H)
```

Parameters:
- R, edge of the regular hexagonal base
- H, height

#### Usage

As for any other [Form factor](/py/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Prism6" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor is computed as

$$ F(\mathbf{q})=H \space \exp\Big(iq_z\dfrac{H}{2}\Big) \space \text{sinc}\Big(q_z\dfrac{H}{2}\Big) \space F_{||}(\mathbf{q}_{||}) $$

where the form factor $F_{||}(\mathbf{q}_{||}) $ computation is based on the generic form factor of a planar polygon with two-fold symmetry $(S_2)$ provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{3\sqrt3}{2}HR^2. $$

#### Related shapes

More general:
- [Pyramid6](/py/sample/particle/ff/hard/pyramid6), if sides are not vertical.
 
#### Example

Scattering by uncorrelated, oriented prisms for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/Prism6.png">

Generated by {{% ref-ex "ff/Prism3.py" %}}.

#### History

Has been validated against the "Prism6" form factor of IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.30] and "Prism with six fold symmetry" [[Renaud 2009](/lit/renaud2009), Eq. 221], which has different parametrization and lacks a factor $H$ in $F(\mathbf{q})$.
Reimplemented in BornAgain 1.6 using the generic form factor of a polygonal prism with symmetry $S_{2}$ [[Wuttke 2021](/lit/wuttke2021)] to achieve numerical stability near the removable singularity at $q \to 0$.
