//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/XML/UtilXML.h
//! @brief     Defines
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_XML_UTILXML_H
#define BORNAGAIN_GUI_SUPPORT_XML_UTILXML_H

#include <QXmlStreamWriter> // used in every including file
#include <heinz/Complex.h>
#include <heinz/Vectors3D.h>

namespace XML {

constexpr const char* LinkMimeType{"application/org.bornagainproject.fittinglink"};

namespace Attrib {

const QString version("version");
const QString selection_version("selection_version");
const QString binary_version("binary_version");
const QString value("value");
const QString BA_Version("BA_Version");
const QString projectName("projectName");
const QString name("name");
const QString id("id");
const QString type("type");
const QString index("index");
const QString size("size");
const QString xPos("xPos");
const QString yPos("yPos");

} // namespace Attrib

void gotoEndElementOfTag(QXmlStreamReader* reader, const QString& tag);

void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, bool b);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, int d);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, unsigned d);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, double d);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, QString s);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, QColor c);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, const R3& vec);
void writeAttribute(QXmlStreamWriter* writer, const QString& attributeName, const complex_t& c);

unsigned readUIntAttribute(QXmlStreamReader* reader, const QString& attributeName);

void readAttribute(QXmlStreamReader* reader, const QString& attributeName, bool* b);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, int* i);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, unsigned* u);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, double* d);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, QString* s);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, QColor* c);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, R3* vec);
void readAttribute(QXmlStreamReader* reader, const QString& attributeName, complex_t* c);

} // namespace XML

#endif // BORNAGAIN_GUI_SUPPORT_XML_UTILXML_H
