/*
 * losetup.c - setup and control loop devices
 */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <utime.h>
#include <sys/stat.h>
#include <util.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "dbootstrap.h"

/* jump through hoops to be _sure_ we get the right
 * dev_t to make the loop device happy...  */
/*
#include <linux/loop.h>
*/
#include <linux/posix_types.h>
#undef dev_t
#define dev_t __kernel_dev_t
#include <linux/loop.h>
#undef dev_t



/* Loop device setup stuff, swiped from busybox. */

int del_loop(const char *device)
{
   char buf[26]; /* /sbin/losetup /dev/loopXY */
   sprintf(buf, "/sbin/losetup %s", device);
   return execlog(buf, LOG_INFO);
}

int set_loop(const char *device, const char *file, int offset, int *loopro)
{
   char *buf = (char *) malloc(strlen(device) + strlen(file) + 20);
   sprintf(buf, "/sbin/losetup %s %s", device, file);

   return execlog(buf, LOG_INFO);
}

char *find_unused_loop_device (void)
{
	char dev[20];
	int i, fd;
	struct stat statbuf;
	struct loop_info loopinfo;

	for(i = 0; i <= 7; i++) {
	    sprintf(dev, "/dev/loop%d", i);
	    if (stat (dev, &statbuf) == 0 && S_ISBLK(statbuf.st_mode)) {
		if ((fd = open (dev, O_RDONLY)) >= 0) {
		    if(ioctl (fd, LOOP_GET_STATUS, &loopinfo) == -1) {
			if (errno == ENXIO) { /* probably free */
			    close (fd);
			    return strdup(dev);
			}
		    }
		    close (fd);
		}
	    }
	}
        return NULL;
}

/* END CODE */
