/*
 Language List program
 This program allows to see what environments were defined.

 Copyright (C) 1999 The Software in the Public Interest (SPI)
 Written by Michael Sobolev <mss@transas.com>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>

#include "langs.h"

    void dump_variants (const struct language_list *, int);

int
main (void)
{
    const struct language_definition *languages = available_languages (), *lang;

    for (lang = languages ; lang->name != NULL ; ++lang)
    {
        printf ("language: %s (%s)\n", lang->ename, lang->name);
        printf ("  hint: %s\n", lang->hint);
        printf ("  params: %s, %s\n", lang->font, lang->acm);
        printf ("  available variants:\n");

        dump_variants (lang->list, 4);
    }

    return 0;
}

void
dump_variants (const struct language_list *_, int spaces)
{
    int i;

    printf ("%*clist: %s\n", spaces, ' ', _->name);

    spaces += 2;

    for (i = 0 ; _->items[i].d != 0 ; ++i)
        switch (_->items[i].d)
        {
            case 1:     // Item!
                printf ("%*cvariant: %s (%s, %s, %s, %s, %s)\n", spaces, ' ',
                    ((const struct language_item *)_->items[i].p)->name,
                    ((const struct language_item *)_->items[i].p)->locale, ((const struct language_item *)_->items[i].p)->font, ((const struct language_item *)_->items[i].p)->acm, ((const struct language_item *)_->items[i].p)->keymap, ((const struct language_item *)_->items[i].p)->msgcat);
                break;

            case 2:
                dump_variants ((const struct language_list *)_->items[i].p, spaces);
                break;
        }
}
