#
# $Id: helpers.py,v 1.2 2000/01/12 22:57:34 mss Exp $

import string

class Storage:
    def __init__ (self, name):
        self.name = name
        self.ref = []

    def add (self, what):
        try:
            ref = self.ref.index (what)
        except:
            ref = len (self.ref)

            self.ref.append (what)

        return ref

    def reference (self, what):
        return '%s[%s]' % (self.name, self.add (what))

    def declaration (self):
        return 'static char *%s[] = { %s };' % (self.name, string.joinfields (map (lambda x : '"%s"' % x, self.ref), ', '))

class Helper:
    def __init__ (self, valid):
        self.valid = valid

    def __setattr__ (self, key, value):
        if key in [ 'valid' ] or key in self.valid:
            self.__dict__[key] = value
        else:
            raise AttributeError, 'Invalid attribute \`%s\', valid attributes are: %s' % (key, string.joinfields (self.valid, ', '))

class HelperFactory:
    def __init__ (self, **valid):
        self.valid = valid.keys ()

    def __call__ (self, **args):
        result = Helper (self.valid)

        for key, value in args.items ():
            result.__setattr__ (key, value)

        return result

def compare_by_ename (left, right):
    if left.ename < right.ename:
        result = -1
    elif left.ename == right.ename:
        result = 0
    else:
        result = 1

    return result

Language = HelperFactory (
    ename = 'English name for the language',
    charset = 'Charset name to use for displaying choices for this language',
    font = 'Font name',
    acm = 'Application character map to use with the specified font',
    name = 'Language name in the appropriate character set',
    hint = 'Help line to show when the user hightlights the language',
    list = None)

List = HelperFactory (name = 'List name', items = 'list of items')

Item = HelperFactory (name = 'Item name', 
    locale = 'Locale name.  It looks like it\'s impossible to deduct the locale name from other parameters...',
    font = 'Font to use for this very language variant',
    acm = 'Application character map to use with the specified font',
    keymap = 'Name of prefered keymap',
    msgcat = 'The name of file with messages for dbootstrap program')
