#! /bin/sh

# Default directory as of console-data package
font_dir=/usr/share/consolefonts
acm_dir=/usr/share/consoletrans

# We expect fonts to be compressed!
font_suffix=.psf.gz
acm_suffix=.acm.gz

./bf-info fonts | sort | uniq | while read l f a
do
    if [ ! -r $acm_dir/$a$acm_suffix ]
    then
        echo "ACM $a is missing for language $l"
    fi

    if [ ! -r $font_dir/$f$font_suffix ]
    then
        echo "Font $f is missing for language $l"
    fi
done
