#! /bin/bash
# MILO disk maker.  David Huggins-Daines, February 2000
# This is free software under the GNU General Public License

. ./common.sh

if [ $# -lt 2 ]; then
    echo "Usage: $0 image-name outfile" 1>&2
    exit 1
fi

# Name of the MILO image to use
image=$1
subarch=$(echo $image | sed 's,milo_,,')
# File to output
outfile=$2

testroot

[ -f $image ] || error "can't find $image"
[ -f linload.exe ] || error "can't find linload.exe"

if ! command -v srmbootfat >/dev/null 2>&1; then
    cat 1>&2 << EOF
Cannot find srmbootfat!
Get http://www.suse.de/~stepan/source/milo-$milo_version.tar.bz2, unpack it,
enter tools/boot, type make and put srmbootfat somewhere in your path.
EOF
    error
fi

floppy=$(tempfile -d ${tmpdir} -p milo -m 644)
size=1440 # Anything smaller seems to trigger bugs all over the place
mnt=${tmpdir}/boot-floppies/mnt.milo
make_tmpdir $mnt
trap "umount $mnt 2>/dev/null || true ; rmdir $mnt || true; rm -f $floppy" 0 1 2 15

info "making loop filesystem in $floppy, size $size"
dd if=/dev/zero of=$floppy bs=1k count=$size

mkdosfs -r 112 -F 12 $floppy $size
grep -q loop /proc/devices || insmod loop 
mount $floppy -o loop -t msdos $mnt

cp $image $mnt/milo
if [ $subarch = ruffian ]; then
    cp ldmilo.exe $mnt
    cp ldmilo.exe $mnt/linload.exe # keep installation instructions simple...
else
    cp linload.exe $mnt/
fi

date=$(date +'%Y-%m-%d')
cat > $mnt/README << EOF
This disk contains the MILO $MILOVERSION bootloader for the "$subarch"
Alpha architecture.

It was build on $date by $MAINTAINER
as part of the Debian $DEBIANVERSION boot floppies.
EOF

umount $mnt
srmbootfat $floppy milo

# ARCS BIOS requires a bootable x86 boot sector.  It is only required,
# not used in any way.  So we add the magic @0x1FE: leshort 0xAA55. We
# do this after srmbootfat, since it resets it...
echo -ne '\125\252' | dd of=$floppy bs=1 seek=510 count=2 conv=notrunc

cp $floppy $outfile
