// This file is automatically generated.  Do not edit
#include "sah_config.h"

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <string>
#include <iostream>
#include <sstream>
#include <algorithm>

#include "parse.h"
#include "xml_util.h"
#include "db_table.h"
#include "schema_master.h"

#ifdef _WIN32
#pragma warning( disable : 4355 )
#endif

#define found(x) ((x != std::string::npos))

#ifdef USE_NAMESPACE
using namespace ifx;
#endif


const char *db_name="sah2b@sah_master_tcp";
int db_is_open;

template <> const char *const db_type<coordinate_t>::type_name="coordinate_t";
template <> const char *db_type<coordinate_t>::_search_tag=type_name;
template <> const int db_type<coordinate_t>::_nfields=3;
template <> const char *const db_type<coordinate_t>::column_names[3]= {"time","ra","dec"};

coordinate_t::coordinate_t() :
    db_type<coordinate_t>(*this),
    time(0),
    ra(0),
    dec(0) {
    db_open();
}


coordinate_t::coordinate_t(const coordinate_t &a) :
    db_type<coordinate_t>(*this),
    time(a.time),
    ra(a.ra),
    dec(a.dec) {
    db_open();
}


coordinate_t::coordinate_t(const SQL_ROW &a) :
    db_type<coordinate_t>(*this) {
    db_open();
    parse(a);
}


coordinate_t::coordinate_t(const std::string &s,const char *tag) :
    db_type<coordinate_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


coordinate_t &coordinate_t::operator =(const coordinate_t &a) {
    if (&a != this) {
        time=a.time;
        ra=a.ra;
        dec=a.dec;
    }
    return (*this);
}


std::string coordinate_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1; i<3; i++) {
        rv << "?,";
    }
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string coordinate_t::insert_format() const {
    return update_format();
}

std::string coordinate_t::select_format() const {
    std::string rv("");
    for (int i=0; i<2; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string coordinate_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << dec;
    rv << ")";
    return rv.str();
}


std::string coordinate_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<dec>" << dec << "</dec>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void coordinate_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> dec;
        }
    }
}

void coordinate_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> time;
    }
    {
        std::istringstream row(*(s[1]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[2]));
        row >> dec;
    }
}

void coordinate_t::parse(const std::string &s) {
    SQL_ROW row(&s,3);
    parse(row);
}

template <> const char *const db_type<chirp_parameter_t>::type_name="chirp_parameter_t";
template <> const char *db_type<chirp_parameter_t>::_search_tag=type_name;
template <> const int db_type<chirp_parameter_t>::_nfields=2;
template <> const char *const db_type<chirp_parameter_t>::column_names[2]= {"chirp_limit","fft_len_flags"};

chirp_parameter_t::chirp_parameter_t() :
    db_type<chirp_parameter_t>(*this),
    chirp_limit(0),
    fft_len_flags(0) {
    db_open();
}


chirp_parameter_t::chirp_parameter_t(const chirp_parameter_t &a) :
    db_type<chirp_parameter_t>(*this),
    chirp_limit(a.chirp_limit),
    fft_len_flags(a.fft_len_flags) {
    db_open();
}


chirp_parameter_t::chirp_parameter_t(const SQL_ROW &a) :
    db_type<chirp_parameter_t>(*this) {
    db_open();
    parse(a);
}


chirp_parameter_t::chirp_parameter_t(const std::string &s,const char *tag) :
    db_type<chirp_parameter_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


chirp_parameter_t &chirp_parameter_t::operator =(const chirp_parameter_t &a) {
    if (&a != this) {
        chirp_limit=a.chirp_limit;
        fft_len_flags=a.fft_len_flags;
    }
    return (*this);
}


std::string chirp_parameter_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1; i<2; i++) {
        rv << "?,";
    }
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string chirp_parameter_t::insert_format() const {
    return update_format();
}

std::string chirp_parameter_t::select_format() const {
    std::string rv("");
    for (int i=0; i<1; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string chirp_parameter_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << chirp_limit;
    rv << ',';
    rv << fft_len_flags;
    rv << ")";
    return rv.str();
}


std::string chirp_parameter_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<chirp_limit>" << chirp_limit << "</chirp_limit>\n";
    rv << xml_indent() << "<fft_len_flags>" << fft_len_flags << "</fft_len_flags>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void chirp_parameter_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"chirp_limit",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_limit;
        }
        if (extract_xml_record(field,"fft_len_flags",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len_flags;
        }
    }
}

void chirp_parameter_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> chirp_limit;
    }
    {
        std::istringstream row(*(s[1]));
        row >> fft_len_flags;
    }
}

void chirp_parameter_t::parse(const std::string &s) {
    SQL_ROW row(&s,2);
    parse(row);
}

template <> const char *const db_type<subband_description_t>::type_name="subband_description_t";
template <> const char *db_type<subband_description_t>::_search_tag=type_name;
template <> const int db_type<subband_description_t>::_nfields=4;
template <> const char *const db_type<subband_description_t>::column_names[4]= {"number","center","base","sample_rate"};

subband_description_t::subband_description_t() :
    db_type<subband_description_t>(*this),
    number(0),
    center(0),
    base(0),
    sample_rate(0) {
    db_open();
}


subband_description_t::subband_description_t(const subband_description_t &a) :
    db_type<subband_description_t>(*this),
    number(a.number),
    center(a.center),
    base(a.base),
    sample_rate(a.sample_rate) {
    db_open();
}


subband_description_t::subband_description_t(const SQL_ROW &a) :
    db_type<subband_description_t>(*this) {
    db_open();
    parse(a);
}


subband_description_t::subband_description_t(const std::string &s,const char *tag) :
    db_type<subband_description_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


subband_description_t &subband_description_t::operator =(const subband_description_t &a) {
    if (&a != this) {
        number=a.number;
        center=a.center;
        base=a.base;
        sample_rate=a.sample_rate;
    }
    return (*this);
}


std::string subband_description_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1; i<4; i++) {
        rv << "?,";
    }
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string subband_description_t::insert_format() const {
    return update_format();
}

std::string subband_description_t::select_format() const {
    std::string rv("");
    for (int i=0; i<3; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string subband_description_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << number;
    rv << ',';
    rv << center;
    rv << ',';
    rv << base;
    rv << ',';
    rv << sample_rate;
    rv << ")";
    return rv.str();
}


std::string subband_description_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<number>" << number << "</number>\n";
    rv << xml_indent() << "<center>" << center << "</center>\n";
    rv << xml_indent() << "<base>" << base << "</base>\n";
    rv << xml_indent() << "<sample_rate>" << sample_rate << "</sample_rate>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void subband_description_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"number",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> number;
        }
        if (extract_xml_record(field,"center",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> center;
        }
        if (extract_xml_record(field,"base",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> base;
        }
        if (extract_xml_record(field,"sample_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sample_rate;
        }
    }
}

void subband_description_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> number;
    }
    {
        std::istringstream row(*(s[1]));
        row >> center;
    }
    {
        std::istringstream row(*(s[2]));
        row >> base;
    }
    {
        std::istringstream row(*(s[3]));
        row >> sample_rate;
    }
}

void subband_description_t::parse(const std::string &s) {
    SQL_ROW row(&s,4);
    parse(row);
}

template <> const char *const db_type<data_description_t>::type_name="data_description_t";
template <> const char *db_type<data_description_t>::_search_tag=type_name;
template <> const int db_type<data_description_t>::_nfields=9;
template <> const char *const db_type<data_description_t>::column_names[9]= {"start_ra","start_dec","end_ra","end_dec","true_angle_range","time_recorded","time_recorded_jd","nsamples","coords"};

data_description_t::data_description_t() :
    db_type<data_description_t>(*this),
    start_ra(0),
    start_dec(0),
    end_ra(0),
    end_dec(0),
    true_angle_range(0),
    time_recorded_jd(0),
    nsamples(0),
    coords((coordinate_t *)0,0,_x_xml_values) {
    db_open();
    time_recorded[0]=0;
}


data_description_t::data_description_t(const data_description_t &a) :
    db_type<data_description_t>(*this),
    start_ra(a.start_ra),
    start_dec(a.start_dec),
    end_ra(a.end_ra),
    end_dec(a.end_dec),
    true_angle_range(a.true_angle_range),
    time_recorded_jd(a.time_recorded_jd),
    nsamples(a.nsamples),
    coords(a.coords) {
    db_open();
    strcpy(time_recorded,a.time_recorded);
}


data_description_t::data_description_t(const SQL_ROW &a) :
    db_type<data_description_t>(*this) {
    db_open();
    parse(a);
}


data_description_t::data_description_t(const std::string &s,const char *tag) :
    db_type<data_description_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


data_description_t &data_description_t::operator =(const data_description_t &a) {
    if (&a != this) {
        start_ra=a.start_ra;
        start_dec=a.start_dec;
        end_ra=a.end_ra;
        end_dec=a.end_dec;
        true_angle_range=a.true_angle_range;
        time_recorded_jd=a.time_recorded_jd;
        nsamples=a.nsamples;
        {
            coords.clear();
            std::vector<coordinate_t>::const_iterator i(a.coords.begin());
            for (; i!=a.coords.end(); i++) {
                coords.push_back(*i);
            }
        }
        strcpy(time_recorded,a.time_recorded);
    }
    return (*this);
}


std::string data_description_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1; i<9; i++) {
        rv << "?,";
    }
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string data_description_t::insert_format() const {
    return update_format();
}

std::string data_description_t::select_format() const {
    std::string rv("");
    for (int i=0; i<8; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string data_description_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << start_ra;
    rv << ',';
    rv << start_dec;
    rv << ',';
    rv << end_ra;
    rv << ',';
    rv << end_dec;
    rv << ',';
    rv << true_angle_range;
    rv << ',';
    rv << "'" << time_recorded << "'";
    rv << ',';
    rv << time_recorded_jd;
    rv << ',';
    rv << nsamples;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<coordinate_t>::const_iterator p=coords.begin();
        for (; p<coords.end(); p++) {
            rv << p->print();
            if (p != coords.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ")";
    return rv.str();
}


std::string data_description_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<start_ra>" << start_ra << "</start_ra>\n";
    rv << xml_indent() << "<start_dec>" << start_dec << "</start_dec>\n";
    rv << xml_indent() << "<end_ra>" << end_ra << "</end_ra>\n";
    rv << xml_indent() << "<end_dec>" << end_dec << "</end_dec>\n";
    rv << xml_indent() << "<true_angle_range>" << true_angle_range << "</true_angle_range>\n";
    {
        std::string enc_field=xml_encode_string(time_recorded,std::min(strlen(time_recorded),sizeof(time_recorded)));
        rv << xml_indent() << "<time_recorded>";
        rv << enc_field << "</time_recorded>\n";
    }
    rv << xml_indent() << "<time_recorded_jd>" << time_recorded_jd << "</time_recorded_jd>\n";
    rv << xml_indent() << "<nsamples>" << nsamples << "</nsamples>\n";
    if (coords.size()) {
        rv << xml_indent() << "<coords";
        {
            std::string enc_string=coords.print_xml();
            rv << ">\n" ;
            rv << enc_string;
        }
    }
    rv << xml_indent(-2);
    rv << "</coords>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void data_description_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"start_ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> start_ra;
        }
        if (extract_xml_record(field,"start_dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> start_dec;
        }
        if (extract_xml_record(field,"end_ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> end_ra;
        }
        if (extract_xml_record(field,"end_dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> end_dec;
        }
        if (extract_xml_record(field,"true_angle_range",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> true_angle_range;
        }
        if (extract_xml_record(field,"time_recorded",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(time_recorded,(const char *)&(in.front()),std::min(in.size(),(size_t)255));
            time_recorded[std::min(in.size(),(size_t)254)]=0;
        }
        if (extract_xml_record(field,"time_recorded_jd",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time_recorded_jd;
        }
        if (extract_xml_record(field,"nsamples",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> nsamples;
        }
        coords.clear();
        if (extract_xml_record(field,"coords",sub)) {
            pos=0;
            while ((pos=sub.find("<coordinate_t",pos)) != std::string::npos) {
                coords.push_back(coordinate_t(std::string(sub.c_str()+pos)));
                pos=sub.find("</coordinate_t",pos);
                pos=sub.find(">",pos);
            }
        }
    }
}

void data_description_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> start_ra;
    }
    {
        std::istringstream row(*(s[1]));
        row >> start_dec;
    }
    {
        std::istringstream row(*(s[2]));
        row >> end_ra;
    }
    {
        std::istringstream row(*(s[3]));
        row >> end_dec;
    }
    {
        std::istringstream row(*(s[4]));
        row >> true_angle_range;
    }
    {
        strncpy(time_recorded,s[5]->c_str(),255);
        time_recorded[254]=0;
    }
    {
        std::istringstream row(*(s[6]));
        row >> time_recorded_jd;
    }
    {
        std::istringstream row(*(s[7]));
        row >> nsamples;
    }
    {
        std::string::size_type p,q;
        int i;
        coords.clear();
        SQL_ROW tmp(s[8]);
        for (i=0; i<tmp.argc(); i++) {
            coords.push_back(coordinate_t(SQL_ROW(tmp[i])));
        }
    }
}

void data_description_t::parse(const std::string &s) {
    SQL_ROW row(&s,9);
    parse(row);
}

template <> const char *const db_table<receiver_config>::table_name="receiver_config";
template <> const char *db_table<receiver_config>::_search_tag=table_name;
template <> const int db_table<receiver_config>::_nfields=16;
template <> const char *const db_table<receiver_config>::column_names[16]= {"id","s4_id","name","beam_width","center_freq","latitude","longitude","elevation","diameter","az_orientation","az_corr_coeff","zen_corr_coeff","array_az_ellipse","array_za_ellipse","array_angle","min_vgc"};

receiver_config::receiver_config() :
    db_table<receiver_config>(*this,-1),
    id(0),
    s4_id(0),
    beam_width(0),
    center_freq(0),
    latitude(0),
    longitude(0),
    elevation(0),
    diameter(0),
    az_orientation(0),
    az_corr_coeff((float *)0,0,_x_csv),
    zen_corr_coeff((float *)0,0,_x_csv),
    array_az_ellipse(0),
    array_za_ellipse(0),
    array_angle(0),
    min_vgc(0) {
    db_open();
    name[0]=0;
}


receiver_config::receiver_config(const receiver_config &a) :
    db_table<receiver_config>(*this,-1),
    id(a.id),
    s4_id(a.s4_id),
    beam_width(a.beam_width),
    center_freq(a.center_freq),
    latitude(a.latitude),
    longitude(a.longitude),
    elevation(a.elevation),
    diameter(a.diameter),
    az_orientation(a.az_orientation),
    az_corr_coeff(a.az_corr_coeff),
    zen_corr_coeff(a.zen_corr_coeff),
    array_az_ellipse(a.array_az_ellipse),
    array_za_ellipse(a.array_za_ellipse),
    array_angle(a.array_angle),
    min_vgc(a.min_vgc) {
    db_open();
    strcpy(name,a.name);
}


receiver_config::receiver_config(const SQL_ROW &a) :
    db_table<receiver_config>(*this,-1) {
    db_open();
    parse(a);
}


receiver_config::receiver_config(const std::string &s,const char *tag) :
    db_table<receiver_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


receiver_config &receiver_config::operator =(const receiver_config &a) {
    if (&a != this) {
        id=a.id;
        s4_id=a.s4_id;
        beam_width=a.beam_width;
        center_freq=a.center_freq;
        latitude=a.latitude;
        longitude=a.longitude;
        elevation=a.elevation;
        diameter=a.diameter;
        az_orientation=a.az_orientation;
        {
            az_corr_coeff.clear();
            std::vector<float>::const_iterator i(a.az_corr_coeff.begin());
            for (; i!=a.az_corr_coeff.end(); i++) {
                az_corr_coeff.push_back(*i);
            }
        }
        {
            zen_corr_coeff.clear();
            std::vector<float>::const_iterator i(a.zen_corr_coeff.begin());
            for (; i!=a.zen_corr_coeff.end(); i++) {
                zen_corr_coeff.push_back(*i);
            }
        }
        array_az_ellipse=a.array_az_ellipse;
        array_za_ellipse=a.array_za_ellipse;
        array_angle=a.array_angle;
        min_vgc=a.min_vgc;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string receiver_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<16; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string receiver_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string receiver_config::select_format() const {
    std::string rv("");
    for (int i=0; i<15; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string receiver_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << s4_id;
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << beam_width;
    rv << ',';
    rv << center_freq;
    rv << ',';
    rv << latitude;
    rv << ',';
    rv << longitude;
    rv << ',';
    rv << elevation;
    rv << ',';
    rv << diameter;
    rv << ',';
    rv << az_orientation;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<float>::const_iterator p=az_corr_coeff.begin();
        for (; p<az_corr_coeff.end(); p++) {
            rv << *p;
            if (p != az_corr_coeff.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ',';
    rv << "LIST {";
    {
        std::vector<float>::const_iterator p=zen_corr_coeff.begin();
        for (; p<zen_corr_coeff.end(); p++) {
            rv << *p;
            if (p != zen_corr_coeff.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ',';
    rv << array_az_ellipse;
    rv << ',';
    rv << array_za_ellipse;
    rv << ',';
    rv << array_angle;
    rv << ',';
    rv << min_vgc;
    return rv.str();
}


std::string receiver_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<s4_id>" << s4_id << "</s4_id>\n";
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<beam_width>" << beam_width << "</beam_width>\n";
    rv << xml_indent() << "<center_freq>" << center_freq << "</center_freq>\n";
    rv << xml_indent() << "<latitude>" << latitude << "</latitude>\n";
    rv << xml_indent() << "<longitude>" << longitude << "</longitude>\n";
    rv << xml_indent() << "<elevation>" << elevation << "</elevation>\n";
    rv << xml_indent() << "<diameter>" << diameter << "</diameter>\n";
    rv << xml_indent() << "<az_orientation>" << az_orientation << "</az_orientation>\n";
    if (az_corr_coeff.size()) {
        rv << xml_indent() << "<az_corr_coeff";
        {
            std::string enc_string=az_corr_coeff.print_xml();
            rv << " length=" << enc_string.size() << " encoding=\"" << xml_encoding_names[az_corr_coeff.encoding] << "\">" ;
            rv << enc_string;
        }
    }
    rv << "</az_corr_coeff>\n";
    if (zen_corr_coeff.size()) {
        rv << xml_indent() << "<zen_corr_coeff";
        {
            std::string enc_string=zen_corr_coeff.print_xml();
            rv << " length=" << enc_string.size() << " encoding=\"" << xml_encoding_names[zen_corr_coeff.encoding] << "\">" ;
            rv << enc_string;
        }
    }
    rv << "</zen_corr_coeff>\n";
    rv << xml_indent() << "<array_az_ellipse>" << array_az_ellipse << "</array_az_ellipse>\n";
    rv << xml_indent() << "<array_za_ellipse>" << array_za_ellipse << "</array_za_ellipse>\n";
    rv << xml_indent() << "<array_angle>" << array_angle << "</array_angle>\n";
    rv << xml_indent() << "<min_vgc>" << min_vgc << "</min_vgc>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void receiver_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"s4_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> s4_id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)255));
            name[std::min(in.size(),(size_t)254)]=0;
        }
        if (extract_xml_record(field,"beam_width",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> beam_width;
        }
        if (extract_xml_record(field,"center_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> center_freq;
        }
        if (extract_xml_record(field,"latitude",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> latitude;
        }
        if (extract_xml_record(field,"longitude",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> longitude;
        }
        if (extract_xml_record(field,"elevation",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> elevation;
        }
        if (extract_xml_record(field,"diameter",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> diameter;
        }
        if (extract_xml_record(field,"az_orientation",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> az_orientation;
        }
        az_corr_coeff.clear();
        if (extract_xml_record(field,"az_corr_coeff",sub)) {
            pos=sub.find(">");
            do {
                if (pos!=std::string::npos) {
                    do {
                        pos++;
                    } while ((sub[pos]=='\n') || (sub[pos]==','));
                    std::istringstream in(std::string(sub.c_str()+pos));
                    float tmp;
                    in >> tmp;
                    az_corr_coeff.push_back(tmp);
                }
            } while ((pos=sub.find(",",pos)) != std::string::npos);
        }
        zen_corr_coeff.clear();
        if (extract_xml_record(field,"zen_corr_coeff",sub)) {
            pos=sub.find(">");
            do {
                if (pos!=std::string::npos) {
                    do {
                        pos++;
                    } while ((sub[pos]=='\n') || (sub[pos]==','));
                    std::istringstream in(std::string(sub.c_str()+pos));
                    float tmp;
                    in >> tmp;
                    zen_corr_coeff.push_back(tmp);
                }
            } while ((pos=sub.find(",",pos)) != std::string::npos);
        }
        if (extract_xml_record(field,"array_az_ellipse",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> array_az_ellipse;
        }
        if (extract_xml_record(field,"array_za_ellipse",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> array_za_ellipse;
        }
        if (extract_xml_record(field,"array_angle",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> array_angle;
        }
        if (extract_xml_record(field,"min_vgc",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_vgc;
        }
    }
}

void receiver_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> s4_id;
    }
    {
        strncpy(name,s[2]->c_str(),255);
        name[254]=0;
    }
    {
        std::istringstream row(*(s[3]));
        row >> beam_width;
    }
    {
        std::istringstream row(*(s[4]));
        row >> center_freq;
    }
    {
        std::istringstream row(*(s[5]));
        row >> latitude;
    }
    {
        std::istringstream row(*(s[6]));
        row >> longitude;
    }
    {
        std::istringstream row(*(s[7]));
        row >> elevation;
    }
    {
        std::istringstream row(*(s[8]));
        row >> diameter;
    }
    {
        std::istringstream row(*(s[9]));
        row >> az_orientation;
    }
    {
        std::string::size_type p,q;
        int i;
        az_corr_coeff.clear();
        SQL_ROW tmp(s[10]);
        for (i=0; i<tmp.argc(); i++) {
            std::istringstream in(*(tmp[i]));
            float tmp0;
            in >> tmp0;
            az_corr_coeff.push_back(tmp0);
        }
    }
    {
        std::string::size_type p,q;
        int i;
        zen_corr_coeff.clear();
        SQL_ROW tmp(s[11]);
        for (i=0; i<tmp.argc(); i++) {
            std::istringstream in(*(tmp[i]));
            float tmp0;
            in >> tmp0;
            zen_corr_coeff.push_back(tmp0);
        }
    }
    {
        std::istringstream row(*(s[12]));
        row >> array_az_ellipse;
    }
    {
        std::istringstream row(*(s[13]));
        row >> array_za_ellipse;
    }
    {
        std::istringstream row(*(s[14]));
        row >> array_angle;
    }
    {
        std::istringstream row(*(s[15]));
        row >> min_vgc;
    }
}

void receiver_config::parse(const std::string &s) {
    SQL_ROW row(&s,16);
    parse(row);
}

template <> const char *const db_table<recorder_config>::table_name="recorder_config";
template <> const char *db_table<recorder_config>::_search_tag=table_name;
template <> const int db_table<recorder_config>::_nfields=6;
template <> const char *const db_table<recorder_config>::column_names[6]= {"id","name","bits_per_sample","sample_rate","beams","version"};

recorder_config::recorder_config() :
    db_table<recorder_config>(*this,-1),
    id(0),
    bits_per_sample(0),
    sample_rate(0),
    beams(0),
    version(0) {
    db_open();
    name[0]=0;
}


recorder_config::recorder_config(const recorder_config &a) :
    db_table<recorder_config>(*this,-1),
    id(a.id),
    bits_per_sample(a.bits_per_sample),
    sample_rate(a.sample_rate),
    beams(a.beams),
    version(a.version) {
    db_open();
    strcpy(name,a.name);
}


recorder_config::recorder_config(const SQL_ROW &a) :
    db_table<recorder_config>(*this,-1) {
    db_open();
    parse(a);
}


recorder_config::recorder_config(const std::string &s,const char *tag) :
    db_table<recorder_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


recorder_config &recorder_config::operator =(const recorder_config &a) {
    if (&a != this) {
        id=a.id;
        bits_per_sample=a.bits_per_sample;
        sample_rate=a.sample_rate;
        beams=a.beams;
        version=a.version;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string recorder_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<6; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string recorder_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string recorder_config::select_format() const {
    std::string rv("");
    for (int i=0; i<5; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string recorder_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << bits_per_sample;
    rv << ',';
    rv << sample_rate;
    rv << ',';
    rv << beams;
    rv << ',';
    rv << version;
    return rv.str();
}


std::string recorder_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<bits_per_sample>" << bits_per_sample << "</bits_per_sample>\n";
    rv << xml_indent() << "<sample_rate>" << sample_rate << "</sample_rate>\n";
    rv << xml_indent() << "<beams>" << beams << "</beams>\n";
    rv << xml_indent() << "<version>" << version << "</version>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void recorder_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"bits_per_sample",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bits_per_sample;
        }
        if (extract_xml_record(field,"sample_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sample_rate;
        }
        if (extract_xml_record(field,"beams",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> beams;
        }
        if (extract_xml_record(field,"version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> version;
        }
    }
}

void recorder_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(name,s[1]->c_str(),64);
        name[63]=0;
    }
    {
        std::istringstream row(*(s[2]));
        row >> bits_per_sample;
    }
    {
        std::istringstream row(*(s[3]));
        row >> sample_rate;
    }
    {
        std::istringstream row(*(s[4]));
        row >> beams;
    }
    {
        std::istringstream row(*(s[5]));
        row >> version;
    }
}

void recorder_config::parse(const std::string &s) {
    SQL_ROW row(&s,6);
    parse(row);
}

template <> const char *const db_table<splitter_config>::table_name="splitter_config";
template <> const char *db_table<splitter_config>::_search_tag=table_name;
template <> const int db_table<splitter_config>::_nfields=10;
template <> const char *const db_table<splitter_config>::column_names[10]= {"id","version","data_type","fft_len","ifft_len","filter","window","samples_per_wu","highpass""blanker_filter"};

splitter_config::splitter_config() :
    db_table<splitter_config>(*this,-1),
    id(0),
    version(0),
    fft_len(0),
    ifft_len(0),
    samples_per_wu(0),
    highpass(0) {
    db_open();
    data_type[0]=0;
    filter[0]=0;
    window[0]=0;
    blanker_filter[0]=0;
}


splitter_config::splitter_config(const splitter_config &a) :
    db_table<splitter_config>(*this,-1),
    id(a.id),
    version(a.version),
    fft_len(a.fft_len),
    ifft_len(a.ifft_len),
    samples_per_wu(a.samples_per_wu),
    highpass(a.highpass) {
    db_open();
    strcpy(data_type,a.data_type);
    strcpy(filter,a.filter);
    strcpy(window,a.window);
    strcpy(blanker_filter,a.blanker_filter);
}


splitter_config::splitter_config(const SQL_ROW &a) :
    db_table<splitter_config>(*this,-1) {
    db_open();
    parse(a);
}


splitter_config::splitter_config(const std::string &s,const char *tag) :
    db_table<splitter_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


splitter_config &splitter_config::operator =(const splitter_config &a) {
    if (&a != this) {
        id=a.id;
        version=a.version;
        fft_len=a.fft_len;
        ifft_len=a.ifft_len;
        samples_per_wu=a.samples_per_wu;
        highpass=a.highpass;
        strcpy(data_type,a.data_type);
        strcpy(filter,a.filter);
        strcpy(window,a.window);
        strcpy(blanker_filter,a.blanker_filter);
    }
    return (*this);
}


std::string splitter_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<10; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string splitter_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string splitter_config::select_format() const {
    std::string rv("");
    for (int i=0; i<9; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string splitter_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << version;
    rv << ',';
    rv << "'" << data_type << "'";
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << ifft_len;
    rv << ',';
    rv << "'" << filter << "'";
    rv << ',';
    rv << "'" << window << "'";
    rv << ',';
    rv << samples_per_wu;
    rv << ',';
    rv << highpass;
    rv << ',';
    rv << "'" << blanker_filter << "'";
    return rv.str();
}


std::string splitter_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<version>" << version << "</version>\n";
    {
        std::string enc_field=xml_encode_string(data_type,std::min(strlen(data_type),sizeof(data_type)));
        rv << xml_indent() << "<data_type>";
        rv << enc_field << "</data_type>\n";
    }
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<ifft_len>" << ifft_len << "</ifft_len>\n";
    {
        std::string enc_field=xml_encode_string(filter,std::min(strlen(filter),sizeof(filter)));
        rv << xml_indent() << "<filter>";
        rv << enc_field << "</filter>\n";
    }
    {
        std::string enc_field=xml_encode_string(window,std::min(strlen(window),sizeof(window)));
        rv << xml_indent() << "<window>";
        rv << enc_field << "</window>\n";
    }
    rv << xml_indent() << "<samples_per_wu>" << samples_per_wu << "</samples_per_wu>\n";
    rv << xml_indent() << "<highpass>" << highpass << "</highpass>\n";
    {
        std::string enc_field=xml_encode_string(blanker_filter,std::min(strlen(blanker_filter),sizeof(blanker_filter)));
        rv << xml_indent() << "<blanker_filter>";
        rv << enc_field << "</blanker_filter>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void splitter_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> version;
        }
        if (extract_xml_record(field,"data_type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(data_type,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            data_type[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"ifft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ifft_len;
        }
        if (extract_xml_record(field,"filter",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(filter,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            filter[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"window",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(window,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            window[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"samples_per_wu",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> samples_per_wu;
        }
        if (extract_xml_record(field,"highpass",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> highpass;
        }
        if (extract_xml_record(field,"blanker_filter",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(blanker_filter,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            blanker_filter[std::min(in.size(),(size_t)63)]=0;
        }
    }
}

void splitter_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> version;
    }
    {
        strncpy(data_type,s[2]->c_str(),64);
        data_type[63]=0;
    }
    {
        std::istringstream row(*(s[3]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[4]));
        row >> ifft_len;
    }
    {
        strncpy(filter,s[5]->c_str(),64);
        filter[63]=0;
    }
    {
        strncpy(window,s[6]->c_str(),64);
        window[63]=0;
    }
    {
        std::istringstream row(*(s[7]));
        row >> samples_per_wu;
    }
    {
        std::istringstream row(*(s[8]));
        row >> highpass;
    }
    {
        strncpy(blanker_filter,s[9]->c_str(),64);
        blanker_filter[63]=0;
    }
}

void splitter_config::parse(const std::string &s) {
    SQL_ROW row(&s,10);
    parse(row);
}

template <> const char *const db_table<analysis_config>::table_name="analysis_config";
template <> const char *db_table<analysis_config>::_search_tag=table_name;
template <> const int db_table<analysis_config>::_nfields=39;
template <> const char *const db_table<analysis_config>::column_names[39]= {"id","spike_thresh","spikes_per_spectrum","autocorr_thresh","autocorr_per_spectrum","autocorr_fftlen","gauss_null_chi_sq_thresh","gauss_chi_sq_thresh","gauss_power_thresh","gauss_peak_power_thresh","gauss_pot_length","pulse_thresh","pulse_display_thresh","pulse_max","pulse_min","pulse_fft_max","pulse_pot_length","triplet_thresh","triplet_max","triplet_min","triplet_pot_length","pot_overlap_factor","pot_t_offset","pot_min_slew","pot_max_slew","chirp_resolution","analysis_fft_lengths","bsmooth_boxcar_length","bsmooth_chunk_size","chirps","pulse_beams","max_signals","max_spikes","max_autocorr","max_gaussians","max_pulses","max_triplets","keyuniq","credit_rate"};

analysis_config::analysis_config() :
    db_table<analysis_config>(*this,-1),
    id(0),
    spike_thresh(0),
    spikes_per_spectrum(0),
    autocorr_thresh(0),
    autocorr_per_spectrum(0),
    autocorr_fftlen(0),
    gauss_null_chi_sq_thresh(0),
    gauss_chi_sq_thresh(0),
    gauss_power_thresh(0),
    gauss_peak_power_thresh(0),
    gauss_pot_length(0),
    pulse_thresh(0),
    pulse_display_thresh(0),
    pulse_max(0),
    pulse_min(0),
    pulse_fft_max(0),
    pulse_pot_length(0),
    triplet_thresh(0),
    triplet_max(0),
    triplet_min(0),
    triplet_pot_length(0),
    pot_overlap_factor(0),
    pot_t_offset(0),
    pot_min_slew(0),
    pot_max_slew(0),
    chirp_resolution(0),
    analysis_fft_lengths(0),
    bsmooth_boxcar_length(0),
    bsmooth_chunk_size(0),
    chirps((chirp_parameter_t *)0,0,_x_xml_values),
    pulse_beams(0),
    max_signals(0),
    max_spikes(0),
    max_autocorr(0),
    max_gaussians(0),
    max_pulses(0),
    max_triplets(0),
    keyuniq(0),
    credit_rate(0) {
    db_open();
}


analysis_config::analysis_config(const analysis_config &a) :
    db_table<analysis_config>(*this,-1),
    id(a.id),
    spike_thresh(a.spike_thresh),
    spikes_per_spectrum(a.spikes_per_spectrum),
    autocorr_thresh(a.autocorr_thresh),
    autocorr_per_spectrum(a.autocorr_per_spectrum),
    autocorr_fftlen(a.autocorr_fftlen),
    gauss_null_chi_sq_thresh(a.gauss_null_chi_sq_thresh),
    gauss_chi_sq_thresh(a.gauss_chi_sq_thresh),
    gauss_power_thresh(a.gauss_power_thresh),
    gauss_peak_power_thresh(a.gauss_peak_power_thresh),
    gauss_pot_length(a.gauss_pot_length),
    pulse_thresh(a.pulse_thresh),
    pulse_display_thresh(a.pulse_display_thresh),
    pulse_max(a.pulse_max),
    pulse_min(a.pulse_min),
    pulse_fft_max(a.pulse_fft_max),
    pulse_pot_length(a.pulse_pot_length),
    triplet_thresh(a.triplet_thresh),
    triplet_max(a.triplet_max),
    triplet_min(a.triplet_min),
    triplet_pot_length(a.triplet_pot_length),
    pot_overlap_factor(a.pot_overlap_factor),
    pot_t_offset(a.pot_t_offset),
    pot_min_slew(a.pot_min_slew),
    pot_max_slew(a.pot_max_slew),
    chirp_resolution(a.chirp_resolution),
    analysis_fft_lengths(a.analysis_fft_lengths),
    bsmooth_boxcar_length(a.bsmooth_boxcar_length),
    bsmooth_chunk_size(a.bsmooth_chunk_size),
    chirps(a.chirps),
    pulse_beams(a.pulse_beams),
    max_signals(a.max_signals),
    max_spikes(a.max_spikes),
    max_autocorr(a.max_autocorr),
    max_gaussians(a.max_gaussians),
    max_pulses(a.max_pulses),
    max_triplets(a.max_triplets),
    keyuniq(a.keyuniq),
    credit_rate(a.credit_rate) {
    db_open();
}


analysis_config::analysis_config(const SQL_ROW &a) :
    db_table<analysis_config>(*this,-1) {
    db_open();
    parse(a);
}


analysis_config::analysis_config(const std::string &s,const char *tag) :
    db_table<analysis_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


analysis_config &analysis_config::operator =(const analysis_config &a) {
    if (&a != this) {
        id=a.id;
        spike_thresh=a.spike_thresh;
        spikes_per_spectrum=a.spikes_per_spectrum;
        autocorr_thresh=a.autocorr_thresh;
        autocorr_per_spectrum=a.autocorr_per_spectrum;
        autocorr_fftlen=a.autocorr_fftlen;
        gauss_null_chi_sq_thresh=a.gauss_null_chi_sq_thresh;
        gauss_chi_sq_thresh=a.gauss_chi_sq_thresh;
        gauss_power_thresh=a.gauss_power_thresh;
        gauss_peak_power_thresh=a.gauss_peak_power_thresh;
        gauss_pot_length=a.gauss_pot_length;
        pulse_thresh=a.pulse_thresh;
        pulse_display_thresh=a.pulse_display_thresh;
        pulse_max=a.pulse_max;
        pulse_min=a.pulse_min;
        pulse_fft_max=a.pulse_fft_max;
        pulse_pot_length=a.pulse_pot_length;
        triplet_thresh=a.triplet_thresh;
        triplet_max=a.triplet_max;
        triplet_min=a.triplet_min;
        triplet_pot_length=a.triplet_pot_length;
        pot_overlap_factor=a.pot_overlap_factor;
        pot_t_offset=a.pot_t_offset;
        pot_min_slew=a.pot_min_slew;
        pot_max_slew=a.pot_max_slew;
        chirp_resolution=a.chirp_resolution;
        analysis_fft_lengths=a.analysis_fft_lengths;
        bsmooth_boxcar_length=a.bsmooth_boxcar_length;
        bsmooth_chunk_size=a.bsmooth_chunk_size;
        {
            chirps.clear();
            std::vector<chirp_parameter_t>::const_iterator i(a.chirps.begin());
            for (; i!=a.chirps.end(); i++) {
                chirps.push_back(*i);
            }
        }
        pulse_beams=a.pulse_beams;
        max_signals=a.max_signals;
        max_spikes=a.max_spikes;
        max_autocorr=a.max_autocorr;
        max_gaussians=a.max_gaussians;
        max_pulses=a.max_pulses;
        max_triplets=a.max_triplets;
        keyuniq=a.keyuniq;
        credit_rate=a.credit_rate;
    }
    return (*this);
}


std::string analysis_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<39; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string analysis_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string analysis_config::select_format() const {
    std::string rv("");
    for (int i=0; i<38; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string analysis_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << spike_thresh;
    rv << ',';
    rv << spikes_per_spectrum;
    rv << ',';
    rv << autocorr_thresh;
    rv << ',';
    rv << autocorr_per_spectrum;
    rv << ',';
    rv << autocorr_fftlen;
    rv << ',';
    rv << gauss_null_chi_sq_thresh;
    rv << ',';
    rv << gauss_chi_sq_thresh;
    rv << ',';
    rv << gauss_power_thresh;
    rv << ',';
    rv << gauss_peak_power_thresh;
    rv << ',';
    rv << gauss_pot_length;
    rv << ',';
    rv << pulse_thresh;
    rv << ',';
    rv << pulse_display_thresh;
    rv << ',';
    rv << pulse_max;
    rv << ',';
    rv << pulse_min;
    rv << ',';
    rv << pulse_fft_max;
    rv << ',';
    rv << pulse_pot_length;
    rv << ',';
    rv << triplet_thresh;
    rv << ',';
    rv << triplet_max;
    rv << ',';
    rv << triplet_min;
    rv << ',';
    rv << triplet_pot_length;
    rv << ',';
    rv << pot_overlap_factor;
    rv << ',';
    rv << pot_t_offset;
    rv << ',';
    rv << pot_min_slew;
    rv << ',';
    rv << pot_max_slew;
    rv << ',';
    rv << chirp_resolution;
    rv << ',';
    rv << analysis_fft_lengths;
    rv << ',';
    rv << bsmooth_boxcar_length;
    rv << ',';
    rv << bsmooth_chunk_size;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<chirp_parameter_t>::const_iterator p=chirps.begin();
        for (; p<chirps.end(); p++) {
            rv << p->print();
            if (p != chirps.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ',';
    rv << pulse_beams;
    rv << ',';
    rv << max_signals;
    rv << ',';
    rv << max_spikes;
    rv << ',';
    rv << max_autocorr;
    rv << ',';
    rv << max_gaussians;
    rv << ',';
    rv << max_pulses;
    rv << ',';
    rv << max_triplets;
    rv << ',';
    rv << keyuniq;
    rv << ',';
    rv << credit_rate;
    return rv.str();
}


std::string analysis_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<spike_thresh>" << spike_thresh << "</spike_thresh>\n";
    rv << xml_indent() << "<spikes_per_spectrum>" << spikes_per_spectrum << "</spikes_per_spectrum>\n";
    rv << xml_indent() << "<autocorr_thresh>" << autocorr_thresh << "</autocorr_thresh>\n";
    rv << xml_indent() << "<autocorr_per_spectrum>" << autocorr_per_spectrum << "</autocorr_per_spectrum>\n";
    rv << xml_indent() << "<autocorr_fftlen>" << autocorr_fftlen << "</autocorr_fftlen>\n";
    rv << xml_indent() << "<gauss_null_chi_sq_thresh>" << gauss_null_chi_sq_thresh << "</gauss_null_chi_sq_thresh>\n";
    rv << xml_indent() << "<gauss_chi_sq_thresh>" << gauss_chi_sq_thresh << "</gauss_chi_sq_thresh>\n";
    rv << xml_indent() << "<gauss_power_thresh>" << gauss_power_thresh << "</gauss_power_thresh>\n";
    rv << xml_indent() << "<gauss_peak_power_thresh>" << gauss_peak_power_thresh << "</gauss_peak_power_thresh>\n";
    rv << xml_indent() << "<gauss_pot_length>" << gauss_pot_length << "</gauss_pot_length>\n";
    rv << xml_indent() << "<pulse_thresh>" << pulse_thresh << "</pulse_thresh>\n";
    rv << xml_indent() << "<pulse_display_thresh>" << pulse_display_thresh << "</pulse_display_thresh>\n";
    rv << xml_indent() << "<pulse_max>" << pulse_max << "</pulse_max>\n";
    rv << xml_indent() << "<pulse_min>" << pulse_min << "</pulse_min>\n";
    rv << xml_indent() << "<pulse_fft_max>" << pulse_fft_max << "</pulse_fft_max>\n";
    rv << xml_indent() << "<pulse_pot_length>" << pulse_pot_length << "</pulse_pot_length>\n";
    rv << xml_indent() << "<triplet_thresh>" << triplet_thresh << "</triplet_thresh>\n";
    rv << xml_indent() << "<triplet_max>" << triplet_max << "</triplet_max>\n";
    rv << xml_indent() << "<triplet_min>" << triplet_min << "</triplet_min>\n";
    rv << xml_indent() << "<triplet_pot_length>" << triplet_pot_length << "</triplet_pot_length>\n";
    rv << xml_indent() << "<pot_overlap_factor>" << pot_overlap_factor << "</pot_overlap_factor>\n";
    rv << xml_indent() << "<pot_t_offset>" << pot_t_offset << "</pot_t_offset>\n";
    rv << xml_indent() << "<pot_min_slew>" << pot_min_slew << "</pot_min_slew>\n";
    rv << xml_indent() << "<pot_max_slew>" << pot_max_slew << "</pot_max_slew>\n";
    rv << xml_indent() << "<chirp_resolution>" << chirp_resolution << "</chirp_resolution>\n";
    rv << xml_indent() << "<analysis_fft_lengths>" << analysis_fft_lengths << "</analysis_fft_lengths>\n";
    rv << xml_indent() << "<bsmooth_boxcar_length>" << bsmooth_boxcar_length << "</bsmooth_boxcar_length>\n";
    rv << xml_indent() << "<bsmooth_chunk_size>" << bsmooth_chunk_size << "</bsmooth_chunk_size>\n";
    if (chirps.size()) {
        rv << xml_indent() << "<chirps";
        {
            std::string enc_string=chirps.print_xml();
            rv << ">\n" ;
            rv << enc_string;
        }
    }
    rv << xml_indent(-2);
    rv << "</chirps>\n";
    rv << xml_indent() << "<pulse_beams>" << pulse_beams << "</pulse_beams>\n";
    rv << xml_indent() << "<max_signals>" << max_signals << "</max_signals>\n";
    rv << xml_indent() << "<max_spikes>" << max_spikes << "</max_spikes>\n";
    rv << xml_indent() << "<max_autocorr>" << max_autocorr << "</max_autocorr>\n";
    rv << xml_indent() << "<max_gaussians>" << max_gaussians << "</max_gaussians>\n";
    rv << xml_indent() << "<max_pulses>" << max_pulses << "</max_pulses>\n";
    rv << xml_indent() << "<max_triplets>" << max_triplets << "</max_triplets>\n";
    rv << xml_indent() << "<keyuniq>" << keyuniq << "</keyuniq>\n";
    rv << xml_indent() << "<credit_rate>" << credit_rate << "</credit_rate>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void analysis_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"spike_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_thresh;
        }
        if (extract_xml_record(field,"spikes_per_spectrum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spikes_per_spectrum;
        }
        if (extract_xml_record(field,"autocorr_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> autocorr_thresh;
        }
        if (extract_xml_record(field,"autocorr_per_spectrum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> autocorr_per_spectrum;
        }
        if (extract_xml_record(field,"autocorr_fftlen",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> autocorr_fftlen;
        }
        if (extract_xml_record(field,"gauss_null_chi_sq_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_null_chi_sq_thresh;
        }
        if (extract_xml_record(field,"gauss_chi_sq_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_chi_sq_thresh;
        }
        if (extract_xml_record(field,"gauss_power_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_power_thresh;
        }
        if (extract_xml_record(field,"gauss_peak_power_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_peak_power_thresh;
        }
        if (extract_xml_record(field,"gauss_pot_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_pot_length;
        }
        if (extract_xml_record(field,"pulse_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_thresh;
        }
        if (extract_xml_record(field,"pulse_display_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_display_thresh;
        }
        if (extract_xml_record(field,"pulse_max",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_max;
        }
        if (extract_xml_record(field,"pulse_min",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_min;
        }
        if (extract_xml_record(field,"pulse_fft_max",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_fft_max;
        }
        if (extract_xml_record(field,"pulse_pot_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_pot_length;
        }
        if (extract_xml_record(field,"triplet_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_thresh;
        }
        if (extract_xml_record(field,"triplet_max",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_max;
        }
        if (extract_xml_record(field,"triplet_min",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_min;
        }
        if (extract_xml_record(field,"triplet_pot_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_pot_length;
        }
        if (extract_xml_record(field,"pot_overlap_factor",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_overlap_factor;
        }
        if (extract_xml_record(field,"pot_t_offset",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_t_offset;
        }
        if (extract_xml_record(field,"pot_min_slew",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_min_slew;
        }
        if (extract_xml_record(field,"pot_max_slew",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_max_slew;
        }
        if (extract_xml_record(field,"chirp_resolution",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_resolution;
        }
        if (extract_xml_record(field,"analysis_fft_lengths",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> analysis_fft_lengths;
        }
        if (extract_xml_record(field,"bsmooth_boxcar_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bsmooth_boxcar_length;
        }
        if (extract_xml_record(field,"bsmooth_chunk_size",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bsmooth_chunk_size;
        }
        chirps.clear();
        if (extract_xml_record(field,"chirps",sub)) {
            pos=0;
            while ((pos=sub.find("<chirp_parameter_t",pos)) != std::string::npos) {
                chirps.push_back(chirp_parameter_t(std::string(sub.c_str()+pos)));
                pos=sub.find("</chirp_parameter_t",pos);
                pos=sub.find(">",pos);
            }
        }
        if (extract_xml_record(field,"pulse_beams",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_beams;
        }
        if (extract_xml_record(field,"max_signals",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_signals;
        }
        if (extract_xml_record(field,"max_spikes",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_spikes;
        }
        if (extract_xml_record(field,"max_autocorr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_autocorr;
        }
        if (extract_xml_record(field,"max_gaussians",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_gaussians;
        }
        if (extract_xml_record(field,"max_pulses",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_pulses;
        }
        if (extract_xml_record(field,"max_triplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_triplets;
        }
        if (extract_xml_record(field,"keyuniq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> keyuniq;
        }
        if (extract_xml_record(field,"credit_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> credit_rate;
        }
    }
}

void analysis_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> spike_thresh;
    }
    {
        std::istringstream row(*(s[2]));
        row >> spikes_per_spectrum;
    }
    {
        std::istringstream row(*(s[3]));
        row >> autocorr_thresh;
    }
    {
        std::istringstream row(*(s[4]));
        row >> autocorr_per_spectrum;
    }
    {
        std::istringstream row(*(s[5]));
        row >> autocorr_fftlen;
    }
    {
        std::istringstream row(*(s[6]));
        row >> gauss_null_chi_sq_thresh;
    }
    {
        std::istringstream row(*(s[7]));
        row >> gauss_chi_sq_thresh;
    }
    {
        std::istringstream row(*(s[8]));
        row >> gauss_power_thresh;
    }
    {
        std::istringstream row(*(s[9]));
        row >> gauss_peak_power_thresh;
    }
    {
        std::istringstream row(*(s[10]));
        row >> gauss_pot_length;
    }
    {
        std::istringstream row(*(s[11]));
        row >> pulse_thresh;
    }
    {
        std::istringstream row(*(s[12]));
        row >> pulse_display_thresh;
    }
    {
        std::istringstream row(*(s[13]));
        row >> pulse_max;
    }
    {
        std::istringstream row(*(s[14]));
        row >> pulse_min;
    }
    {
        std::istringstream row(*(s[15]));
        row >> pulse_fft_max;
    }
    {
        std::istringstream row(*(s[16]));
        row >> pulse_pot_length;
    }
    {
        std::istringstream row(*(s[17]));
        row >> triplet_thresh;
    }
    {
        std::istringstream row(*(s[18]));
        row >> triplet_max;
    }
    {
        std::istringstream row(*(s[19]));
        row >> triplet_min;
    }
    {
        std::istringstream row(*(s[20]));
        row >> triplet_pot_length;
    }
    {
        std::istringstream row(*(s[21]));
        row >> pot_overlap_factor;
    }
    {
        std::istringstream row(*(s[22]));
        row >> pot_t_offset;
    }
    {
        std::istringstream row(*(s[23]));
        row >> pot_min_slew;
    }
    {
        std::istringstream row(*(s[24]));
        row >> pot_max_slew;
    }
    {
        std::istringstream row(*(s[25]));
        row >> chirp_resolution;
    }
    {
        std::istringstream row(*(s[26]));
        row >> analysis_fft_lengths;
    }
    {
        std::istringstream row(*(s[27]));
        row >> bsmooth_boxcar_length;
    }
    {
        std::istringstream row(*(s[28]));
        row >> bsmooth_chunk_size;
    }
    {
        std::string::size_type p,q;
        int i;
        chirps.clear();
        SQL_ROW tmp(s[29]);
        for (i=0; i<tmp.argc(); i++) {
            chirps.push_back(chirp_parameter_t(SQL_ROW(tmp[i])));
        }
    }
    {
        std::istringstream row(*(s[30]));
        row >> pulse_beams;
    }
    {
        std::istringstream row(*(s[31]));
        row >> max_signals;
    }
    {
        std::istringstream row(*(s[32]));
        row >> max_spikes;
    }
    {
        std::istringstream row(*(s[33]));
        row >> max_autocorr;
    }
    {
        std::istringstream row(*(s[34]));
        row >> max_gaussians;
    }
    {
        std::istringstream row(*(s[35]));
        row >> max_pulses;
    }
    {
        std::istringstream row(*(s[36]));
        row >> max_triplets;
    }
    {
        std::istringstream row(*(s[37]));
        row >> keyuniq;
    }
    {
        std::istringstream row(*(s[38]));
        row >> credit_rate;
    }
}

void analysis_config::parse(const std::string &s) {
    SQL_ROW row(&s,39);
    parse(row);
}

template <> const char *const db_table<science_config>::table_name="science_config";
template <> const char *db_table<science_config>::_search_tag=table_name;
template <> const int db_table<science_config>::_nfields=29;
template <> const char *const db_table<science_config>::column_names[29]= {"id","active","qpix_scheme","qpix_nside","fpix_width","total_bandwidth","freq_uncertainty","fwhm_beamwidth","sky_disc_radius","observable_sky","epoch","bary_chirp_window","bary_freq_window","nonbary_freq_window","spike_obs_duration","spike_obs_interval","gauss_obs_duration","gauss_obs_interval","pulse_obs_duration","pulse_obs_interval","triplet_obs_duration","triplet_obs_interval","min_spike_id","min_autocorr_id","min_gaussian_id","min_pulse_id","min_triplet_id","min_app_version""info_xml"};

science_config::science_config() :
    db_table<science_config>(*this,-1),
    id(0),
    active(0),
    qpix_nside(0),
    fpix_width(0),
    total_bandwidth(0),
    freq_uncertainty(0),
    fwhm_beamwidth(0),
    sky_disc_radius(0),
    observable_sky(0),
    epoch(0),
    bary_chirp_window(0),
    bary_freq_window(0),
    nonbary_freq_window(0),
    spike_obs_duration(0),
    spike_obs_interval(0),
    gauss_obs_duration(0),
    gauss_obs_interval(0),
    pulse_obs_duration(0),
    pulse_obs_interval(0),
    triplet_obs_duration(0),
    triplet_obs_interval(0),
    min_spike_id(0),
    min_autocorr_id(0),
    min_gaussian_id(0),
    min_pulse_id(0),
    min_triplet_id(0),
    min_app_version(0) {
    db_open();
    qpix_scheme[0]=0;
    info_xml[0]=0;
}


science_config::science_config(const science_config &a) :
    db_table<science_config>(*this,-1),
    id(a.id),
    active(a.active),
    qpix_nside(a.qpix_nside),
    fpix_width(a.fpix_width),
    total_bandwidth(a.total_bandwidth),
    freq_uncertainty(a.freq_uncertainty),
    fwhm_beamwidth(a.fwhm_beamwidth),
    sky_disc_radius(a.sky_disc_radius),
    observable_sky(a.observable_sky),
    epoch(a.epoch),
    bary_chirp_window(a.bary_chirp_window),
    bary_freq_window(a.bary_freq_window),
    nonbary_freq_window(a.nonbary_freq_window),
    spike_obs_duration(a.spike_obs_duration),
    spike_obs_interval(a.spike_obs_interval),
    gauss_obs_duration(a.gauss_obs_duration),
    gauss_obs_interval(a.gauss_obs_interval),
    pulse_obs_duration(a.pulse_obs_duration),
    pulse_obs_interval(a.pulse_obs_interval),
    triplet_obs_duration(a.triplet_obs_duration),
    triplet_obs_interval(a.triplet_obs_interval),
    min_spike_id(a.min_spike_id),
    min_autocorr_id(a.min_autocorr_id),
    min_gaussian_id(a.min_gaussian_id),
    min_pulse_id(a.min_pulse_id),
    min_triplet_id(a.min_triplet_id),
    min_app_version(a.min_app_version) {
    db_open();
    strcpy(qpix_scheme,a.qpix_scheme);
    strcpy(info_xml,a.info_xml);
}


science_config::science_config(const SQL_ROW &a) :
    db_table<science_config>(*this,-1) {
    db_open();
    parse(a);
}


science_config::science_config(const std::string &s,const char *tag) :
    db_table<science_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


science_config &science_config::operator =(const science_config &a) {
    if (&a != this) {
        id=a.id;
        active=a.active;
        qpix_nside=a.qpix_nside;
        fpix_width=a.fpix_width;
        total_bandwidth=a.total_bandwidth;
        freq_uncertainty=a.freq_uncertainty;
        fwhm_beamwidth=a.fwhm_beamwidth;
        sky_disc_radius=a.sky_disc_radius;
        observable_sky=a.observable_sky;
        epoch=a.epoch;
        bary_chirp_window=a.bary_chirp_window;
        bary_freq_window=a.bary_freq_window;
        nonbary_freq_window=a.nonbary_freq_window;
        spike_obs_duration=a.spike_obs_duration;
        spike_obs_interval=a.spike_obs_interval;
        gauss_obs_duration=a.gauss_obs_duration;
        gauss_obs_interval=a.gauss_obs_interval;
        pulse_obs_duration=a.pulse_obs_duration;
        pulse_obs_interval=a.pulse_obs_interval;
        triplet_obs_duration=a.triplet_obs_duration;
        triplet_obs_interval=a.triplet_obs_interval;
        min_spike_id=a.min_spike_id;
        min_autocorr_id=a.min_autocorr_id;
        min_gaussian_id=a.min_gaussian_id;
        min_pulse_id=a.min_pulse_id;
        min_triplet_id=a.min_triplet_id;
        min_app_version=a.min_app_version;
        strcpy(qpix_scheme,a.qpix_scheme);
        strcpy(info_xml,a.info_xml);
    }
    return (*this);
}


std::string science_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<29; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string science_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string science_config::select_format() const {
    std::string rv("");
    for (int i=0; i<28; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string science_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << active;
    rv << ',';
    rv << "'" << qpix_scheme << "'";
    rv << ',';
    rv << qpix_nside;
    rv << ',';
    rv << fpix_width;
    rv << ',';
    rv << total_bandwidth;
    rv << ',';
    rv << freq_uncertainty;
    rv << ',';
    rv << fwhm_beamwidth;
    rv << ',';
    rv << sky_disc_radius;
    rv << ',';
    rv << observable_sky;
    rv << ',';
    rv << epoch;
    rv << ',';
    rv << bary_chirp_window;
    rv << ',';
    rv << bary_freq_window;
    rv << ',';
    rv << nonbary_freq_window;
    rv << ',';
    rv << spike_obs_duration;
    rv << ',';
    rv << spike_obs_interval;
    rv << ',';
    rv << gauss_obs_duration;
    rv << ',';
    rv << gauss_obs_interval;
    rv << ',';
    rv << pulse_obs_duration;
    rv << ',';
    rv << pulse_obs_interval;
    rv << ',';
    rv << triplet_obs_duration;
    rv << ',';
    rv << triplet_obs_interval;
    rv << ',';
    rv << min_spike_id;
    rv << ',';
    rv << min_autocorr_id;
    rv << ',';
    rv << min_gaussian_id;
    rv << ',';
    rv << min_pulse_id;
    rv << ',';
    rv << min_triplet_id;
    rv << ',';
    rv << min_app_version;
    rv << ',';
    rv << "'" << info_xml << "'";
    return rv.str();
}


std::string science_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<active>" << active << "</active>\n";
    {
        std::string enc_field=xml_encode_string(qpix_scheme,std::min(strlen(qpix_scheme),sizeof(qpix_scheme)));
        rv << xml_indent() << "<qpix_scheme>";
        rv << enc_field << "</qpix_scheme>\n";
    }
    rv << xml_indent() << "<qpix_nside>" << qpix_nside << "</qpix_nside>\n";
    rv << xml_indent() << "<fpix_width>" << fpix_width << "</fpix_width>\n";
    rv << xml_indent() << "<total_bandwidth>" << total_bandwidth << "</total_bandwidth>\n";
    rv << xml_indent() << "<freq_uncertainty>" << freq_uncertainty << "</freq_uncertainty>\n";
    rv << xml_indent() << "<fwhm_beamwidth>" << fwhm_beamwidth << "</fwhm_beamwidth>\n";
    rv << xml_indent() << "<sky_disc_radius>" << sky_disc_radius << "</sky_disc_radius>\n";
    rv << xml_indent() << "<observable_sky>" << observable_sky << "</observable_sky>\n";
    rv << xml_indent() << "<epoch>" << epoch << "</epoch>\n";
    rv << xml_indent() << "<bary_chirp_window>" << bary_chirp_window << "</bary_chirp_window>\n";
    rv << xml_indent() << "<bary_freq_window>" << bary_freq_window << "</bary_freq_window>\n";
    rv << xml_indent() << "<nonbary_freq_window>" << nonbary_freq_window << "</nonbary_freq_window>\n";
    rv << xml_indent() << "<spike_obs_duration>" << spike_obs_duration << "</spike_obs_duration>\n";
    rv << xml_indent() << "<spike_obs_interval>" << spike_obs_interval << "</spike_obs_interval>\n";
    rv << xml_indent() << "<gauss_obs_duration>" << gauss_obs_duration << "</gauss_obs_duration>\n";
    rv << xml_indent() << "<gauss_obs_interval>" << gauss_obs_interval << "</gauss_obs_interval>\n";
    rv << xml_indent() << "<pulse_obs_duration>" << pulse_obs_duration << "</pulse_obs_duration>\n";
    rv << xml_indent() << "<pulse_obs_interval>" << pulse_obs_interval << "</pulse_obs_interval>\n";
    rv << xml_indent() << "<triplet_obs_duration>" << triplet_obs_duration << "</triplet_obs_duration>\n";
    rv << xml_indent() << "<triplet_obs_interval>" << triplet_obs_interval << "</triplet_obs_interval>\n";
    rv << xml_indent() << "<min_spike_id>" << min_spike_id << "</min_spike_id>\n";
    rv << xml_indent() << "<min_autocorr_id>" << min_autocorr_id << "</min_autocorr_id>\n";
    rv << xml_indent() << "<min_gaussian_id>" << min_gaussian_id << "</min_gaussian_id>\n";
    rv << xml_indent() << "<min_pulse_id>" << min_pulse_id << "</min_pulse_id>\n";
    rv << xml_indent() << "<min_triplet_id>" << min_triplet_id << "</min_triplet_id>\n";
    rv << xml_indent() << "<min_app_version>" << min_app_version << "</min_app_version>\n";
    {
        std::string enc_field=xml_encode_string(info_xml,std::min(strlen(info_xml),sizeof(info_xml)));
        rv << xml_indent() << "<info_xml>";
        rv << enc_field << "</info_xml>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void science_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"active",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> active;
        }
        if (extract_xml_record(field,"qpix_scheme",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(qpix_scheme,(const char *)&(in.front()),std::min(in.size(),(size_t)16));
            qpix_scheme[std::min(in.size(),(size_t)15)]=0;
        }
        if (extract_xml_record(field,"qpix_nside",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> qpix_nside;
        }
        if (extract_xml_record(field,"fpix_width",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fpix_width;
        }
        if (extract_xml_record(field,"total_bandwidth",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> total_bandwidth;
        }
        if (extract_xml_record(field,"freq_uncertainty",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq_uncertainty;
        }
        if (extract_xml_record(field,"fwhm_beamwidth",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fwhm_beamwidth;
        }
        if (extract_xml_record(field,"sky_disc_radius",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sky_disc_radius;
        }
        if (extract_xml_record(field,"observable_sky",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> observable_sky;
        }
        if (extract_xml_record(field,"epoch",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> epoch;
        }
        if (extract_xml_record(field,"bary_chirp_window",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bary_chirp_window;
        }
        if (extract_xml_record(field,"bary_freq_window",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bary_freq_window;
        }
        if (extract_xml_record(field,"nonbary_freq_window",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> nonbary_freq_window;
        }
        if (extract_xml_record(field,"spike_obs_duration",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_obs_duration;
        }
        if (extract_xml_record(field,"spike_obs_interval",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_obs_interval;
        }
        if (extract_xml_record(field,"gauss_obs_duration",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_obs_duration;
        }
        if (extract_xml_record(field,"gauss_obs_interval",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_obs_interval;
        }
        if (extract_xml_record(field,"pulse_obs_duration",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_obs_duration;
        }
        if (extract_xml_record(field,"pulse_obs_interval",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_obs_interval;
        }
        if (extract_xml_record(field,"triplet_obs_duration",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_obs_duration;
        }
        if (extract_xml_record(field,"triplet_obs_interval",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_obs_interval;
        }
        if (extract_xml_record(field,"min_spike_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_spike_id;
        }
        if (extract_xml_record(field,"min_autocorr_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_autocorr_id;
        }
        if (extract_xml_record(field,"min_gaussian_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_gaussian_id;
        }
        if (extract_xml_record(field,"min_pulse_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_pulse_id;
        }
        if (extract_xml_record(field,"min_triplet_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_triplet_id;
        }
        if (extract_xml_record(field,"min_app_version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_app_version;
        }
        if (extract_xml_record(field,"info_xml",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(info_xml,(const char *)&(in.front()),std::min(in.size(),(size_t)255));
            info_xml[std::min(in.size(),(size_t)254)]=0;
        }
    }
}

void science_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> active;
    }
    {
        strncpy(qpix_scheme,s[2]->c_str(),16);
        qpix_scheme[15]=0;
    }
    {
        std::istringstream row(*(s[3]));
        row >> qpix_nside;
    }
    {
        std::istringstream row(*(s[4]));
        row >> fpix_width;
    }
    {
        std::istringstream row(*(s[5]));
        row >> total_bandwidth;
    }
    {
        std::istringstream row(*(s[6]));
        row >> freq_uncertainty;
    }
    {
        std::istringstream row(*(s[7]));
        row >> fwhm_beamwidth;
    }
    {
        std::istringstream row(*(s[8]));
        row >> sky_disc_radius;
    }
    {
        std::istringstream row(*(s[9]));
        row >> observable_sky;
    }
    {
        std::istringstream row(*(s[10]));
        row >> epoch;
    }
    {
        std::istringstream row(*(s[11]));
        row >> bary_chirp_window;
    }
    {
        std::istringstream row(*(s[12]));
        row >> bary_freq_window;
    }
    {
        std::istringstream row(*(s[13]));
        row >> nonbary_freq_window;
    }
    {
        std::istringstream row(*(s[14]));
        row >> spike_obs_duration;
    }
    {
        std::istringstream row(*(s[15]));
        row >> spike_obs_interval;
    }
    {
        std::istringstream row(*(s[16]));
        row >> gauss_obs_duration;
    }
    {
        std::istringstream row(*(s[17]));
        row >> gauss_obs_interval;
    }
    {
        std::istringstream row(*(s[18]));
        row >> pulse_obs_duration;
    }
    {
        std::istringstream row(*(s[19]));
        row >> pulse_obs_interval;
    }
    {
        std::istringstream row(*(s[20]));
        row >> triplet_obs_duration;
    }
    {
        std::istringstream row(*(s[21]));
        row >> triplet_obs_interval;
    }
    {
        std::istringstream row(*(s[22]));
        row >> min_spike_id;
    }
    {
        std::istringstream row(*(s[23]));
        row >> min_autocorr_id;
    }
    {
        std::istringstream row(*(s[24]));
        row >> min_gaussian_id;
    }
    {
        std::istringstream row(*(s[25]));
        row >> min_pulse_id;
    }
    {
        std::istringstream row(*(s[26]));
        row >> min_triplet_id;
    }
    {
        std::istringstream row(*(s[27]));
        row >> min_app_version;
    }
    {
        strncpy(info_xml,s[28]->c_str(),255);
        info_xml[254]=0;
    }
}

void science_config::parse(const std::string &s) {
    SQL_ROW row(&s,29);
    parse(row);
}

template <> const char *const db_type<candidate_t>::type_name="candidate_t";
template <> const char *db_type<candidate_t>::_search_tag=type_name;
template <> const int db_type<candidate_t>::_nfields=5;
template <> const char *const db_type<candidate_t>::column_names[5]= {"type","id","num_obs","score","is_rfi"};

candidate_t::candidate_t() :
    db_type<candidate_t>(*this),
    type(0),
    id(0),
    num_obs(0),
    score(0),
    is_rfi(0) {
    db_open();
}


candidate_t::candidate_t(const candidate_t &a) :
    db_type<candidate_t>(*this),
    type(a.type),
    id(a.id),
    num_obs(a.num_obs),
    score(a.score),
    is_rfi(a.is_rfi) {
    db_open();
}


candidate_t::candidate_t(const SQL_ROW &a) :
    db_type<candidate_t>(*this) {
    db_open();
    parse(a);
}


candidate_t::candidate_t(const std::string &s,const char *tag) :
    db_type<candidate_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


candidate_t &candidate_t::operator =(const candidate_t &a) {
    if (&a != this) {
        type=a.type;
        id=a.id;
        num_obs=a.num_obs;
        score=a.score;
        is_rfi=a.is_rfi;
    }
    return (*this);
}


std::string candidate_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1; i<5; i++) {
        rv << "?,";
    }
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string candidate_t::insert_format() const {
    return update_format();
}

std::string candidate_t::select_format() const {
    std::string rv("");
    for (int i=0; i<4; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string candidate_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << type;
    rv << ',';
    rv << id;
    rv << ',';
    rv << num_obs;
    rv << ',';
    rv << score;
    rv << ',';
    rv << is_rfi;
    rv << ")";
    return rv.str();
}


std::string candidate_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<type>" << type << "</type>\n";
    rv << xml_indent() << "<id>" << id << "</id>\n";
    rv << xml_indent() << "<num_obs>" << num_obs << "</num_obs>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<is_rfi>" << is_rfi << "</is_rfi>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void candidate_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> type;
        }
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"num_obs",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_obs;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"is_rfi",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> is_rfi;
        }
    }
}

void candidate_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> type;
    }
    {
        std::istringstream row(*(s[1]));
        row >> id;
    }
    {
        std::istringstream row(*(s[2]));
        row >> num_obs;
    }
    {
        std::istringstream row(*(s[3]));
        row >> score;
    }
    {
        std::istringstream row(*(s[4]));
        row >> is_rfi;
    }
}

void candidate_t::parse(const std::string &s) {
    SQL_ROW row(&s,5);
    parse(row);
}

template <> const char *const db_table<meta_candidate>::table_name="meta_candidate";
template <> const char *db_table<meta_candidate>::_search_tag=table_name;
template <> const int db_table<meta_candidate>::_nfields=32;
template <> const char *const db_table<meta_candidate>::column_names[32]= {"id","version","time_last_updated","num_spikes","num_spike_b_multiplets","best_spike_b_mp_score","num_spike_nb_multiplets","best_spike_nb_mp_score","spike_high_id","num_gaussians","num_gaussian_b_multiplets","best_gaussian_b_mp_score","num_gaussian_nb_multiplets","best_gaussian_nb_mp_score","gaussian_high_id","num_pulses","num_pulse_b_multiplets","best_pulse_b_mp_score","num_pulse_nb_multiplets","best_pulse_nb_mp_score","pulse_high_id","num_triplets","num_triplet_b_multiplets","best_triplet_b_mp_score","num_triplet_nb_multiplets","best_triplet_nb_mp_score","triplet_high_id","num_stars","best_star_score","meta_score","rfi_clean","state"};

meta_candidate::meta_candidate() :
    db_table<meta_candidate>(*this,-1),
    id(0),
    version(0),
    time_last_updated(0),
    num_spikes(0),
    num_spike_b_multiplets(0),
    best_spike_b_mp_score(0),
    num_spike_nb_multiplets(0),
    best_spike_nb_mp_score(0),
    spike_high_id(0),
    num_gaussians(0),
    num_gaussian_b_multiplets(0),
    best_gaussian_b_mp_score(0),
    num_gaussian_nb_multiplets(0),
    best_gaussian_nb_mp_score(0),
    gaussian_high_id(0),
    num_pulses(0),
    num_pulse_b_multiplets(0),
    best_pulse_b_mp_score(0),
    num_pulse_nb_multiplets(0),
    best_pulse_nb_mp_score(0),
    pulse_high_id(0),
    num_triplets(0),
    num_triplet_b_multiplets(0),
    best_triplet_b_mp_score(0),
    num_triplet_nb_multiplets(0),
    best_triplet_nb_mp_score(0),
    triplet_high_id(0),
    num_stars(0),
    best_star_score(0),
    meta_score(0),
    rfi_clean(0),
    state(0) {
    db_open();
}


meta_candidate::meta_candidate(const meta_candidate &a) :
    db_table<meta_candidate>(*this,-1),
    id(a.id),
    version(a.version),
    time_last_updated(a.time_last_updated),
    num_spikes(a.num_spikes),
    num_spike_b_multiplets(a.num_spike_b_multiplets),
    best_spike_b_mp_score(a.best_spike_b_mp_score),
    num_spike_nb_multiplets(a.num_spike_nb_multiplets),
    best_spike_nb_mp_score(a.best_spike_nb_mp_score),
    spike_high_id(a.spike_high_id),
    num_gaussians(a.num_gaussians),
    num_gaussian_b_multiplets(a.num_gaussian_b_multiplets),
    best_gaussian_b_mp_score(a.best_gaussian_b_mp_score),
    num_gaussian_nb_multiplets(a.num_gaussian_nb_multiplets),
    best_gaussian_nb_mp_score(a.best_gaussian_nb_mp_score),
    gaussian_high_id(a.gaussian_high_id),
    num_pulses(a.num_pulses),
    num_pulse_b_multiplets(a.num_pulse_b_multiplets),
    best_pulse_b_mp_score(a.best_pulse_b_mp_score),
    num_pulse_nb_multiplets(a.num_pulse_nb_multiplets),
    best_pulse_nb_mp_score(a.best_pulse_nb_mp_score),
    pulse_high_id(a.pulse_high_id),
    num_triplets(a.num_triplets),
    num_triplet_b_multiplets(a.num_triplet_b_multiplets),
    best_triplet_b_mp_score(a.best_triplet_b_mp_score),
    num_triplet_nb_multiplets(a.num_triplet_nb_multiplets),
    best_triplet_nb_mp_score(a.best_triplet_nb_mp_score),
    triplet_high_id(a.triplet_high_id),
    num_stars(a.num_stars),
    best_star_score(a.best_star_score),
    meta_score(a.meta_score),
    rfi_clean(a.rfi_clean),
    state(a.state) {
    db_open();
}


meta_candidate::meta_candidate(const SQL_ROW &a) :
    db_table<meta_candidate>(*this,-1) {
    db_open();
    parse(a);
}


meta_candidate::meta_candidate(const std::string &s,const char *tag) :
    db_table<meta_candidate>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


meta_candidate &meta_candidate::operator =(const meta_candidate &a) {
    if (&a != this) {
        id=a.id;
        version=a.version;
        time_last_updated=a.time_last_updated;
        num_spikes=a.num_spikes;
        num_spike_b_multiplets=a.num_spike_b_multiplets;
        best_spike_b_mp_score=a.best_spike_b_mp_score;
        num_spike_nb_multiplets=a.num_spike_nb_multiplets;
        best_spike_nb_mp_score=a.best_spike_nb_mp_score;
        spike_high_id=a.spike_high_id;
        num_gaussians=a.num_gaussians;
        num_gaussian_b_multiplets=a.num_gaussian_b_multiplets;
        best_gaussian_b_mp_score=a.best_gaussian_b_mp_score;
        num_gaussian_nb_multiplets=a.num_gaussian_nb_multiplets;
        best_gaussian_nb_mp_score=a.best_gaussian_nb_mp_score;
        gaussian_high_id=a.gaussian_high_id;
        num_pulses=a.num_pulses;
        num_pulse_b_multiplets=a.num_pulse_b_multiplets;
        best_pulse_b_mp_score=a.best_pulse_b_mp_score;
        num_pulse_nb_multiplets=a.num_pulse_nb_multiplets;
        best_pulse_nb_mp_score=a.best_pulse_nb_mp_score;
        pulse_high_id=a.pulse_high_id;
        num_triplets=a.num_triplets;
        num_triplet_b_multiplets=a.num_triplet_b_multiplets;
        best_triplet_b_mp_score=a.best_triplet_b_mp_score;
        num_triplet_nb_multiplets=a.num_triplet_nb_multiplets;
        best_triplet_nb_mp_score=a.best_triplet_nb_mp_score;
        triplet_high_id=a.triplet_high_id;
        num_stars=a.num_stars;
        best_star_score=a.best_star_score;
        meta_score=a.meta_score;
        rfi_clean=a.rfi_clean;
        state=a.state;
    }
    return (*this);
}


std::string meta_candidate::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<32; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string meta_candidate::insert_format() const {
    return std::string("?,")+update_format();
}

std::string meta_candidate::select_format() const {
    std::string rv("");
    for (int i=0; i<31; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string meta_candidate::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << version;
    rv << ',';
    rv << time_last_updated;
    rv << ',';
    rv << num_spikes;
    rv << ',';
    rv << num_spike_b_multiplets;
    rv << ',';
    rv << best_spike_b_mp_score;
    rv << ',';
    rv << num_spike_nb_multiplets;
    rv << ',';
    rv << best_spike_nb_mp_score;
    rv << ',';
    rv << spike_high_id;
    rv << ',';
    rv << num_gaussians;
    rv << ',';
    rv << num_gaussian_b_multiplets;
    rv << ',';
    rv << best_gaussian_b_mp_score;
    rv << ',';
    rv << num_gaussian_nb_multiplets;
    rv << ',';
    rv << best_gaussian_nb_mp_score;
    rv << ',';
    rv << gaussian_high_id;
    rv << ',';
    rv << num_pulses;
    rv << ',';
    rv << num_pulse_b_multiplets;
    rv << ',';
    rv << best_pulse_b_mp_score;
    rv << ',';
    rv << num_pulse_nb_multiplets;
    rv << ',';
    rv << best_pulse_nb_mp_score;
    rv << ',';
    rv << pulse_high_id;
    rv << ',';
    rv << num_triplets;
    rv << ',';
    rv << num_triplet_b_multiplets;
    rv << ',';
    rv << best_triplet_b_mp_score;
    rv << ',';
    rv << num_triplet_nb_multiplets;
    rv << ',';
    rv << best_triplet_nb_mp_score;
    rv << ',';
    rv << triplet_high_id;
    rv << ',';
    rv << num_stars;
    rv << ',';
    rv << best_star_score;
    rv << ',';
    rv << meta_score;
    rv << ',';
    rv << rfi_clean;
    rv << ',';
    rv << state;
    return rv.str();
}


std::string meta_candidate::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<version>" << version << "</version>\n";
    rv << xml_indent() << "<time_last_updated>" << time_last_updated << "</time_last_updated>\n";
    rv << xml_indent() << "<num_spikes>" << num_spikes << "</num_spikes>\n";
    rv << xml_indent() << "<num_spike_b_multiplets>" << num_spike_b_multiplets << "</num_spike_b_multiplets>\n";
    rv << xml_indent() << "<best_spike_b_mp_score>" << best_spike_b_mp_score << "</best_spike_b_mp_score>\n";
    rv << xml_indent() << "<num_spike_nb_multiplets>" << num_spike_nb_multiplets << "</num_spike_nb_multiplets>\n";
    rv << xml_indent() << "<best_spike_nb_mp_score>" << best_spike_nb_mp_score << "</best_spike_nb_mp_score>\n";
    rv << xml_indent() << "<spike_high_id>" << spike_high_id << "</spike_high_id>\n";
    rv << xml_indent() << "<num_gaussians>" << num_gaussians << "</num_gaussians>\n";
    rv << xml_indent() << "<num_gaussian_b_multiplets>" << num_gaussian_b_multiplets << "</num_gaussian_b_multiplets>\n";
    rv << xml_indent() << "<best_gaussian_b_mp_score>" << best_gaussian_b_mp_score << "</best_gaussian_b_mp_score>\n";
    rv << xml_indent() << "<num_gaussian_nb_multiplets>" << num_gaussian_nb_multiplets << "</num_gaussian_nb_multiplets>\n";
    rv << xml_indent() << "<best_gaussian_nb_mp_score>" << best_gaussian_nb_mp_score << "</best_gaussian_nb_mp_score>\n";
    rv << xml_indent() << "<gaussian_high_id>" << gaussian_high_id << "</gaussian_high_id>\n";
    rv << xml_indent() << "<num_pulses>" << num_pulses << "</num_pulses>\n";
    rv << xml_indent() << "<num_pulse_b_multiplets>" << num_pulse_b_multiplets << "</num_pulse_b_multiplets>\n";
    rv << xml_indent() << "<best_pulse_b_mp_score>" << best_pulse_b_mp_score << "</best_pulse_b_mp_score>\n";
    rv << xml_indent() << "<num_pulse_nb_multiplets>" << num_pulse_nb_multiplets << "</num_pulse_nb_multiplets>\n";
    rv << xml_indent() << "<best_pulse_nb_mp_score>" << best_pulse_nb_mp_score << "</best_pulse_nb_mp_score>\n";
    rv << xml_indent() << "<pulse_high_id>" << pulse_high_id << "</pulse_high_id>\n";
    rv << xml_indent() << "<num_triplets>" << num_triplets << "</num_triplets>\n";
    rv << xml_indent() << "<num_triplet_b_multiplets>" << num_triplet_b_multiplets << "</num_triplet_b_multiplets>\n";
    rv << xml_indent() << "<best_triplet_b_mp_score>" << best_triplet_b_mp_score << "</best_triplet_b_mp_score>\n";
    rv << xml_indent() << "<num_triplet_nb_multiplets>" << num_triplet_nb_multiplets << "</num_triplet_nb_multiplets>\n";
    rv << xml_indent() << "<best_triplet_nb_mp_score>" << best_triplet_nb_mp_score << "</best_triplet_nb_mp_score>\n";
    rv << xml_indent() << "<triplet_high_id>" << triplet_high_id << "</triplet_high_id>\n";
    rv << xml_indent() << "<num_stars>" << num_stars << "</num_stars>\n";
    rv << xml_indent() << "<best_star_score>" << best_star_score << "</best_star_score>\n";
    rv << xml_indent() << "<meta_score>" << meta_score << "</meta_score>\n";
    rv << xml_indent() << "<rfi_clean>" << rfi_clean << "</rfi_clean>\n";
    rv << xml_indent() << "<state>" << state << "</state>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void meta_candidate::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> version;
        }
        if (extract_xml_record(field,"time_last_updated",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time_last_updated;
        }
        if (extract_xml_record(field,"num_spikes",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_spikes;
        }
        if (extract_xml_record(field,"num_spike_b_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_spike_b_multiplets;
        }
        if (extract_xml_record(field,"best_spike_b_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_spike_b_mp_score;
        }
        if (extract_xml_record(field,"num_spike_nb_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_spike_nb_multiplets;
        }
        if (extract_xml_record(field,"best_spike_nb_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_spike_nb_mp_score;
        }
        if (extract_xml_record(field,"spike_high_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_high_id;
        }
        if (extract_xml_record(field,"num_gaussians",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_gaussians;
        }
        if (extract_xml_record(field,"num_gaussian_b_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_gaussian_b_multiplets;
        }
        if (extract_xml_record(field,"best_gaussian_b_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_gaussian_b_mp_score;
        }
        if (extract_xml_record(field,"num_gaussian_nb_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_gaussian_nb_multiplets;
        }
        if (extract_xml_record(field,"best_gaussian_nb_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_gaussian_nb_mp_score;
        }
        if (extract_xml_record(field,"gaussian_high_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_high_id;
        }
        if (extract_xml_record(field,"num_pulses",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_pulses;
        }
        if (extract_xml_record(field,"num_pulse_b_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_pulse_b_multiplets;
        }
        if (extract_xml_record(field,"best_pulse_b_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_pulse_b_mp_score;
        }
        if (extract_xml_record(field,"num_pulse_nb_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_pulse_nb_multiplets;
        }
        if (extract_xml_record(field,"best_pulse_nb_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_pulse_nb_mp_score;
        }
        if (extract_xml_record(field,"pulse_high_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_high_id;
        }
        if (extract_xml_record(field,"num_triplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_triplets;
        }
        if (extract_xml_record(field,"num_triplet_b_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_triplet_b_multiplets;
        }
        if (extract_xml_record(field,"best_triplet_b_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_triplet_b_mp_score;
        }
        if (extract_xml_record(field,"num_triplet_nb_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_triplet_nb_multiplets;
        }
        if (extract_xml_record(field,"best_triplet_nb_mp_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_triplet_nb_mp_score;
        }
        if (extract_xml_record(field,"triplet_high_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_high_id;
        }
        if (extract_xml_record(field,"num_stars",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_stars;
        }
        if (extract_xml_record(field,"best_star_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> best_star_score;
        }
        if (extract_xml_record(field,"meta_score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> meta_score;
        }
        if (extract_xml_record(field,"rfi_clean",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_clean;
        }
        if (extract_xml_record(field,"state",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> state;
        }
    }
}

void meta_candidate::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> version;
    }
    {
        std::istringstream row(*(s[2]));
        row >> time_last_updated;
    }
    {
        std::istringstream row(*(s[3]));
        row >> num_spikes;
    }
    {
        std::istringstream row(*(s[4]));
        row >> num_spike_b_multiplets;
    }
    {
        std::istringstream row(*(s[5]));
        row >> best_spike_b_mp_score;
    }
    {
        std::istringstream row(*(s[6]));
        row >> num_spike_nb_multiplets;
    }
    {
        std::istringstream row(*(s[7]));
        row >> best_spike_nb_mp_score;
    }
    {
        std::istringstream row(*(s[8]));
        row >> spike_high_id;
    }
    {
        std::istringstream row(*(s[9]));
        row >> num_gaussians;
    }
    {
        std::istringstream row(*(s[10]));
        row >> num_gaussian_b_multiplets;
    }
    {
        std::istringstream row(*(s[11]));
        row >> best_gaussian_b_mp_score;
    }
    {
        std::istringstream row(*(s[12]));
        row >> num_gaussian_nb_multiplets;
    }
    {
        std::istringstream row(*(s[13]));
        row >> best_gaussian_nb_mp_score;
    }
    {
        std::istringstream row(*(s[14]));
        row >> gaussian_high_id;
    }
    {
        std::istringstream row(*(s[15]));
        row >> num_pulses;
    }
    {
        std::istringstream row(*(s[16]));
        row >> num_pulse_b_multiplets;
    }
    {
        std::istringstream row(*(s[17]));
        row >> best_pulse_b_mp_score;
    }
    {
        std::istringstream row(*(s[18]));
        row >> num_pulse_nb_multiplets;
    }
    {
        std::istringstream row(*(s[19]));
        row >> best_pulse_nb_mp_score;
    }
    {
        std::istringstream row(*(s[20]));
        row >> pulse_high_id;
    }
    {
        std::istringstream row(*(s[21]));
        row >> num_triplets;
    }
    {
        std::istringstream row(*(s[22]));
        row >> num_triplet_b_multiplets;
    }
    {
        std::istringstream row(*(s[23]));
        row >> best_triplet_b_mp_score;
    }
    {
        std::istringstream row(*(s[24]));
        row >> num_triplet_nb_multiplets;
    }
    {
        std::istringstream row(*(s[25]));
        row >> best_triplet_nb_mp_score;
    }
    {
        std::istringstream row(*(s[26]));
        row >> triplet_high_id;
    }
    {
        std::istringstream row(*(s[27]));
        row >> num_stars;
    }
    {
        std::istringstream row(*(s[28]));
        row >> best_star_score;
    }
    {
        std::istringstream row(*(s[29]));
        row >> meta_score;
    }
    {
        std::istringstream row(*(s[30]));
        row >> rfi_clean;
    }
    {
        std::istringstream row(*(s[31]));
        row >> state;
    }
}

void meta_candidate::parse(const std::string &s) {
    SQL_ROW row(&s,32);
    parse(row);
}

template <> const char *const db_table<multiplet>::table_name="multiplet";
template <> const char *db_table<multiplet>::_search_tag=table_name;
template <> const int db_table<multiplet>::_nfields=25;
template <> const char *const db_table<multiplet>::column_names[25]= {"id","version","signal_type","mp_type","qpix","freq_win","mean_ra","mean_decl","ra_stddev","decl_stddev","mean_angular_distance","angular_distance_stddev","mean_frequency","frequency_stddev","mean_chirp","chirp_stddev","mean_period","period_stddev","mean_snr","snr_stddev","mean_threshold","threshold_stddev","score","num_detections","signal_ids"};

multiplet::multiplet() :
    db_table<multiplet>(*this,-1),
    id(0),
    version(0),
    signal_type(0),
    mp_type(0),
    qpix(0),
    freq_win(0),
    mean_ra(0),
    mean_decl(0),
    ra_stddev(0),
    decl_stddev(0),
    mean_angular_distance(0),
    angular_distance_stddev(0),
    mean_frequency(0),
    frequency_stddev(0),
    mean_chirp(0),
    chirp_stddev(0),
    mean_period(0),
    period_stddev(0),
    mean_snr(0),
    snr_stddev(0),
    mean_threshold(0),
    threshold_stddev(0),
    score(0),
    num_detections(0),
    signal_ids((sqlint8_t *)0,0,_x_csv) {
    db_open();
}


multiplet::multiplet(const multiplet &a) :
    db_table<multiplet>(*this,-1),
    id(a.id),
    version(a.version),
    signal_type(a.signal_type),
    mp_type(a.mp_type),
    qpix(a.qpix),
    freq_win(a.freq_win),
    mean_ra(a.mean_ra),
    mean_decl(a.mean_decl),
    ra_stddev(a.ra_stddev),
    decl_stddev(a.decl_stddev),
    mean_angular_distance(a.mean_angular_distance),
    angular_distance_stddev(a.angular_distance_stddev),
    mean_frequency(a.mean_frequency),
    frequency_stddev(a.frequency_stddev),
    mean_chirp(a.mean_chirp),
    chirp_stddev(a.chirp_stddev),
    mean_period(a.mean_period),
    period_stddev(a.period_stddev),
    mean_snr(a.mean_snr),
    snr_stddev(a.snr_stddev),
    mean_threshold(a.mean_threshold),
    threshold_stddev(a.threshold_stddev),
    score(a.score),
    num_detections(a.num_detections),
    signal_ids(a.signal_ids) {
    db_open();
}


multiplet::multiplet(const SQL_ROW &a) :
    db_table<multiplet>(*this,-1) {
    db_open();
    parse(a);
}


multiplet::multiplet(const std::string &s,const char *tag) :
    db_table<multiplet>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


multiplet &multiplet::operator =(const multiplet &a) {
    if (&a != this) {
        id=a.id;
        version=a.version;
        signal_type=a.signal_type;
        mp_type=a.mp_type;
        qpix=a.qpix;
        freq_win=a.freq_win;
        mean_ra=a.mean_ra;
        mean_decl=a.mean_decl;
        ra_stddev=a.ra_stddev;
        decl_stddev=a.decl_stddev;
        mean_angular_distance=a.mean_angular_distance;
        angular_distance_stddev=a.angular_distance_stddev;
        mean_frequency=a.mean_frequency;
        frequency_stddev=a.frequency_stddev;
        mean_chirp=a.mean_chirp;
        chirp_stddev=a.chirp_stddev;
        mean_period=a.mean_period;
        period_stddev=a.period_stddev;
        mean_snr=a.mean_snr;
        snr_stddev=a.snr_stddev;
        mean_threshold=a.mean_threshold;
        threshold_stddev=a.threshold_stddev;
        score=a.score;
        num_detections=a.num_detections;
        {
            signal_ids.clear();
            std::vector<sqlint8_t>::const_iterator i(a.signal_ids.begin());
            for (; i!=a.signal_ids.end(); i++) {
                signal_ids.push_back(*i);
            }
        }
    }
    return (*this);
}


std::string multiplet::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<25; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string multiplet::insert_format() const {
    return std::string("?,")+update_format();
}

std::string multiplet::select_format() const {
    std::string rv("");
    for (int i=0; i<24; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string multiplet::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << version;
    rv << ',';
    rv << signal_type;
    rv << ',';
    rv << mp_type;
    rv << ',';
    rv << qpix;
    rv << ',';
    rv << freq_win;
    rv << ',';
    rv << mean_ra;
    rv << ',';
    rv << mean_decl;
    rv << ',';
    rv << ra_stddev;
    rv << ',';
    rv << decl_stddev;
    rv << ',';
    rv << mean_angular_distance;
    rv << ',';
    rv << angular_distance_stddev;
    rv << ',';
    rv << mean_frequency;
    rv << ',';
    rv << frequency_stddev;
    rv << ',';
    rv << mean_chirp;
    rv << ',';
    rv << chirp_stddev;
    rv << ',';
    rv << mean_period;
    rv << ',';
    rv << period_stddev;
    rv << ',';
    rv << mean_snr;
    rv << ',';
    rv << snr_stddev;
    rv << ',';
    rv << mean_threshold;
    rv << ',';
    rv << threshold_stddev;
    rv << ',';
    rv << score;
    rv << ',';
    rv << num_detections;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<sqlint8_t>::const_iterator p=signal_ids.begin();
        for (; p<signal_ids.end(); p++) {
            rv << *p;
            if (p != signal_ids.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    return rv.str();
}


std::string multiplet::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<version>" << version << "</version>\n";
    rv << xml_indent() << "<signal_type>" << signal_type << "</signal_type>\n";
    rv << xml_indent() << "<mp_type>" << mp_type << "</mp_type>\n";
    rv << xml_indent() << "<qpix>" << qpix << "</qpix>\n";
    rv << xml_indent() << "<freq_win>" << freq_win << "</freq_win>\n";
    rv << xml_indent() << "<mean_ra>" << mean_ra << "</mean_ra>\n";
    rv << xml_indent() << "<mean_decl>" << mean_decl << "</mean_decl>\n";
    rv << xml_indent() << "<ra_stddev>" << ra_stddev << "</ra_stddev>\n";
    rv << xml_indent() << "<decl_stddev>" << decl_stddev << "</decl_stddev>\n";
    rv << xml_indent() << "<mean_angular_distance>" << mean_angular_distance << "</mean_angular_distance>\n";
    rv << xml_indent() << "<angular_distance_stddev>" << angular_distance_stddev << "</angular_distance_stddev>\n";
    rv << xml_indent() << "<mean_frequency>" << mean_frequency << "</mean_frequency>\n";
    rv << xml_indent() << "<frequency_stddev>" << frequency_stddev << "</frequency_stddev>\n";
    rv << xml_indent() << "<mean_chirp>" << mean_chirp << "</mean_chirp>\n";
    rv << xml_indent() << "<chirp_stddev>" << chirp_stddev << "</chirp_stddev>\n";
    rv << xml_indent() << "<mean_period>" << mean_period << "</mean_period>\n";
    rv << xml_indent() << "<period_stddev>" << period_stddev << "</period_stddev>\n";
    rv << xml_indent() << "<mean_snr>" << mean_snr << "</mean_snr>\n";
    rv << xml_indent() << "<snr_stddev>" << snr_stddev << "</snr_stddev>\n";
    rv << xml_indent() << "<mean_threshold>" << mean_threshold << "</mean_threshold>\n";
    rv << xml_indent() << "<threshold_stddev>" << threshold_stddev << "</threshold_stddev>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<num_detections>" << num_detections << "</num_detections>\n";
    if (signal_ids.size()) {
        rv << xml_indent() << "<signal_ids";
        {
            std::string enc_string=signal_ids.print_xml();
            rv << " length=" << enc_string.size() << " encoding=\"" << xml_encoding_names[signal_ids.encoding] << "\">" ;
            rv << enc_string;
        }
    }
    rv << "</signal_ids>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void multiplet::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> version;
        }
        if (extract_xml_record(field,"signal_type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> signal_type;
        }
        if (extract_xml_record(field,"mp_type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mp_type;
        }
        if (extract_xml_record(field,"qpix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> qpix;
        }
        if (extract_xml_record(field,"freq_win",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq_win;
        }
        if (extract_xml_record(field,"mean_ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_ra;
        }
        if (extract_xml_record(field,"mean_decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_decl;
        }
        if (extract_xml_record(field,"ra_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra_stddev;
        }
        if (extract_xml_record(field,"decl_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl_stddev;
        }
        if (extract_xml_record(field,"mean_angular_distance",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_angular_distance;
        }
        if (extract_xml_record(field,"angular_distance_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> angular_distance_stddev;
        }
        if (extract_xml_record(field,"mean_frequency",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_frequency;
        }
        if (extract_xml_record(field,"frequency_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> frequency_stddev;
        }
        if (extract_xml_record(field,"mean_chirp",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_chirp;
        }
        if (extract_xml_record(field,"chirp_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_stddev;
        }
        if (extract_xml_record(field,"mean_period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_period;
        }
        if (extract_xml_record(field,"period_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period_stddev;
        }
        if (extract_xml_record(field,"mean_snr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_snr;
        }
        if (extract_xml_record(field,"snr_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> snr_stddev;
        }
        if (extract_xml_record(field,"mean_threshold",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_threshold;
        }
        if (extract_xml_record(field,"threshold_stddev",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> threshold_stddev;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"num_detections",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> num_detections;
        }
        signal_ids.clear();
        if (extract_xml_record(field,"signal_ids",sub)) {
            pos=sub.find(">");
            do {
                if (pos!=std::string::npos) {
                    do {
                        pos++;
                    } while ((sub[pos]=='\n') || (sub[pos]==','));
                    std::istringstream in(std::string(sub.c_str()+pos));
                    sqlint8_t tmp;
                    in >> tmp;
                    signal_ids.push_back(tmp);
                }
            } while ((pos=sub.find(",",pos)) != std::string::npos);
        }
    }
}

void multiplet::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> version;
    }
    {
        std::istringstream row(*(s[2]));
        row >> signal_type;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mp_type;
    }
    {
        std::istringstream row(*(s[4]));
        row >> qpix;
    }
    {
        std::istringstream row(*(s[5]));
        row >> freq_win;
    }
    {
        std::istringstream row(*(s[6]));
        row >> mean_ra;
    }
    {
        std::istringstream row(*(s[7]));
        row >> mean_decl;
    }
    {
        std::istringstream row(*(s[8]));
        row >> ra_stddev;
    }
    {
        std::istringstream row(*(s[9]));
        row >> decl_stddev;
    }
    {
        std::istringstream row(*(s[10]));
        row >> mean_angular_distance;
    }
    {
        std::istringstream row(*(s[11]));
        row >> angular_distance_stddev;
    }
    {
        std::istringstream row(*(s[12]));
        row >> mean_frequency;
    }
    {
        std::istringstream row(*(s[13]));
        row >> frequency_stddev;
    }
    {
        std::istringstream row(*(s[14]));
        row >> mean_chirp;
    }
    {
        std::istringstream row(*(s[15]));
        row >> chirp_stddev;
    }
    {
        std::istringstream row(*(s[16]));
        row >> mean_period;
    }
    {
        std::istringstream row(*(s[17]));
        row >> period_stddev;
    }
    {
        std::istringstream row(*(s[18]));
        row >> mean_snr;
    }
    {
        std::istringstream row(*(s[19]));
        row >> snr_stddev;
    }
    {
        std::istringstream row(*(s[20]));
        row >> mean_threshold;
    }
    {
        std::istringstream row(*(s[21]));
        row >> threshold_stddev;
    }
    {
        std::istringstream row(*(s[22]));
        row >> score;
    }
    {
        std::istringstream row(*(s[23]));
        row >> num_detections;
    }
    {
        std::string::size_type p,q;
        int i;
        signal_ids.clear();
        SQL_ROW tmp(s[24]);
        for (i=0; i<tmp.argc(); i++) {
            std::istringstream in(*(tmp[i]));
            sqlint8_t tmp0;
            in >> tmp0;
            signal_ids.push_back(tmp0);
        }
    }
}

void multiplet::parse(const std::string &s) {
    SQL_ROW row(&s,25);
    parse(row);
}

template <> const char *const db_table<star>::table_name="star";
template <> const char *db_table<star>::_search_tag=table_name;
template <> const int db_table<star>::_nfields=14;
template <> const char *const db_table<star>::column_names[14]= {"id","object_type","catalog_name","catalog_number","object_name","ra","decl","qpix","v_mag","b_minus_v","parallax","stellar_type","planets","score"};

star::star() :
    db_table<star>(*this,-1),
    id(0),
    catalog_number(0),
    ra(0),
    decl(0),
    qpix(0),
    v_mag(0),
    b_minus_v(0),
    parallax(0),
    planets(0),
    score(0) {
    db_open();
    object_type[0]=0;
    catalog_name[0]=0;
    object_name[0]=0;
    stellar_type[0]=0;
}


star::star(const star &a) :
    db_table<star>(*this,-1),
    id(a.id),
    catalog_number(a.catalog_number),
    ra(a.ra),
    decl(a.decl),
    qpix(a.qpix),
    v_mag(a.v_mag),
    b_minus_v(a.b_minus_v),
    parallax(a.parallax),
    planets(a.planets),
    score(a.score) {
    db_open();
    strcpy(object_type,a.object_type);
    strcpy(catalog_name,a.catalog_name);
    strcpy(object_name,a.object_name);
    strcpy(stellar_type,a.stellar_type);
}


star::star(const SQL_ROW &a) :
    db_table<star>(*this,-1) {
    db_open();
    parse(a);
}


star::star(const std::string &s,const char *tag) :
    db_table<star>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


star &star::operator =(const star &a) {
    if (&a != this) {
        id=a.id;
        catalog_number=a.catalog_number;
        ra=a.ra;
        decl=a.decl;
        qpix=a.qpix;
        v_mag=a.v_mag;
        b_minus_v=a.b_minus_v;
        parallax=a.parallax;
        planets=a.planets;
        score=a.score;
        strcpy(object_type,a.object_type);
        strcpy(catalog_name,a.catalog_name);
        strcpy(object_name,a.object_name);
        strcpy(stellar_type,a.stellar_type);
    }
    return (*this);
}


std::string star::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<14; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string star::insert_format() const {
    return std::string("?,")+update_format();
}

std::string star::select_format() const {
    std::string rv("");
    for (int i=0; i<13; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string star::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << "'" << object_type << "'";
    rv << ',';
    rv << "'" << catalog_name << "'";
    rv << ',';
    rv << catalog_number;
    rv << ',';
    rv << "'" << object_name << "'";
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << qpix;
    rv << ',';
    rv << v_mag;
    rv << ',';
    rv << b_minus_v;
    rv << ',';
    rv << parallax;
    rv << ',';
    rv << "'" << stellar_type << "'";
    rv << ',';
    rv << planets;
    rv << ',';
    rv << score;
    return rv.str();
}


std::string star::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    {
        std::string enc_field=xml_encode_string(object_type,std::min(strlen(object_type),sizeof(object_type)));
        rv << xml_indent() << "<object_type>";
        rv << enc_field << "</object_type>\n";
    }
    {
        std::string enc_field=xml_encode_string(catalog_name,std::min(strlen(catalog_name),sizeof(catalog_name)));
        rv << xml_indent() << "<catalog_name>";
        rv << enc_field << "</catalog_name>\n";
    }
    rv << xml_indent() << "<catalog_number>" << catalog_number << "</catalog_number>\n";
    {
        std::string enc_field=xml_encode_string(object_name,std::min(strlen(object_name),sizeof(object_name)));
        rv << xml_indent() << "<object_name>";
        rv << enc_field << "</object_name>\n";
    }
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<qpix>" << qpix << "</qpix>\n";
    rv << xml_indent() << "<v_mag>" << v_mag << "</v_mag>\n";
    rv << xml_indent() << "<b_minus_v>" << b_minus_v << "</b_minus_v>\n";
    rv << xml_indent() << "<parallax>" << parallax << "</parallax>\n";
    {
        std::string enc_field=xml_encode_string(stellar_type,std::min(strlen(stellar_type),sizeof(stellar_type)));
        rv << xml_indent() << "<stellar_type>";
        rv << enc_field << "</stellar_type>\n";
    }
    rv << xml_indent() << "<planets>" << planets << "</planets>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void star::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"object_type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(object_type,(const char *)&(in.front()),std::min(in.size(),(size_t)16));
            object_type[std::min(in.size(),(size_t)15)]=0;
        }
        if (extract_xml_record(field,"catalog_name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(catalog_name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            catalog_name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"catalog_number",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> catalog_number;
        }
        if (extract_xml_record(field,"object_name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(object_name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            object_name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"qpix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> qpix;
        }
        if (extract_xml_record(field,"v_mag",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> v_mag;
        }
        if (extract_xml_record(field,"b_minus_v",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> b_minus_v;
        }
        if (extract_xml_record(field,"parallax",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> parallax;
        }
        if (extract_xml_record(field,"stellar_type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(stellar_type,(const char *)&(in.front()),std::min(in.size(),(size_t)32));
            stellar_type[std::min(in.size(),(size_t)31)]=0;
        }
        if (extract_xml_record(field,"planets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> planets;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
    }
}

void star::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(object_type,s[1]->c_str(),16);
        object_type[15]=0;
    }
    {
        strncpy(catalog_name,s[2]->c_str(),64);
        catalog_name[63]=0;
    }
    {
        std::istringstream row(*(s[3]));
        row >> catalog_number;
    }
    {
        strncpy(object_name,s[4]->c_str(),64);
        object_name[63]=0;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> qpix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> v_mag;
    }
    {
        std::istringstream row(*(s[9]));
        row >> b_minus_v;
    }
    {
        std::istringstream row(*(s[10]));
        row >> parallax;
    }
    {
        strncpy(stellar_type,s[11]->c_str(),32);
        stellar_type[31]=0;
    }
    {
        std::istringstream row(*(s[12]));
        row >> planets;
    }
    {
        std::istringstream row(*(s[13]));
        row >> score;
    }
}

void star::parse(const std::string &s) {
    SQL_ROW row(&s,14);
    parse(row);
}

template <> const char *const db_table<candidate_count>::table_name="candidate_count";
template <> const char *db_table<candidate_count>::_search_tag=table_name;
template <> const int db_table<candidate_count>::_nfields=15;
template <> const char *const db_table<candidate_count>::column_names[15]= {"id","spikes","gaussians","pulses","triplets","spike_barycentric_multiplets","gaussian_barycentric_multiplets","pulse_barycentric_multiplets","triplet_barycentric_multiplets","spike_nonbarycentric_multiplets","gaussian_nonbarycentric_multiplets","pulse_nonbarycentric_multiplets","triplet_nonbarycentric_multiplets","stars","time_last_updated"};

candidate_count::candidate_count() :
    db_table<candidate_count>(*this,-1),
    id(0),
    spikes(0),
    gaussians(0),
    pulses(0),
    triplets(0),
    spike_barycentric_multiplets(0),
    gaussian_barycentric_multiplets(0),
    pulse_barycentric_multiplets(0),
    triplet_barycentric_multiplets(0),
    spike_nonbarycentric_multiplets(0),
    gaussian_nonbarycentric_multiplets(0),
    pulse_nonbarycentric_multiplets(0),
    triplet_nonbarycentric_multiplets(0),
    stars(0),
    time_last_updated(0) {
    db_open();
}


candidate_count::candidate_count(const candidate_count &a) :
    db_table<candidate_count>(*this,-1),
    id(a.id),
    spikes(a.spikes),
    gaussians(a.gaussians),
    pulses(a.pulses),
    triplets(a.triplets),
    spike_barycentric_multiplets(a.spike_barycentric_multiplets),
    gaussian_barycentric_multiplets(a.gaussian_barycentric_multiplets),
    pulse_barycentric_multiplets(a.pulse_barycentric_multiplets),
    triplet_barycentric_multiplets(a.triplet_barycentric_multiplets),
    spike_nonbarycentric_multiplets(a.spike_nonbarycentric_multiplets),
    gaussian_nonbarycentric_multiplets(a.gaussian_nonbarycentric_multiplets),
    pulse_nonbarycentric_multiplets(a.pulse_nonbarycentric_multiplets),
    triplet_nonbarycentric_multiplets(a.triplet_nonbarycentric_multiplets),
    stars(a.stars),
    time_last_updated(a.time_last_updated) {
    db_open();
}


candidate_count::candidate_count(const SQL_ROW &a) :
    db_table<candidate_count>(*this,-1) {
    db_open();
    parse(a);
}


candidate_count::candidate_count(const std::string &s,const char *tag) :
    db_table<candidate_count>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


candidate_count &candidate_count::operator =(const candidate_count &a) {
    if (&a != this) {
        id=a.id;
        spikes=a.spikes;
        gaussians=a.gaussians;
        pulses=a.pulses;
        triplets=a.triplets;
        spike_barycentric_multiplets=a.spike_barycentric_multiplets;
        gaussian_barycentric_multiplets=a.gaussian_barycentric_multiplets;
        pulse_barycentric_multiplets=a.pulse_barycentric_multiplets;
        triplet_barycentric_multiplets=a.triplet_barycentric_multiplets;
        spike_nonbarycentric_multiplets=a.spike_nonbarycentric_multiplets;
        gaussian_nonbarycentric_multiplets=a.gaussian_nonbarycentric_multiplets;
        pulse_nonbarycentric_multiplets=a.pulse_nonbarycentric_multiplets;
        triplet_nonbarycentric_multiplets=a.triplet_nonbarycentric_multiplets;
        stars=a.stars;
        time_last_updated=a.time_last_updated;
    }
    return (*this);
}


std::string candidate_count::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<15; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string candidate_count::insert_format() const {
    return std::string("?,")+update_format();
}

std::string candidate_count::select_format() const {
    std::string rv("");
    for (int i=0; i<14; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string candidate_count::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << spikes;
    rv << ',';
    rv << gaussians;
    rv << ',';
    rv << pulses;
    rv << ',';
    rv << triplets;
    rv << ',';
    rv << spike_barycentric_multiplets;
    rv << ',';
    rv << gaussian_barycentric_multiplets;
    rv << ',';
    rv << pulse_barycentric_multiplets;
    rv << ',';
    rv << triplet_barycentric_multiplets;
    rv << ',';
    rv << spike_nonbarycentric_multiplets;
    rv << ',';
    rv << gaussian_nonbarycentric_multiplets;
    rv << ',';
    rv << pulse_nonbarycentric_multiplets;
    rv << ',';
    rv << triplet_nonbarycentric_multiplets;
    rv << ',';
    rv << stars;
    rv << ',';
    rv << time_last_updated;
    return rv.str();
}


std::string candidate_count::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<spikes>" << spikes << "</spikes>\n";
    rv << xml_indent() << "<gaussians>" << gaussians << "</gaussians>\n";
    rv << xml_indent() << "<pulses>" << pulses << "</pulses>\n";
    rv << xml_indent() << "<triplets>" << triplets << "</triplets>\n";
    rv << xml_indent() << "<spike_barycentric_multiplets>" << spike_barycentric_multiplets << "</spike_barycentric_multiplets>\n";
    rv << xml_indent() << "<gaussian_barycentric_multiplets>" << gaussian_barycentric_multiplets << "</gaussian_barycentric_multiplets>\n";
    rv << xml_indent() << "<pulse_barycentric_multiplets>" << pulse_barycentric_multiplets << "</pulse_barycentric_multiplets>\n";
    rv << xml_indent() << "<triplet_barycentric_multiplets>" << triplet_barycentric_multiplets << "</triplet_barycentric_multiplets>\n";
    rv << xml_indent() << "<spike_nonbarycentric_multiplets>" << spike_nonbarycentric_multiplets << "</spike_nonbarycentric_multiplets>\n";
    rv << xml_indent() << "<gaussian_nonbarycentric_multiplets>" << gaussian_nonbarycentric_multiplets << "</gaussian_nonbarycentric_multiplets>\n";
    rv << xml_indent() << "<pulse_nonbarycentric_multiplets>" << pulse_nonbarycentric_multiplets << "</pulse_nonbarycentric_multiplets>\n";
    rv << xml_indent() << "<triplet_nonbarycentric_multiplets>" << triplet_nonbarycentric_multiplets << "</triplet_nonbarycentric_multiplets>\n";
    rv << xml_indent() << "<stars>" << stars << "</stars>\n";
    rv << xml_indent() << "<time_last_updated>" << time_last_updated << "</time_last_updated>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void candidate_count::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"spikes",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spikes;
        }
        if (extract_xml_record(field,"gaussians",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussians;
        }
        if (extract_xml_record(field,"pulses",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulses;
        }
        if (extract_xml_record(field,"triplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplets;
        }
        if (extract_xml_record(field,"spike_barycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_barycentric_multiplets;
        }
        if (extract_xml_record(field,"gaussian_barycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_barycentric_multiplets;
        }
        if (extract_xml_record(field,"pulse_barycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_barycentric_multiplets;
        }
        if (extract_xml_record(field,"triplet_barycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_barycentric_multiplets;
        }
        if (extract_xml_record(field,"spike_nonbarycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_nonbarycentric_multiplets;
        }
        if (extract_xml_record(field,"gaussian_nonbarycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_nonbarycentric_multiplets;
        }
        if (extract_xml_record(field,"pulse_nonbarycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_nonbarycentric_multiplets;
        }
        if (extract_xml_record(field,"triplet_nonbarycentric_multiplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_nonbarycentric_multiplets;
        }
        if (extract_xml_record(field,"stars",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> stars;
        }
        if (extract_xml_record(field,"time_last_updated",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time_last_updated;
        }
    }
}

void candidate_count::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> spikes;
    }
    {
        std::istringstream row(*(s[2]));
        row >> gaussians;
    }
    {
        std::istringstream row(*(s[3]));
        row >> pulses;
    }
    {
        std::istringstream row(*(s[4]));
        row >> triplets;
    }
    {
        std::istringstream row(*(s[5]));
        row >> spike_barycentric_multiplets;
    }
    {
        std::istringstream row(*(s[6]));
        row >> gaussian_barycentric_multiplets;
    }
    {
        std::istringstream row(*(s[7]));
        row >> pulse_barycentric_multiplets;
    }
    {
        std::istringstream row(*(s[8]));
        row >> triplet_barycentric_multiplets;
    }
    {
        std::istringstream row(*(s[9]));
        row >> spike_nonbarycentric_multiplets;
    }
    {
        std::istringstream row(*(s[10]));
        row >> gaussian_nonbarycentric_multiplets;
    }
    {
        std::istringstream row(*(s[11]));
        row >> pulse_nonbarycentric_multiplets;
    }
    {
        std::istringstream row(*(s[12]));
        row >> triplet_nonbarycentric_multiplets;
    }
    {
        std::istringstream row(*(s[13]));
        row >> stars;
    }
    {
        std::istringstream row(*(s[14]));
        row >> time_last_updated;
    }
}

void candidate_count::parse(const std::string &s) {
    SQL_ROW row(&s,15);
    parse(row);
}

template <> const char *const db_table<tape>::table_name="tape";
template <> const char *db_table<tape>::_search_tag=table_name;
template <> const int db_table<tape>::_nfields=8;
template <> const char *const db_table<tape>::column_names[8]= {"id","name","start_time","last_block_time","last_block_done","missed","tape_quality","beam"};

tape::tape() :
    db_table<tape>(*this,-1),
    id(0),
    start_time(0),
    last_block_time(0),
    last_block_done(0),
    missed(0),
    tape_quality(0),
    beam(0) {
    db_open();
    name[0]=0;
}


tape::tape(const tape &a) :
    db_table<tape>(*this,-1),
    id(a.id),
    start_time(a.start_time),
    last_block_time(a.last_block_time),
    last_block_done(a.last_block_done),
    missed(a.missed),
    tape_quality(a.tape_quality),
    beam(a.beam) {
    db_open();
    strcpy(name,a.name);
}


tape::tape(const SQL_ROW &a) :
    db_table<tape>(*this,-1) {
    db_open();
    parse(a);
}


tape::tape(const std::string &s,const char *tag) :
    db_table<tape>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


tape &tape::operator =(const tape &a) {
    if (&a != this) {
        id=a.id;
        start_time=a.start_time;
        last_block_time=a.last_block_time;
        last_block_done=a.last_block_done;
        missed=a.missed;
        tape_quality=a.tape_quality;
        beam=a.beam;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string tape::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<8; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string tape::insert_format() const {
    return std::string("?,")+update_format();
}

std::string tape::select_format() const {
    std::string rv("");
    for (int i=0; i<7; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string tape::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << start_time;
    rv << ',';
    rv << last_block_time;
    rv << ',';
    rv << last_block_done;
    rv << ',';
    rv << missed;
    rv << ',';
    rv << tape_quality;
    rv << ',';
    rv << beam;
    return rv.str();
}


std::string tape::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<start_time>" << start_time << "</start_time>\n";
    rv << xml_indent() << "<last_block_time>" << last_block_time << "</last_block_time>\n";
    rv << xml_indent() << "<last_block_done>" << last_block_done << "</last_block_done>\n";
    rv << xml_indent() << "<missed>" << missed << "</missed>\n";
    rv << xml_indent() << "<tape_quality>" << tape_quality << "</tape_quality>\n";
    rv << xml_indent() << "<beam>" << beam << "</beam>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void tape::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)20));
            name[std::min(in.size(),(size_t)19)]=0;
        }
        if (extract_xml_record(field,"start_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> start_time;
        }
        if (extract_xml_record(field,"last_block_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> last_block_time;
        }
        if (extract_xml_record(field,"last_block_done",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> last_block_done;
        }
        if (extract_xml_record(field,"missed",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> missed;
        }
        if (extract_xml_record(field,"tape_quality",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> tape_quality;
        }
        if (extract_xml_record(field,"beam",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> beam;
        }
    }
}

void tape::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(name,s[1]->c_str(),20);
        name[19]=0;
    }
    {
        std::istringstream row(*(s[2]));
        row >> start_time;
    }
    {
        std::istringstream row(*(s[3]));
        row >> last_block_time;
    }
    {
        std::istringstream row(*(s[4]));
        row >> last_block_done;
    }
    {
        std::istringstream row(*(s[5]));
        row >> missed;
    }
    {
        std::istringstream row(*(s[6]));
        row >> tape_quality;
    }
    {
        std::istringstream row(*(s[7]));
        row >> beam;
    }
}

void tape::parse(const std::string &s) {
    SQL_ROW row(&s,8);
    parse(row);
}

template <> const char *const db_table<settings>::table_name="settings";
template <> const char *db_table<settings>::_search_tag=table_name;
template <> const int db_table<settings>::_nfields=6;
template <> const char *const db_table<settings>::column_names[6]= {"id","active","recorder_cfg","splitter_cfg","analysis_cfg","receiver_cfg"};

settings::settings() :
    db_table<settings>(*this,-1),
    id(0),
    active(0),
    recorder_cfg(),
    splitter_cfg(),
    analysis_cfg(),
    receiver_cfg() {
    db_open();
}


settings::settings(const settings &a) :
    db_table<settings>(*this,-1),
    id(a.id),
    active(a.active),
    recorder_cfg(a.recorder_cfg),
    splitter_cfg(a.splitter_cfg),
    analysis_cfg(a.analysis_cfg),
    receiver_cfg(a.receiver_cfg) {
    db_open();
}


settings::settings(const SQL_ROW &a) :
    db_table<settings>(*this,-1) {
    db_open();
    parse(a);
}


settings::settings(const std::string &s,const char *tag) :
    db_table<settings>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


settings &settings::operator =(const settings &a) {
    if (&a != this) {
        id=a.id;
        active=a.active;
        recorder_cfg=a.recorder_cfg;
        splitter_cfg=a.splitter_cfg;
        analysis_cfg=a.analysis_cfg;
        receiver_cfg=a.receiver_cfg;
    }
    return (*this);
}


std::string settings::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<6; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string settings::insert_format() const {
    return std::string("?,")+update_format();
}

std::string settings::select_format() const {
    std::string rv("");
    for (int i=0; i<5; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string settings::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << active;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << recorder_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << splitter_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << analysis_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << receiver_cfg.id;
        }
    }
    return rv.str();
}


std::string settings::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<active>" << active << "</active>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print_xml(full_subtables,show_ids,no_refs,"recorder_cfg");
        } else {
            rv << xml_indent() << "<recorder_cfg><id>" << recorder_cfg.id << "</id></recorder_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print_xml(full_subtables,show_ids,no_refs,"splitter_cfg");
        } else {
            rv << xml_indent() << "<splitter_cfg><id>" << splitter_cfg.id << "</id></splitter_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print_xml(full_subtables,show_ids,no_refs,"analysis_cfg");
        } else {
            rv << xml_indent() << "<analysis_cfg><id>" << analysis_cfg.id << "</id></analysis_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print_xml(full_subtables,show_ids,no_refs,"receiver_cfg");
        } else {
            rv << xml_indent() << "<receiver_cfg><id>" << receiver_cfg.id << "</id></receiver_cfg>\n";
        }
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void settings::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"active",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> active;
        }
        if (extract_xml_record(field,"recorder_cfg",sub)) {
            recorder_cfg.parse_xml(sub,"recorder_cfg");
        }
        if (extract_xml_record(field,"splitter_cfg",sub)) {
            splitter_cfg.parse_xml(sub,"splitter_cfg");
        }
        if (extract_xml_record(field,"analysis_cfg",sub)) {
            analysis_cfg.parse_xml(sub,"analysis_cfg");
        }
        if (extract_xml_record(field,"receiver_cfg",sub)) {
            receiver_cfg.parse_xml(sub,"receiver_cfg");
        }
    }
}

void settings::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> active;
    }
    {
        recorder_cfg.parse(SQL_ROW(s[2],0));
    }
    {
        splitter_cfg.parse(SQL_ROW(s[3],0));
    }
    {
        analysis_cfg.parse(SQL_ROW(s[4],0));
    }
    {
        receiver_cfg.parse(SQL_ROW(s[5],0));
    }
}

void settings::parse(const std::string &s) {
    SQL_ROW row(&s,6);
    parse(row);
}

template <> const char *const db_table<workunit_grp>::table_name="workunit_grp";
template <> const char *db_table<workunit_grp>::_search_tag=table_name;
template <> const int db_table<workunit_grp>::_nfields=9;
template <> const char *const db_table<workunit_grp>::column_names[9]= {"id","tape_info","name","data_desc","receiver_cfg","recorder_cfg","splitter_cfg","analysis_cfg","sb_id"};

workunit_grp::workunit_grp() :
    db_table<workunit_grp>(*this,-1),
    id(0),
    tape_info(),
    data_desc(),
    receiver_cfg(),
    recorder_cfg(),
    splitter_cfg(),
    analysis_cfg(),
    sb_id(0) {
    db_open();
    name[0]=0;
}


workunit_grp::workunit_grp(const workunit_grp &a) :
    db_table<workunit_grp>(*this,-1),
    id(a.id),
    tape_info(a.tape_info),
    data_desc(a.data_desc),
    receiver_cfg(a.receiver_cfg),
    recorder_cfg(a.recorder_cfg),
    splitter_cfg(a.splitter_cfg),
    analysis_cfg(a.analysis_cfg),
    sb_id(a.sb_id) {
    db_open();
    strcpy(name,a.name);
}


workunit_grp::workunit_grp(const SQL_ROW &a) :
    db_table<workunit_grp>(*this,-1) {
    db_open();
    parse(a);
}


workunit_grp::workunit_grp(const std::string &s,const char *tag) :
    db_table<workunit_grp>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


workunit_grp &workunit_grp::operator =(const workunit_grp &a) {
    if (&a != this) {
        id=a.id;
        tape_info=a.tape_info;
        data_desc=a.data_desc;
        receiver_cfg=a.receiver_cfg;
        recorder_cfg=a.recorder_cfg;
        splitter_cfg=a.splitter_cfg;
        analysis_cfg=a.analysis_cfg;
        sb_id=a.sb_id;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string workunit_grp::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<9; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string workunit_grp::insert_format() const {
    return std::string("?,")+update_format();
}

std::string workunit_grp::select_format() const {
    std::string rv("");
    for (int i=0; i<8; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string workunit_grp::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << tape_info.print(full_subtables,show_ids,no_refs);
        } else {
            rv << tape_info.id;
        }
    }
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << data_desc.print(full_subtables,show_ids,no_refs);
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << receiver_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << recorder_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << splitter_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << analysis_cfg.id;
        }
    }
    rv << ',';
    rv << sb_id;
    return rv.str();
}


std::string workunit_grp::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << tape_info.print_xml(full_subtables,show_ids,no_refs,"tape_info");
        } else {
            rv << xml_indent() << "<tape_info><id>" << tape_info.id << "</id></tape_info>\n";
        }
    }
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << data_desc.print_xml(full_subtables,show_ids,no_refs,"data_desc");
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print_xml(full_subtables,show_ids,no_refs,"receiver_cfg");
        } else {
            rv << xml_indent() << "<receiver_cfg><id>" << receiver_cfg.id << "</id></receiver_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print_xml(full_subtables,show_ids,no_refs,"recorder_cfg");
        } else {
            rv << xml_indent() << "<recorder_cfg><id>" << recorder_cfg.id << "</id></recorder_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print_xml(full_subtables,show_ids,no_refs,"splitter_cfg");
        } else {
            rv << xml_indent() << "<splitter_cfg><id>" << splitter_cfg.id << "</id></splitter_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print_xml(full_subtables,show_ids,no_refs,"analysis_cfg");
        } else {
            rv << xml_indent() << "<analysis_cfg><id>" << analysis_cfg.id << "</id></analysis_cfg>\n";
        }
    }
    rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void workunit_grp::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"tape_info",sub)) {
            tape_info.parse_xml(sub,"tape_info");
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"data_desc",sub)) {
            data_desc.parse_xml(sub,"data_desc");
        }
        if (extract_xml_record(field,"receiver_cfg",sub)) {
            receiver_cfg.parse_xml(sub,"receiver_cfg");
        }
        if (extract_xml_record(field,"recorder_cfg",sub)) {
            recorder_cfg.parse_xml(sub,"recorder_cfg");
        }
        if (extract_xml_record(field,"splitter_cfg",sub)) {
            splitter_cfg.parse_xml(sub,"splitter_cfg");
        }
        if (extract_xml_record(field,"analysis_cfg",sub)) {
            analysis_cfg.parse_xml(sub,"analysis_cfg");
        }
        if (extract_xml_record(field,"sb_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sb_id;
        }
    }
}

void workunit_grp::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        tape_info.parse(SQL_ROW(s[1],0));
    }
    {
        strncpy(name,s[2]->c_str(),64);
        name[63]=0;
    }
    {
        data_desc.parse(SQL_ROW(s[3],0));
    }
    {
        receiver_cfg.parse(SQL_ROW(s[4],0));
    }
    {
        recorder_cfg.parse(SQL_ROW(s[5],0));
    }
    {
        splitter_cfg.parse(SQL_ROW(s[6],0));
    }
    {
        analysis_cfg.parse(SQL_ROW(s[7],0));
    }
    {
        std::istringstream row(*(s[8]));
        row >> sb_id;
    }
}

void workunit_grp::parse(const std::string &s) {
    SQL_ROW row(&s,9);
    parse(row);
}

template <> const char *const db_table<workunit_header>::table_name="workunit_header";
template <> const char *db_table<workunit_header>::_search_tag=table_name;
template <> const int db_table<workunit_header>::_nfields=5;
template <> const char *const db_table<workunit_header>::column_names[5]= {"id","name","group_info","subband_desc","sb_id"};

workunit_header::workunit_header() :
    db_table<workunit_header>(*this,-1),
    id(0),
    group_info(),
    subband_desc(),
    sb_id(0) {
    db_open();
    name[0]=0;
}


workunit_header::workunit_header(const workunit_header &a) :
    db_table<workunit_header>(*this,-1),
    id(a.id),
    group_info(a.group_info),
    subband_desc(a.subband_desc),
    sb_id(a.sb_id) {
    db_open();
    strcpy(name,a.name);
}


workunit_header::workunit_header(const SQL_ROW &a) :
    db_table<workunit_header>(*this,-1) {
    db_open();
    parse(a);
}


workunit_header::workunit_header(const std::string &s,const char *tag) :
    db_table<workunit_header>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


workunit_header &workunit_header::operator =(const workunit_header &a) {
    if (&a != this) {
        id=a.id;
        group_info=a.group_info;
        subband_desc=a.subband_desc;
        sb_id=a.sb_id;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string workunit_header::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<5; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string workunit_header::insert_format() const {
    return std::string("?,")+update_format();
}

std::string workunit_header::select_format() const {
    std::string rv("");
    for (int i=0; i<4; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string workunit_header::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << group_info.print(full_subtables,show_ids,no_refs);
        } else {
            rv << group_info.id;
        }
    }
    rv << ',';
    rv << subband_desc.print(full_subtables,show_ids,no_refs);
    rv << ',';
    rv << sb_id;
    return rv.str();
}


std::string workunit_header::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << group_info.print_xml(full_subtables,show_ids,no_refs,"group_info");
        } else {
            rv << xml_indent() << "<group_info><id>" << group_info.id << "</id></group_info>\n";
        }
    }
    rv << subband_desc.print_xml(full_subtables,show_ids,no_refs,"subband_desc");
    rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void workunit_header::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"group_info",sub)) {
            group_info.parse_xml(sub,"group_info");
        }
        if (extract_xml_record(field,"subband_desc",sub)) {
            subband_desc.parse_xml(sub,"subband_desc");
        }
        if (extract_xml_record(field,"sb_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sb_id;
        }
    }
}

void workunit_header::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(name,s[1]->c_str(),64);
        name[63]=0;
    }
    {
        group_info.parse(SQL_ROW(s[2],0));
    }
    {
        subband_desc.parse(SQL_ROW(s[3],0));
    }
    {
        std::istringstream row(*(s[4]));
        row >> sb_id;
    }
}

void workunit_header::parse(const std::string &s) {
    SQL_ROW row(&s,5);
    parse(row);
}

template <> const char *const db_table<result>::table_name="result";
template <> const char *db_table<result>::_search_tag=table_name;
template <> const int db_table<result>::_nfields=10;
template <> const char *const db_table<result>::column_names[10]= {"id","boinc_result","wuid","received","hostid","versionid","return_code","overflow","reserved","sb_id"};

result::result() :
    db_table<result>(*this,-1),
    id(0),
    boinc_result(0),
    wuid(),
    received(0),
    hostid(0),
    versionid(0),
    return_code(0),
    overflow(0),
    reserved(0),
    sb_id(0) {
    db_open();
}


result::result(const result &a) :
    db_table<result>(*this,-1),
    id(a.id),
    boinc_result(a.boinc_result),
    wuid(a.wuid),
    received(a.received),
    hostid(a.hostid),
    versionid(a.versionid),
    return_code(a.return_code),
    overflow(a.overflow),
    reserved(a.reserved),
    sb_id(a.sb_id) {
    db_open();
}


result::result(const SQL_ROW &a) :
    db_table<result>(*this,-1) {
    db_open();
    parse(a);
}


result::result(const std::string &s,const char *tag) :
    db_table<result>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


result &result::operator =(const result &a) {
    if (&a != this) {
        id=a.id;
        boinc_result=a.boinc_result;
        wuid=a.wuid;
        received=a.received;
        hostid=a.hostid;
        versionid=a.versionid;
        return_code=a.return_code;
        overflow=a.overflow;
        reserved=a.reserved;
        sb_id=a.sb_id;
    }
    return (*this);
}


std::string result::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<10; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string result::insert_format() const {
    return std::string("?,")+update_format();
}

std::string result::select_format() const {
    std::string rv("");
    for (int i=0; i<9; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string result::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << boinc_result;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << wuid.print(full_subtables,show_ids,no_refs);
        } else {
            rv << wuid.id;
        }
    }
    rv << ',';
    rv << received;
    rv << ',';
    rv << hostid;
    rv << ',';
    rv << versionid;
    rv << ',';
    rv << return_code;
    rv << ',';
    rv << overflow;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << sb_id;
    return rv.str();
}


std::string result::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<boinc_result>" << boinc_result << "</boinc_result>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << wuid.print_xml(full_subtables,show_ids,no_refs,"wuid");
        } else {
            rv << xml_indent() << "<wuid><id>" << wuid.id << "</id></wuid>\n";
        }
    }
    rv << xml_indent() << "<received>" << received << "</received>\n";
    rv << xml_indent() << "<hostid>" << hostid << "</hostid>\n";
    rv << xml_indent() << "<versionid>" << versionid << "</versionid>\n";
    rv << xml_indent() << "<return_code>" << return_code << "</return_code>\n";
    rv << xml_indent() << "<overflow>" << overflow << "</overflow>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void result::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"boinc_result",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> boinc_result;
        }
        if (extract_xml_record(field,"wuid",sub)) {
            wuid.parse_xml(sub,"wuid");
        }
        if (extract_xml_record(field,"received",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> received;
        }
        if (extract_xml_record(field,"hostid",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> hostid;
        }
        if (extract_xml_record(field,"versionid",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> versionid;
        }
        if (extract_xml_record(field,"return_code",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> return_code;
        }
        if (extract_xml_record(field,"overflow",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> overflow;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"sb_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sb_id;
        }
    }
}

void result::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> boinc_result;
    }
    {
        wuid.parse(SQL_ROW(s[2],0));
    }
    {
        std::istringstream row(*(s[3]));
        row >> received;
    }
    {
        std::istringstream row(*(s[4]));
        row >> hostid;
    }
    {
        std::istringstream row(*(s[5]));
        row >> versionid;
    }
    {
        std::istringstream row(*(s[6]));
        row >> return_code;
    }
    {
        std::istringstream row(*(s[7]));
        row >> overflow;
    }
    {
        std::istringstream row(*(s[8]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[9]));
        row >> sb_id;
    }
}

void result::parse(const std::string &s) {
    SQL_ROW row(&s,10);
    parse(row);
}

template <> const char *const db_table<triplet>::table_name="triplet";
template <> const char *db_table<triplet>::_search_tag=table_name;
template <> const int db_table<triplet>::_nfields=17;
template <> const char *const db_table<triplet>::column_names[17]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","period"};

triplet::triplet() :
    db_table<triplet>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0),
    period(0) {
    db_open();
}


triplet::triplet(const triplet &a) :
    db_table<triplet>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved),
    period(a.period) {
    db_open();
}


triplet::triplet(const SQL_ROW &a) :
    db_table<triplet>(*this,-1) {
    db_open();
    parse(a);
}


triplet::triplet(const std::string &s,const char *tag) :
    db_table<triplet>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


triplet &triplet::operator =(const triplet &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        period=a.period;
    }
    return (*this);
}


std::string triplet::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<17; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string triplet::insert_format() const {
    return std::string("?,")+update_format();
}

std::string triplet::select_format() const {
    std::string rv("");
    for (int i=0; i<16; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string triplet::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << period;
    return rv.str();
}


std::string triplet::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<period>" << period << "</period>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void triplet::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period;
        }
    }
}

void triplet::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> period;
    }
}

void triplet::parse(const std::string &s) {
    SQL_ROW row(&s,17);
    parse(row);
}

template <> const char *const db_table<triplet_small>::table_name="triplet_small";
template <> const char *db_table<triplet_small>::_search_tag=table_name;
template <> const int db_table<triplet_small>::_nfields=17;
template <> const char *const db_table<triplet_small>::column_names[17]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","period"};

triplet_small::triplet_small() :
    db_table<triplet_small>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0),
    period(0) {
    db_open();
}


triplet_small::triplet_small(const triplet_small &a) :
    db_table<triplet_small>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved),
    period(a.period) {
    db_open();
}


triplet_small::triplet_small(const SQL_ROW &a) :
    db_table<triplet_small>(*this,-1) {
    db_open();
    parse(a);
}


triplet_small::triplet_small(const std::string &s,const char *tag) :
    db_table<triplet_small>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


triplet_small &triplet_small::operator =(const triplet_small &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        period=a.period;
    }
    return (*this);
}


std::string triplet_small::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<17; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string triplet_small::insert_format() const {
    return std::string("?,")+update_format();
}

std::string triplet_small::select_format() const {
    std::string rv("");
    for (int i=0; i<16; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string triplet_small::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << period;
    return rv.str();
}


std::string triplet_small::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<period>" << period << "</period>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void triplet_small::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period;
        }
    }
}

void triplet_small::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> period;
    }
}

void triplet_small::parse(const std::string &s) {
    SQL_ROW row(&s,17);
    parse(row);
}

template <> const char *const db_table<gaussian>::table_name="gaussian";
template <> const char *db_table<gaussian>::_search_tag=table_name;
template <> const int db_table<gaussian>::_nfields=22;
template <> const char *const db_table<gaussian>::column_names[22]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","sigma","chisqr","null_chisqr","score","max_power","pot"};

gaussian::gaussian() :
    db_table<gaussian>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0),
    sigma(0),
    chisqr(0),
    null_chisqr(0),
    score(0),
    max_power(0),
    pot((unsigned char *)0,0,_x_csv) {
    db_open();
}


gaussian::gaussian(const gaussian &a) :
    db_table<gaussian>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved),
    sigma(a.sigma),
    chisqr(a.chisqr),
    null_chisqr(a.null_chisqr),
    score(a.score),
    max_power(a.max_power),
    pot(a.pot) {
    db_open();
}


gaussian::gaussian(const SQL_ROW &a) :
    db_table<gaussian>(*this,-1) {
    db_open();
    parse(a);
}


gaussian::gaussian(const std::string &s,const char *tag) :
    db_table<gaussian>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


gaussian &gaussian::operator =(const gaussian &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        sigma=a.sigma;
        chisqr=a.chisqr;
        null_chisqr=a.null_chisqr;
        score=a.score;
        max_power=a.max_power;
        pot=a.pot;
    }
    return (*this);
}


std::string gaussian::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<22; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string gaussian::insert_format() const {
    return std::string("?,")+update_format();
}

std::string gaussian::select_format() const {
    std::string rv("");
    for (int i=0; i<21; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string gaussian::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << sigma;
    rv << ',';
    rv << chisqr;
    rv << ',';
    rv << null_chisqr;
    rv << ',';
    rv << score;
    rv << ',';
    rv << max_power;
    rv << ',';
    rv << "<BYTE len=" << std::max(pot.size()*2,(size_t)1) << ">" << pot.print_hex() ;
    return rv.str();
}


std::string gaussian::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<sigma>" << sigma << "</sigma>\n";
    rv << xml_indent() << "<chisqr>" << chisqr << "</chisqr>\n";
    rv << xml_indent() << "<null_chisqr>" << null_chisqr << "</null_chisqr>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<max_power>" << max_power << "</max_power>\n";
    if (pot.size()) {
        std::string enc_field=xml_encode_string(pot,pot.encoding);
        rv << xml_indent() << "<pot length=" << enc_field.size() << " encoding=\"" << xml_encoding_names[pot.encoding] << "\">";
        rv << enc_field << "</pot>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void gaussian::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"sigma",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sigma;
        }
        if (extract_xml_record(field,"chisqr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chisqr;
        }
        if (extract_xml_record(field,"null_chisqr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> null_chisqr;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"max_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_power;
        }
        if (extract_xml_record(field,"pot",sub)) {
            std::istringstream in(sub.c_str());
            in >> pot;
        }
    }
}

void gaussian::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> sigma;
    }
    {
        std::istringstream row(*(s[17]));
        row >> chisqr;
    }
    {
        std::istringstream row(*(s[18]));
        row >> null_chisqr;
    }
    {
        std::istringstream row(*(s[19]));
        row >> score;
    }
    {
        std::istringstream row(*(s[20]));
        row >> max_power;
    }
    {
        pot=sqlblob<unsigned char>(*(s[21]));
    }
}

void gaussian::parse(const std::string &s) {
    SQL_ROW row(&s,22);
    parse(row);
}

template <> const char *const db_table<gaussian_small>::table_name="gaussian_small";
template <> const char *db_table<gaussian_small>::_search_tag=table_name;
template <> const int db_table<gaussian_small>::_nfields=21;
template <> const char *const db_table<gaussian_small>::column_names[21]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","sigma","chisqr","null_chisqr","score","max_power"};

gaussian_small::gaussian_small() :
    db_table<gaussian_small>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0),
    sigma(0),
    chisqr(0),
    null_chisqr(0),
    score(0),
    max_power(0) {
    db_open();
}


gaussian_small::gaussian_small(const gaussian_small &a) :
    db_table<gaussian_small>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved),
    sigma(a.sigma),
    chisqr(a.chisqr),
    null_chisqr(a.null_chisqr),
    score(a.score),
    max_power(a.max_power) {
    db_open();
}


gaussian_small::gaussian_small(const SQL_ROW &a) :
    db_table<gaussian_small>(*this,-1) {
    db_open();
    parse(a);
}


gaussian_small::gaussian_small(const std::string &s,const char *tag) :
    db_table<gaussian_small>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


gaussian_small &gaussian_small::operator =(const gaussian_small &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        sigma=a.sigma;
        chisqr=a.chisqr;
        null_chisqr=a.null_chisqr;
        score=a.score;
        max_power=a.max_power;
    }
    return (*this);
}


std::string gaussian_small::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<21; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string gaussian_small::insert_format() const {
    return std::string("?,")+update_format();
}

std::string gaussian_small::select_format() const {
    std::string rv("");
    for (int i=0; i<20; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string gaussian_small::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << sigma;
    rv << ',';
    rv << chisqr;
    rv << ',';
    rv << null_chisqr;
    rv << ',';
    rv << score;
    rv << ',';
    rv << max_power;
    return rv.str();
}


std::string gaussian_small::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<sigma>" << sigma << "</sigma>\n";
    rv << xml_indent() << "<chisqr>" << chisqr << "</chisqr>\n";
    rv << xml_indent() << "<null_chisqr>" << null_chisqr << "</null_chisqr>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<max_power>" << max_power << "</max_power>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void gaussian_small::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"sigma",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sigma;
        }
        if (extract_xml_record(field,"chisqr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chisqr;
        }
        if (extract_xml_record(field,"null_chisqr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> null_chisqr;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"max_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_power;
        }
    }
}

void gaussian_small::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> sigma;
    }
    {
        std::istringstream row(*(s[17]));
        row >> chisqr;
    }
    {
        std::istringstream row(*(s[18]));
        row >> null_chisqr;
    }
    {
        std::istringstream row(*(s[19]));
        row >> score;
    }
    {
        std::istringstream row(*(s[20]));
        row >> max_power;
    }
}

void gaussian_small::parse(const std::string &s) {
    SQL_ROW row(&s,21);
    parse(row);
}

template <> const char *const db_table<pulse>::table_name="pulse";
template <> const char *db_table<pulse>::_search_tag=table_name;
template <> const int db_table<pulse>::_nfields=22;
template <> const char *const db_table<pulse>::column_names[22]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","period","snr","thresh","score","len_prof","pot"};

pulse::pulse() :
    db_table<pulse>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0),
    period(0),
    snr(0),
    thresh(0),
    score(0),
    len_prof(0),
    pot((unsigned char *)0,0,_x_csv) {
    db_open();
}


pulse::pulse(const pulse &a) :
    db_table<pulse>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved),
    period(a.period),
    snr(a.snr),
    thresh(a.thresh),
    score(a.score),
    len_prof(a.len_prof),
    pot(a.pot) {
    db_open();
}


pulse::pulse(const SQL_ROW &a) :
    db_table<pulse>(*this,-1) {
    db_open();
    parse(a);
}


pulse::pulse(const std::string &s,const char *tag) :
    db_table<pulse>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


pulse &pulse::operator =(const pulse &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        period=a.period;
        snr=a.snr;
        thresh=a.thresh;
        score=a.score;
        len_prof=a.len_prof;
        pot=a.pot;
    }
    return (*this);
}


std::string pulse::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<22; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string pulse::insert_format() const {
    return std::string("?,")+update_format();
}

std::string pulse::select_format() const {
    std::string rv("");
    for (int i=0; i<21; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string pulse::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << period;
    rv << ',';
    rv << snr;
    rv << ',';
    rv << thresh;
    rv << ',';
    rv << score;
    rv << ',';
    rv << len_prof;
    rv << ',';
    rv << "<BYTE len=" << std::max(pot.size()*2,(size_t)1) << ">" << pot.print_hex() ;
    return rv.str();
}


std::string pulse::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<period>" << period << "</period>\n";
    rv << xml_indent() << "<snr>" << snr << "</snr>\n";
    rv << xml_indent() << "<thresh>" << thresh << "</thresh>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<len_prof>" << len_prof << "</len_prof>\n";
    if (pot.size()) {
        std::string enc_field=xml_encode_string(pot,pot.encoding);
        rv << xml_indent() << "<pot length=" << enc_field.size() << " encoding=\"" << xml_encoding_names[pot.encoding] << "\">";
        rv << enc_field << "</pot>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void pulse::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period;
        }
        if (extract_xml_record(field,"snr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> snr;
        }
        if (extract_xml_record(field,"thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> thresh;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"len_prof",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> len_prof;
        }
        if (extract_xml_record(field,"pot",sub)) {
            std::istringstream in(sub.c_str());
            in >> pot;
        }
    }
}

void pulse::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> period;
    }
    {
        std::istringstream row(*(s[17]));
        row >> snr;
    }
    {
        std::istringstream row(*(s[18]));
        row >> thresh;
    }
    {
        std::istringstream row(*(s[19]));
        row >> score;
    }
    {
        std::istringstream row(*(s[20]));
        row >> len_prof;
    }
    {
        pot=sqlblob<unsigned char>(*(s[21]));
    }
}

void pulse::parse(const std::string &s) {
    SQL_ROW row(&s,22);
    parse(row);
}

template <> const char *const db_table<pulse_small>::table_name="pulse_small";
template <> const char *db_table<pulse_small>::_search_tag=table_name;
template <> const int db_table<pulse_small>::_nfields=20;
template <> const char *const db_table<pulse_small>::column_names[20]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","period","snr","thresh","score"};

pulse_small::pulse_small() :
    db_table<pulse_small>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0),
    period(0),
    snr(0),
    thresh(0),
    score(0) {
    db_open();
}


pulse_small::pulse_small(const pulse_small &a) :
    db_table<pulse_small>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved),
    period(a.period),
    snr(a.snr),
    thresh(a.thresh),
    score(a.score) {
    db_open();
}


pulse_small::pulse_small(const SQL_ROW &a) :
    db_table<pulse_small>(*this,-1) {
    db_open();
    parse(a);
}


pulse_small::pulse_small(const std::string &s,const char *tag) :
    db_table<pulse_small>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


pulse_small &pulse_small::operator =(const pulse_small &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        period=a.period;
        snr=a.snr;
        thresh=a.thresh;
        score=a.score;
    }
    return (*this);
}


std::string pulse_small::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<20; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string pulse_small::insert_format() const {
    return std::string("?,")+update_format();
}

std::string pulse_small::select_format() const {
    std::string rv("");
    for (int i=0; i<19; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string pulse_small::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << period;
    rv << ',';
    rv << snr;
    rv << ',';
    rv << thresh;
    rv << ',';
    rv << score;
    return rv.str();
}


std::string pulse_small::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<period>" << period << "</period>\n";
    rv << xml_indent() << "<snr>" << snr << "</snr>\n";
    rv << xml_indent() << "<thresh>" << thresh << "</thresh>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void pulse_small::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period;
        }
        if (extract_xml_record(field,"snr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> snr;
        }
        if (extract_xml_record(field,"thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> thresh;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
    }
}

void pulse_small::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> period;
    }
    {
        std::istringstream row(*(s[17]));
        row >> snr;
    }
    {
        std::istringstream row(*(s[18]));
        row >> thresh;
    }
    {
        std::istringstream row(*(s[19]));
        row >> score;
    }
}

void pulse_small::parse(const std::string &s) {
    SQL_ROW row(&s,20);
    parse(row);
}

template <> const char *const db_table<sah_pointing>::table_name="sah_pointing";
template <> const char *db_table<sah_pointing>::_search_tag=table_name;
template <> const int db_table<sah_pointing>::_nfields=7;
template <> const char *const db_table<sah_pointing>::column_names[7]= {"time_id","time","ra","dec","q_pix","angle_range","bad"};

sah_pointing::sah_pointing() :
    db_table<sah_pointing>(*this,-1),
    time_id(0),
    time(0),
    ra(0),
    dec(0),
    q_pix(0),
    angle_range(0),
    bad(0) {
    db_open();
}


sah_pointing::sah_pointing(const sah_pointing &a) :
    db_table<sah_pointing>(*this,-1),
    time_id(a.time_id),
    time(a.time),
    ra(a.ra),
    dec(a.dec),
    q_pix(a.q_pix),
    angle_range(a.angle_range),
    bad(a.bad) {
    db_open();
}


sah_pointing::sah_pointing(const SQL_ROW &a) :
    db_table<sah_pointing>(*this,-1) {
    db_open();
    parse(a);
}


sah_pointing::sah_pointing(const std::string &s,const char *tag) :
    db_table<sah_pointing>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


sah_pointing &sah_pointing::operator =(const sah_pointing &a) {
    if (&a != this) {
        time_id=a.time_id;
        time=a.time;
        ra=a.ra;
        dec=a.dec;
        q_pix=a.q_pix;
        angle_range=a.angle_range;
        bad=a.bad;
    }
    return (*this);
}


std::string sah_pointing::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<7; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string sah_pointing::insert_format() const {
    return std::string("?,")+update_format();
}

std::string sah_pointing::select_format() const {
    std::string rv("");
    for (int i=0; i<6; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string sah_pointing::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << time_id;
    }
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << dec;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << angle_range;
    rv << ',';
    rv << bad;
    return rv.str();
}


std::string sah_pointing::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<time_id>" << time_id << "</time_id>\n";
    }
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<dec>" << dec << "</dec>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<angle_range>" << angle_range << "</angle_range>\n";
    rv << xml_indent() << "<bad>" << bad << "</bad>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void sah_pointing::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"time_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time_id;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> dec;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"angle_range",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> angle_range;
        }
        if (extract_xml_record(field,"bad",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bad;
        }
    }
}

void sah_pointing::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> time_id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> time;
    }
    {
        std::istringstream row(*(s[2]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[3]));
        row >> dec;
    }
    {
        std::istringstream row(*(s[4]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[5]));
        row >> angle_range;
    }
    {
        std::istringstream row(*(s[6]));
        row >> bad;
    }
}

void sah_pointing::parse(const std::string &s) {
    SQL_ROW row(&s,7);
    parse(row);
}

template <> const char *const db_table<sky_map>::table_name="sky_map";
template <> const char *db_table<sky_map>::_search_tag=table_name;
template <> const int db_table<sky_map>::_nfields=13;
template <> const char *const db_table<sky_map>::column_names[13]= {"npix","qpix","fpix","spike_max_id","gaussian_max_id","pulse_max_id","triplet_max_id","spike_count","gaussian_count","pulse_count","triplet_count","new_data","score"};

sky_map::sky_map() :
    db_table<sky_map>(*this,-1),
    npix(0),
    qpix(0),
    fpix(0),
    spike_max_id(0),
    gaussian_max_id(0),
    pulse_max_id(0),
    triplet_max_id(0),
    spike_count(0),
    gaussian_count(0),
    pulse_count(0),
    triplet_count(0),
    new_data(0),
    score(0) {
    db_open();
}


sky_map::sky_map(const sky_map &a) :
    db_table<sky_map>(*this,-1),
    npix(a.npix),
    qpix(a.qpix),
    fpix(a.fpix),
    spike_max_id(a.spike_max_id),
    gaussian_max_id(a.gaussian_max_id),
    pulse_max_id(a.pulse_max_id),
    triplet_max_id(a.triplet_max_id),
    spike_count(a.spike_count),
    gaussian_count(a.gaussian_count),
    pulse_count(a.pulse_count),
    triplet_count(a.triplet_count),
    new_data(a.new_data),
    score(a.score) {
    db_open();
}


sky_map::sky_map(const SQL_ROW &a) :
    db_table<sky_map>(*this,-1) {
    db_open();
    parse(a);
}


sky_map::sky_map(const std::string &s,const char *tag) :
    db_table<sky_map>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


sky_map &sky_map::operator =(const sky_map &a) {
    if (&a != this) {
        npix=a.npix;
        qpix=a.qpix;
        fpix=a.fpix;
        spike_max_id=a.spike_max_id;
        gaussian_max_id=a.gaussian_max_id;
        pulse_max_id=a.pulse_max_id;
        triplet_max_id=a.triplet_max_id;
        spike_count=a.spike_count;
        gaussian_count=a.gaussian_count;
        pulse_count=a.pulse_count;
        triplet_count=a.triplet_count;
        new_data=a.new_data;
        score=a.score;
    }
    return (*this);
}


std::string sky_map::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<13; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string sky_map::insert_format() const {
    return std::string("?,")+update_format();
}

std::string sky_map::select_format() const {
    std::string rv("");
    for (int i=0; i<12; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string sky_map::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << npix;
    }
    rv << ',';
    rv << qpix;
    rv << ',';
    rv << fpix;
    rv << ',';
    rv << spike_max_id;
    rv << ',';
    rv << gaussian_max_id;
    rv << ',';
    rv << pulse_max_id;
    rv << ',';
    rv << triplet_max_id;
    rv << ',';
    rv << spike_count;
    rv << ',';
    rv << gaussian_count;
    rv << ',';
    rv << pulse_count;
    rv << ',';
    rv << triplet_count;
    rv << ',';
    rv << new_data;
    rv << ',';
    rv << score;
    return rv.str();
}


std::string sky_map::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<npix>" << npix << "</npix>\n";
    }
    rv << xml_indent() << "<qpix>" << qpix << "</qpix>\n";
    rv << xml_indent() << "<fpix>" << fpix << "</fpix>\n";
    rv << xml_indent() << "<spike_max_id>" << spike_max_id << "</spike_max_id>\n";
    rv << xml_indent() << "<gaussian_max_id>" << gaussian_max_id << "</gaussian_max_id>\n";
    rv << xml_indent() << "<pulse_max_id>" << pulse_max_id << "</pulse_max_id>\n";
    rv << xml_indent() << "<triplet_max_id>" << triplet_max_id << "</triplet_max_id>\n";
    rv << xml_indent() << "<spike_count>" << spike_count << "</spike_count>\n";
    rv << xml_indent() << "<gaussian_count>" << gaussian_count << "</gaussian_count>\n";
    rv << xml_indent() << "<pulse_count>" << pulse_count << "</pulse_count>\n";
    rv << xml_indent() << "<triplet_count>" << triplet_count << "</triplet_count>\n";
    rv << xml_indent() << "<new_data>" << new_data << "</new_data>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void sky_map::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"npix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> npix;
        }
        if (extract_xml_record(field,"qpix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> qpix;
        }
        if (extract_xml_record(field,"fpix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fpix;
        }
        if (extract_xml_record(field,"spike_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_max_id;
        }
        if (extract_xml_record(field,"gaussian_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_max_id;
        }
        if (extract_xml_record(field,"pulse_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_max_id;
        }
        if (extract_xml_record(field,"triplet_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_max_id;
        }
        if (extract_xml_record(field,"spike_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_count;
        }
        if (extract_xml_record(field,"gaussian_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_count;
        }
        if (extract_xml_record(field,"pulse_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_count;
        }
        if (extract_xml_record(field,"triplet_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_count;
        }
        if (extract_xml_record(field,"new_data",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> new_data;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
    }
}

void sky_map::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> npix;
    }
    {
        std::istringstream row(*(s[1]));
        row >> qpix;
    }
    {
        std::istringstream row(*(s[2]));
        row >> fpix;
    }
    {
        std::istringstream row(*(s[3]));
        row >> spike_max_id;
    }
    {
        std::istringstream row(*(s[4]));
        row >> gaussian_max_id;
    }
    {
        std::istringstream row(*(s[5]));
        row >> pulse_max_id;
    }
    {
        std::istringstream row(*(s[6]));
        row >> triplet_max_id;
    }
    {
        std::istringstream row(*(s[7]));
        row >> spike_count;
    }
    {
        std::istringstream row(*(s[8]));
        row >> gaussian_count;
    }
    {
        std::istringstream row(*(s[9]));
        row >> pulse_count;
    }
    {
        std::istringstream row(*(s[10]));
        row >> triplet_count;
    }
    {
        std::istringstream row(*(s[11]));
        row >> new_data;
    }
    {
        std::istringstream row(*(s[12]));
        row >> score;
    }
}

void sky_map::parse(const std::string &s) {
    SQL_ROW row(&s,13);
    parse(row);
}

template <> const char *const db_table<hotpix>::table_name="hotpix";
template <> const char *db_table<hotpix>::_search_tag=table_name;
template <> const int db_table<hotpix>::_nfields=2;
template <> const char *const db_table<hotpix>::column_names[2]= {"id","last_hit_time"};

hotpix::hotpix() :
    db_table<hotpix>(*this,-1),
    id(0),
    last_hit_time(0) {
    db_open();
}


hotpix::hotpix(const hotpix &a) :
    db_table<hotpix>(*this,-1),
    id(a.id),
    last_hit_time(a.last_hit_time) {
    db_open();
}


hotpix::hotpix(const SQL_ROW &a) :
    db_table<hotpix>(*this,-1) {
    db_open();
    parse(a);
}


hotpix::hotpix(const std::string &s,const char *tag) :
    db_table<hotpix>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


hotpix &hotpix::operator =(const hotpix &a) {
    if (&a != this) {
        id=a.id;
        last_hit_time=a.last_hit_time;
    }
    return (*this);
}


std::string hotpix::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<2; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string hotpix::insert_format() const {
    return std::string("?,")+update_format();
}

std::string hotpix::select_format() const {
    std::string rv("");
    for (int i=0; i<1; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string hotpix::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << last_hit_time;
    return rv.str();
}


std::string hotpix::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<last_hit_time>" << last_hit_time << "</last_hit_time>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void hotpix::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"last_hit_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> last_hit_time;
        }
    }
}

void hotpix::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> last_hit_time;
    }
}

void hotpix::parse(const std::string &s) {
    SQL_ROW row(&s,2);
    parse(row);
}

template <> const char *const db_table<spike>::table_name="spike";
template <> const char *db_table<spike>::_search_tag=table_name;
template <> const int db_table<spike>::_nfields=16;
template <> const char *const db_table<spike>::column_names[16]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved"};

spike::spike() :
    db_table<spike>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0) {
    db_open();
}


spike::spike(const spike &a) :
    db_table<spike>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved) {
    db_open();
}


spike::spike(const SQL_ROW &a) :
    db_table<spike>(*this,-1) {
    db_open();
    parse(a);
}


spike::spike(const std::string &s,const char *tag) :
    db_table<spike>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


spike &spike::operator =(const spike &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
    }
    return (*this);
}


std::string spike::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<16; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string spike::insert_format() const {
    return std::string("?,")+update_format();
}

std::string spike::select_format() const {
    std::string rv("");
    for (int i=0; i<15; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string spike::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    return rv.str();
}


std::string spike::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void spike::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
    }
}

void spike::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
}

void spike::parse(const std::string &s) {
    SQL_ROW row(&s,16);
    parse(row);
}

template <> const char *const db_table<spike_small>::table_name="spike_small";
template <> const char *db_table<spike_small>::_search_tag=table_name;
template <> const int db_table<spike_small>::_nfields=16;
template <> const char *const db_table<spike_small>::column_names[16]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved"};

spike_small::spike_small() :
    db_table<spike_small>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0) {
    db_open();
}


spike_small::spike_small(const spike_small &a) :
    db_table<spike_small>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved) {
    db_open();
}


spike_small::spike_small(const SQL_ROW &a) :
    db_table<spike_small>(*this,-1) {
    db_open();
    parse(a);
}


spike_small::spike_small(const std::string &s,const char *tag) :
    db_table<spike_small>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


spike_small &spike_small::operator =(const spike_small &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
    }
    return (*this);
}


std::string spike_small::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<16; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string spike_small::insert_format() const {
    return std::string("?,")+update_format();
}

std::string spike_small::select_format() const {
    std::string rv("");
    for (int i=0; i<15; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string spike_small::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    return rv.str();
}


std::string spike_small::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void spike_small::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
    }
}

void spike_small::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
}

void spike_small::parse(const std::string &s) {
    SQL_ROW row(&s,16);
    parse(row);
}

template <> const char *const db_table<autocorr>::table_name="autocorr";
template <> const char *db_table<autocorr>::_search_tag=table_name;
template <> const int db_table<autocorr>::_nfields=17;
template <> const char *const db_table<autocorr>::column_names[17]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","delay","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved"};

autocorr::autocorr() :
    db_table<autocorr>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    delay(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0) {
    db_open();
}


autocorr::autocorr(const autocorr &a) :
    db_table<autocorr>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    delay(a.delay),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved) {
    db_open();
}


autocorr::autocorr(const SQL_ROW &a) :
    db_table<autocorr>(*this,-1) {
    db_open();
    parse(a);
}


autocorr::autocorr(const std::string &s,const char *tag) :
    db_table<autocorr>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


autocorr &autocorr::operator =(const autocorr &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        delay=a.delay;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
    }
    return (*this);
}


std::string autocorr::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<17; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string autocorr::insert_format() const {
    return std::string("?,")+update_format();
}

std::string autocorr::select_format() const {
    std::string rv("");
    for (int i=0; i<16; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string autocorr::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << delay;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    return rv.str();
}


std::string autocorr::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<delay>" << delay << "</delay>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void autocorr::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"delay",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> delay;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
    }
}

void autocorr::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> delay;
    }
    {
        std::istringstream row(*(s[9]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[12]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[13]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[15]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[16]));
        row >> reserved;
    }
}

void autocorr::parse(const std::string &s) {
    SQL_ROW row(&s,17);
    parse(row);
}

template <> const char *const db_table<autocorr_small>::table_name="autocorr_small";
template <> const char *db_table<autocorr_small>::_search_tag=table_name;
template <> const int db_table<autocorr_small>::_nfields=17;
template <> const char *const db_table<autocorr_small>::column_names[17]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","delay","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved"};

autocorr_small::autocorr_small() :
    db_table<autocorr_small>(*this,-1),
    id(0),
    result_id(),
    peak_power(0),
    mean_power(0),
    time(0),
    ra(0),
    decl(0),
    q_pix(0),
    delay(0),
    freq(0),
    detection_freq(0),
    barycentric_freq(0),
    fft_len(0),
    chirp_rate(0),
    rfi_checked(0),
    rfi_found(0),
    reserved(0) {
    db_open();
}


autocorr_small::autocorr_small(const autocorr_small &a) :
    db_table<autocorr_small>(*this,-1),
    id(a.id),
    result_id(a.result_id),
    peak_power(a.peak_power),
    mean_power(a.mean_power),
    time(a.time),
    ra(a.ra),
    decl(a.decl),
    q_pix(a.q_pix),
    delay(a.delay),
    freq(a.freq),
    detection_freq(a.detection_freq),
    barycentric_freq(a.barycentric_freq),
    fft_len(a.fft_len),
    chirp_rate(a.chirp_rate),
    rfi_checked(a.rfi_checked),
    rfi_found(a.rfi_found),
    reserved(a.reserved) {
    db_open();
}


autocorr_small::autocorr_small(const SQL_ROW &a) :
    db_table<autocorr_small>(*this,-1) {
    db_open();
    parse(a);
}


autocorr_small::autocorr_small(const std::string &s,const char *tag) :
    db_table<autocorr_small>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


autocorr_small &autocorr_small::operator =(const autocorr_small &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        delay=a.delay;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
    }
    return (*this);
}


std::string autocorr_small::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<17; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string autocorr_small::insert_format() const {
    return std::string("?,")+update_format();
}

std::string autocorr_small::select_format() const {
    std::string rv("");
    for (int i=0; i<16; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string autocorr_small::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << delay;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    return rv.str();
}


std::string autocorr_small::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<delay>" << delay << "</delay>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void autocorr_small::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"delay",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> delay;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
    }
}

void autocorr_small::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1],0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> delay;
    }
    {
        std::istringstream row(*(s[9]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[12]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[13]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[15]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[16]));
        row >> reserved;
    }
}

void autocorr_small::parse(const std::string &s) {
    SQL_ROW row(&s,17);
    parse(row);
}

template <> const char *const db_table<classic_versions>::table_name="classic_versions";
template <> const char *db_table<classic_versions>::_search_tag=table_name;
template <> const int db_table<classic_versions>::_nfields=10;
template <> const char *const db_table<classic_versions>::column_names[10]= {"id","ver_major","ver_minor","platformid","comment","filename","md5_cksum","sum_cksum","cksum_cksum","file_cksum"};

classic_versions::classic_versions() :
    db_table<classic_versions>(*this,-1),
    id(0),
    ver_major(0),
    ver_minor(0),
    platformid(0),
    file_cksum(0) {
    db_open();
    comment[0]=0;
    filename[0]=0;
    md5_cksum[0]=0;
    sum_cksum[0]=0;
    cksum_cksum[0]=0;
}


classic_versions::classic_versions(const classic_versions &a) :
    db_table<classic_versions>(*this,-1),
    id(a.id),
    ver_major(a.ver_major),
    ver_minor(a.ver_minor),
    platformid(a.platformid),
    file_cksum(a.file_cksum) {
    db_open();
    strcpy(comment,a.comment);
    strcpy(filename,a.filename);
    strcpy(md5_cksum,a.md5_cksum);
    strcpy(sum_cksum,a.sum_cksum);
    strcpy(cksum_cksum,a.cksum_cksum);
}


classic_versions::classic_versions(const SQL_ROW &a) :
    db_table<classic_versions>(*this,-1) {
    db_open();
    parse(a);
}


classic_versions::classic_versions(const std::string &s,const char *tag) :
    db_table<classic_versions>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


classic_versions &classic_versions::operator =(const classic_versions &a) {
    if (&a != this) {
        id=a.id;
        ver_major=a.ver_major;
        ver_minor=a.ver_minor;
        platformid=a.platformid;
        file_cksum=a.file_cksum;
        strcpy(comment,a.comment);
        strcpy(filename,a.filename);
        strcpy(md5_cksum,a.md5_cksum);
        strcpy(sum_cksum,a.sum_cksum);
        strcpy(cksum_cksum,a.cksum_cksum);
    }
    return (*this);
}


std::string classic_versions::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<10; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string classic_versions::insert_format() const {
    return std::string("?,")+update_format();
}

std::string classic_versions::select_format() const {
    std::string rv("");
    for (int i=0; i<9; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string classic_versions::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << ver_major;
    rv << ',';
    rv << ver_minor;
    rv << ',';
    rv << platformid;
    rv << ',';
    rv << "'" << comment << "'";
    rv << ',';
    rv << "'" << filename << "'";
    rv << ',';
    rv << "'" << md5_cksum << "'";
    rv << ',';
    rv << "'" << sum_cksum << "'";
    rv << ',';
    rv << "'" << cksum_cksum << "'";
    rv << ',';
    rv << file_cksum;
    return rv.str();
}


std::string classic_versions::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<ver_major>" << ver_major << "</ver_major>\n";
    rv << xml_indent() << "<ver_minor>" << ver_minor << "</ver_minor>\n";
    rv << xml_indent() << "<platformid>" << platformid << "</platformid>\n";
    {
        std::string enc_field=xml_encode_string(comment,std::min(strlen(comment),sizeof(comment)));
        rv << xml_indent() << "<comment>";
        rv << enc_field << "</comment>\n";
    }
    {
        std::string enc_field=xml_encode_string(filename,std::min(strlen(filename),sizeof(filename)));
        rv << xml_indent() << "<filename>";
        rv << enc_field << "</filename>\n";
    }
    {
        std::string enc_field=xml_encode_string(md5_cksum,std::min(strlen(md5_cksum),sizeof(md5_cksum)));
        rv << xml_indent() << "<md5_cksum>";
        rv << enc_field << "</md5_cksum>\n";
    }
    {
        std::string enc_field=xml_encode_string(sum_cksum,std::min(strlen(sum_cksum),sizeof(sum_cksum)));
        rv << xml_indent() << "<sum_cksum>";
        rv << enc_field << "</sum_cksum>\n";
    }
    {
        std::string enc_field=xml_encode_string(cksum_cksum,std::min(strlen(cksum_cksum),sizeof(cksum_cksum)));
        rv << xml_indent() << "<cksum_cksum>";
        rv << enc_field << "</cksum_cksum>\n";
    }
    rv << xml_indent() << "<file_cksum>" << file_cksum << "</file_cksum>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void classic_versions::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"ver_major",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ver_major;
        }
        if (extract_xml_record(field,"ver_minor",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ver_minor;
        }
        if (extract_xml_record(field,"platformid",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> platformid;
        }
        if (extract_xml_record(field,"comment",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(comment,(const char *)&(in.front()),std::min(in.size(),(size_t)254));
            comment[std::min(in.size(),(size_t)253)]=0;
        }
        if (extract_xml_record(field,"filename",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(filename,(const char *)&(in.front()),std::min(in.size(),(size_t)254));
            filename[std::min(in.size(),(size_t)253)]=0;
        }
        if (extract_xml_record(field,"md5_cksum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(md5_cksum,(const char *)&(in.front()),std::min(in.size(),(size_t)254));
            md5_cksum[std::min(in.size(),(size_t)253)]=0;
        }
        if (extract_xml_record(field,"sum_cksum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(sum_cksum,(const char *)&(in.front()),std::min(in.size(),(size_t)254));
            sum_cksum[std::min(in.size(),(size_t)253)]=0;
        }
        if (extract_xml_record(field,"cksum_cksum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(cksum_cksum,(const char *)&(in.front()),std::min(in.size(),(size_t)254));
            cksum_cksum[std::min(in.size(),(size_t)253)]=0;
        }
        if (extract_xml_record(field,"file_cksum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> file_cksum;
        }
    }
}

void classic_versions::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> ver_major;
    }
    {
        std::istringstream row(*(s[2]));
        row >> ver_minor;
    }
    {
        std::istringstream row(*(s[3]));
        row >> platformid;
    }
    {
        strncpy(comment,s[4]->c_str(),254);
        comment[253]=0;
    }
    {
        strncpy(filename,s[5]->c_str(),254);
        filename[253]=0;
    }
    {
        strncpy(md5_cksum,s[6]->c_str(),254);
        md5_cksum[253]=0;
    }
    {
        strncpy(sum_cksum,s[7]->c_str(),254);
        sum_cksum[253]=0;
    }
    {
        strncpy(cksum_cksum,s[8]->c_str(),254);
        cksum_cksum[253]=0;
    }
    {
        std::istringstream row(*(s[9]));
        row >> file_cksum;
    }
}

void classic_versions::parse(const std::string &s) {
    SQL_ROW row(&s,10);
    parse(row);
}

template <> const char *const db_table<classic_active_versions>::table_name="classic_active_versions";
template <> const char *db_table<classic_active_versions>::_search_tag=table_name;
template <> const int db_table<classic_active_versions>::_nfields=4;
template <> const char *const db_table<classic_active_versions>::column_names[4]= {"id","versionid","ver_major","ver_minor"};

classic_active_versions::classic_active_versions() :
    db_table<classic_active_versions>(*this,-1),
    id(0),
    versionid(0),
    ver_major(0),
    ver_minor(0) {
    db_open();
}


classic_active_versions::classic_active_versions(const classic_active_versions &a) :
    db_table<classic_active_versions>(*this,-1),
    id(a.id),
    versionid(a.versionid),
    ver_major(a.ver_major),
    ver_minor(a.ver_minor) {
    db_open();
}


classic_active_versions::classic_active_versions(const SQL_ROW &a) :
    db_table<classic_active_versions>(*this,-1) {
    db_open();
    parse(a);
}


classic_active_versions::classic_active_versions(const std::string &s,const char *tag) :
    db_table<classic_active_versions>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


classic_active_versions &classic_active_versions::operator =(const classic_active_versions &a) {
    if (&a != this) {
        id=a.id;
        versionid=a.versionid;
        ver_major=a.ver_major;
        ver_minor=a.ver_minor;
    }
    return (*this);
}


std::string classic_active_versions::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<4; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string classic_active_versions::insert_format() const {
    return std::string("?,")+update_format();
}

std::string classic_active_versions::select_format() const {
    std::string rv("");
    for (int i=0; i<3; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string classic_active_versions::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << versionid;
    rv << ',';
    rv << ver_major;
    rv << ',';
    rv << ver_minor;
    return rv.str();
}


std::string classic_active_versions::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<versionid>" << versionid << "</versionid>\n";
    rv << xml_indent() << "<ver_major>" << ver_major << "</ver_major>\n";
    rv << xml_indent() << "<ver_minor>" << ver_minor << "</ver_minor>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void classic_active_versions::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"versionid",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> versionid;
        }
        if (extract_xml_record(field,"ver_major",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ver_major;
        }
        if (extract_xml_record(field,"ver_minor",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ver_minor;
        }
    }
}

void classic_active_versions::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> versionid;
    }
    {
        std::istringstream row(*(s[2]));
        row >> ver_major;
    }
    {
        std::istringstream row(*(s[3]));
        row >> ver_minor;
    }
}

void classic_active_versions::parse(const std::string &s) {
    SQL_ROW row(&s,4);
    parse(row);
}

template <> const char *const db_table<classic_active_versionids>::table_name="classic_active_versionids";
template <> const char *db_table<classic_active_versionids>::_search_tag=table_name;
template <> const int db_table<classic_active_versionids>::_nfields=2;
template <> const char *const db_table<classic_active_versionids>::column_names[2]= {"id","versionid"};

classic_active_versionids::classic_active_versionids() :
    db_table<classic_active_versionids>(*this,-1),
    id(0),
    versionid(0) {
    db_open();
}


classic_active_versionids::classic_active_versionids(const classic_active_versionids &a) :
    db_table<classic_active_versionids>(*this,-1),
    id(a.id),
    versionid(a.versionid) {
    db_open();
}


classic_active_versionids::classic_active_versionids(const SQL_ROW &a) :
    db_table<classic_active_versionids>(*this,-1) {
    db_open();
    parse(a);
}


classic_active_versionids::classic_active_versionids(const std::string &s,const char *tag) :
    db_table<classic_active_versionids>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


classic_active_versionids &classic_active_versionids::operator =(const classic_active_versionids &a) {
    if (&a != this) {
        id=a.id;
        versionid=a.versionid;
    }
    return (*this);
}


std::string classic_active_versionids::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<2; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string classic_active_versionids::insert_format() const {
    return std::string("?,")+update_format();
}

std::string classic_active_versionids::select_format() const {
    std::string rv("");
    for (int i=0; i<1; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string classic_active_versionids::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << versionid;
    return rv.str();
}


std::string classic_active_versionids::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<versionid>" << versionid << "</versionid>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void classic_active_versionids::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"versionid",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> versionid;
        }
    }
}

void classic_active_versionids::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> versionid;
    }
}

void classic_active_versionids::parse(const std::string &s) {
    SQL_ROW row(&s,2);
    parse(row);
}

template <> const char *const db_table<rfi_zone>::table_name="rfi_zone";
template <> const char *db_table<rfi_zone>::_search_tag=table_name;
template <> const int db_table<rfi_zone>::_nfields=26;
template <> const char *const db_table<rfi_zone>::column_names[26]= {"id","min_receiver_s4id","max_receiver_s4id","min_splitter_config","max_splitter_config","min_analysis_config","max_analysis_config","min_tape_id","max_tape_id","min_workunit_id","max_workunit_id","min_result_id","max_result_id","min_time","max_time","central_baseband_freq","baseband_freq_width","central_detection_freq","detection_freq_width","central_period","period_width","fft_len_flags","signal_type_flags","ra","dec","angular_distance"};

rfi_zone::rfi_zone() :
    db_table<rfi_zone>(*this,-1),
    id(0),
    min_receiver_s4id(0),
    max_receiver_s4id(0),
    min_splitter_config(0),
    max_splitter_config(0),
    min_analysis_config(0),
    max_analysis_config(0),
    min_tape_id(0),
    max_tape_id(0),
    min_workunit_id(0),
    max_workunit_id(0),
    min_result_id(0),
    max_result_id(0),
    min_time(0),
    max_time(0),
    central_baseband_freq(0),
    baseband_freq_width(0),
    central_detection_freq(0),
    detection_freq_width(0),
    central_period(0),
    period_width(0),
    fft_len_flags(0),
    signal_type_flags(0),
    ra(0),
    dec(0),
    angular_distance(0) {
    db_open();
}


rfi_zone::rfi_zone(const rfi_zone &a) :
    db_table<rfi_zone>(*this,-1),
    id(a.id),
    min_receiver_s4id(a.min_receiver_s4id),
    max_receiver_s4id(a.max_receiver_s4id),
    min_splitter_config(a.min_splitter_config),
    max_splitter_config(a.max_splitter_config),
    min_analysis_config(a.min_analysis_config),
    max_analysis_config(a.max_analysis_config),
    min_tape_id(a.min_tape_id),
    max_tape_id(a.max_tape_id),
    min_workunit_id(a.min_workunit_id),
    max_workunit_id(a.max_workunit_id),
    min_result_id(a.min_result_id),
    max_result_id(a.max_result_id),
    min_time(a.min_time),
    max_time(a.max_time),
    central_baseband_freq(a.central_baseband_freq),
    baseband_freq_width(a.baseband_freq_width),
    central_detection_freq(a.central_detection_freq),
    detection_freq_width(a.detection_freq_width),
    central_period(a.central_period),
    period_width(a.period_width),
    fft_len_flags(a.fft_len_flags),
    signal_type_flags(a.signal_type_flags),
    ra(a.ra),
    dec(a.dec),
    angular_distance(a.angular_distance) {
    db_open();
}


rfi_zone::rfi_zone(const SQL_ROW &a) :
    db_table<rfi_zone>(*this,-1) {
    db_open();
    parse(a);
}


rfi_zone::rfi_zone(const std::string &s,const char *tag) :
    db_table<rfi_zone>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


rfi_zone &rfi_zone::operator =(const rfi_zone &a) {
    if (&a != this) {
        id=a.id;
        min_receiver_s4id=a.min_receiver_s4id;
        max_receiver_s4id=a.max_receiver_s4id;
        min_splitter_config=a.min_splitter_config;
        max_splitter_config=a.max_splitter_config;
        min_analysis_config=a.min_analysis_config;
        max_analysis_config=a.max_analysis_config;
        min_tape_id=a.min_tape_id;
        max_tape_id=a.max_tape_id;
        min_workunit_id=a.min_workunit_id;
        max_workunit_id=a.max_workunit_id;
        min_result_id=a.min_result_id;
        max_result_id=a.max_result_id;
        min_time=a.min_time;
        max_time=a.max_time;
        central_baseband_freq=a.central_baseband_freq;
        baseband_freq_width=a.baseband_freq_width;
        central_detection_freq=a.central_detection_freq;
        detection_freq_width=a.detection_freq_width;
        central_period=a.central_period;
        period_width=a.period_width;
        fft_len_flags=a.fft_len_flags;
        signal_type_flags=a.signal_type_flags;
        ra=a.ra;
        dec=a.dec;
        angular_distance=a.angular_distance;
    }
    return (*this);
}


std::string rfi_zone::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<26; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string rfi_zone::insert_format() const {
    return std::string("?,")+update_format();
}

std::string rfi_zone::select_format() const {
    std::string rv("");
    for (int i=0; i<25; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string rfi_zone::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids) {
        rv << id;
    }
    rv << ',';
    rv << min_receiver_s4id;
    rv << ',';
    rv << max_receiver_s4id;
    rv << ',';
    rv << min_splitter_config;
    rv << ',';
    rv << max_splitter_config;
    rv << ',';
    rv << min_analysis_config;
    rv << ',';
    rv << max_analysis_config;
    rv << ',';
    rv << min_tape_id;
    rv << ',';
    rv << max_tape_id;
    rv << ',';
    rv << min_workunit_id;
    rv << ',';
    rv << max_workunit_id;
    rv << ',';
    rv << min_result_id;
    rv << ',';
    rv << max_result_id;
    rv << ',';
    rv << min_time;
    rv << ',';
    rv << max_time;
    rv << ',';
    rv << central_baseband_freq;
    rv << ',';
    rv << baseband_freq_width;
    rv << ',';
    rv << central_detection_freq;
    rv << ',';
    rv << detection_freq_width;
    rv << ',';
    rv << central_period;
    rv << ',';
    rv << period_width;
    rv << ',';
    rv << fft_len_flags;
    rv << ',';
    rv << signal_type_flags;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << dec;
    rv << ',';
    rv << angular_distance;
    return rv.str();
}


std::string rfi_zone::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids) {
        rv << xml_indent() << "<id>" << id << "</id>\n";
    }
    rv << xml_indent() << "<min_receiver_s4id>" << min_receiver_s4id << "</min_receiver_s4id>\n";
    rv << xml_indent() << "<max_receiver_s4id>" << max_receiver_s4id << "</max_receiver_s4id>\n";
    rv << xml_indent() << "<min_splitter_config>" << min_splitter_config << "</min_splitter_config>\n";
    rv << xml_indent() << "<max_splitter_config>" << max_splitter_config << "</max_splitter_config>\n";
    rv << xml_indent() << "<min_analysis_config>" << min_analysis_config << "</min_analysis_config>\n";
    rv << xml_indent() << "<max_analysis_config>" << max_analysis_config << "</max_analysis_config>\n";
    rv << xml_indent() << "<min_tape_id>" << min_tape_id << "</min_tape_id>\n";
    rv << xml_indent() << "<max_tape_id>" << max_tape_id << "</max_tape_id>\n";
    rv << xml_indent() << "<min_workunit_id>" << min_workunit_id << "</min_workunit_id>\n";
    rv << xml_indent() << "<max_workunit_id>" << max_workunit_id << "</max_workunit_id>\n";
    rv << xml_indent() << "<min_result_id>" << min_result_id << "</min_result_id>\n";
    rv << xml_indent() << "<max_result_id>" << max_result_id << "</max_result_id>\n";
    rv << xml_indent() << "<min_time>" << min_time << "</min_time>\n";
    rv << xml_indent() << "<max_time>" << max_time << "</max_time>\n";
    rv << xml_indent() << "<central_baseband_freq>" << central_baseband_freq << "</central_baseband_freq>\n";
    rv << xml_indent() << "<baseband_freq_width>" << baseband_freq_width << "</baseband_freq_width>\n";
    rv << xml_indent() << "<central_detection_freq>" << central_detection_freq << "</central_detection_freq>\n";
    rv << xml_indent() << "<detection_freq_width>" << detection_freq_width << "</detection_freq_width>\n";
    rv << xml_indent() << "<central_period>" << central_period << "</central_period>\n";
    rv << xml_indent() << "<period_width>" << period_width << "</period_width>\n";
    rv << xml_indent() << "<fft_len_flags>" << fft_len_flags << "</fft_len_flags>\n";
    rv << xml_indent() << "<signal_type_flags>" << signal_type_flags << "</signal_type_flags>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<dec>" << dec << "</dec>\n";
    rv << xml_indent() << "<angular_distance>" << angular_distance << "</angular_distance>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void rfi_zone::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"min_receiver_s4id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_receiver_s4id;
        }
        if (extract_xml_record(field,"max_receiver_s4id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_receiver_s4id;
        }
        if (extract_xml_record(field,"min_splitter_config",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_splitter_config;
        }
        if (extract_xml_record(field,"max_splitter_config",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_splitter_config;
        }
        if (extract_xml_record(field,"min_analysis_config",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_analysis_config;
        }
        if (extract_xml_record(field,"max_analysis_config",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_analysis_config;
        }
        if (extract_xml_record(field,"min_tape_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_tape_id;
        }
        if (extract_xml_record(field,"max_tape_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_tape_id;
        }
        if (extract_xml_record(field,"min_workunit_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_workunit_id;
        }
        if (extract_xml_record(field,"max_workunit_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_workunit_id;
        }
        if (extract_xml_record(field,"min_result_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_result_id;
        }
        if (extract_xml_record(field,"max_result_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_result_id;
        }
        if (extract_xml_record(field,"min_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> min_time;
        }
        if (extract_xml_record(field,"max_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_time;
        }
        if (extract_xml_record(field,"central_baseband_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> central_baseband_freq;
        }
        if (extract_xml_record(field,"baseband_freq_width",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> baseband_freq_width;
        }
        if (extract_xml_record(field,"central_detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> central_detection_freq;
        }
        if (extract_xml_record(field,"detection_freq_width",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq_width;
        }
        if (extract_xml_record(field,"central_period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> central_period;
        }
        if (extract_xml_record(field,"period_width",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period_width;
        }
        if (extract_xml_record(field,"fft_len_flags",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len_flags;
        }
        if (extract_xml_record(field,"signal_type_flags",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> signal_type_flags;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> dec;
        }
        if (extract_xml_record(field,"angular_distance",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> angular_distance;
        }
    }
}

void rfi_zone::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> min_receiver_s4id;
    }
    {
        std::istringstream row(*(s[2]));
        row >> max_receiver_s4id;
    }
    {
        std::istringstream row(*(s[3]));
        row >> min_splitter_config;
    }
    {
        std::istringstream row(*(s[4]));
        row >> max_splitter_config;
    }
    {
        std::istringstream row(*(s[5]));
        row >> min_analysis_config;
    }
    {
        std::istringstream row(*(s[6]));
        row >> max_analysis_config;
    }
    {
        std::istringstream row(*(s[7]));
        row >> min_tape_id;
    }
    {
        std::istringstream row(*(s[8]));
        row >> max_tape_id;
    }
    {
        std::istringstream row(*(s[9]));
        row >> min_workunit_id;
    }
    {
        std::istringstream row(*(s[10]));
        row >> max_workunit_id;
    }
    {
        std::istringstream row(*(s[11]));
        row >> min_result_id;
    }
    {
        std::istringstream row(*(s[12]));
        row >> max_result_id;
    }
    {
        std::istringstream row(*(s[13]));
        row >> min_time;
    }
    {
        std::istringstream row(*(s[14]));
        row >> max_time;
    }
    {
        std::istringstream row(*(s[15]));
        row >> central_baseband_freq;
    }
    {
        std::istringstream row(*(s[16]));
        row >> baseband_freq_width;
    }
    {
        std::istringstream row(*(s[17]));
        row >> central_detection_freq;
    }
    {
        std::istringstream row(*(s[18]));
        row >> detection_freq_width;
    }
    {
        std::istringstream row(*(s[19]));
        row >> central_period;
    }
    {
        std::istringstream row(*(s[20]));
        row >> period_width;
    }
    {
        std::istringstream row(*(s[21]));
        row >> fft_len_flags;
    }
    {
        std::istringstream row(*(s[22]));
        row >> signal_type_flags;
    }
    {
        std::istringstream row(*(s[23]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[24]));
        row >> dec;
    }
    {
        std::istringstream row(*(s[25]));
        row >> angular_distance;
    }
}

void rfi_zone::parse(const std::string &s) {
    SQL_ROW row(&s,26);
    parse(row);
}

template <> const char *const db_table<bad_data>::table_name="bad_data";
template <> const char *db_table<bad_data>::_search_tag=table_name;
template <> const int db_table<bad_data>::_nfields=3;
template <> const char *const db_table<bad_data>::column_names[3]= {"name","beam""reason"};

bad_data::bad_data() :
    db_table<bad_data>(*this,-1),
    beam(0) {
    db_open();
    name[0]=0;
    reason[0]=0;
}


bad_data::bad_data(const bad_data &a) :
    db_table<bad_data>(*this,-1),
    beam(a.beam) {
    db_open();
    strcpy(name,a.name);
    strcpy(reason,a.reason);
}


bad_data::bad_data(const SQL_ROW &a) :
    db_table<bad_data>(*this,-1) {
    db_open();
    parse(a);
}


bad_data::bad_data(const std::string &s,const char *tag) :
    db_table<bad_data>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


bad_data &bad_data::operator =(const bad_data &a) {
    if (&a != this) {
        beam=a.beam;
        strcpy(name,a.name);
        strcpy(reason,a.reason);
    }
    return (*this);
}


std::string bad_data::update_format() const {
    std::ostringstream rv("");

    for (int i=2; i<3; i++) {
        rv << "?,";
    }
    rv << "?";
    return rv.str();
}


std::string bad_data::insert_format() const {
    return std::string("?,")+update_format();
}

std::string bad_data::select_format() const {
    std::string rv("");
    for (int i=0; i<2; i++) {
        rv+="?,";
    }
    rv+="?";
    return rv;
}

std::string bad_data::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "'" << name << "'";
    rv << ',';
    rv << beam;
    rv << ',';
    rv << "'" << reason << "'";
    return rv.str();
}


std::string bad_data::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<beam>" << beam << "</beam>\n";
    {
        std::string enc_field=xml_encode_string(reason,std::min(strlen(reason),sizeof(reason)));
        rv << xml_indent() << "<reason>";
        rv << enc_field << "</reason>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void bad_data::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)20));
            name[std::min(in.size(),(size_t)19)]=0;
        }
        if (extract_xml_record(field,"beam",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> beam;
        }
        if (extract_xml_record(field,"reason",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while (sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos) {
                epos=sub.find('\n',pos);
            }
            if (epos==std::string::npos) {
                epos=pos+strlen(sub.c_str()+pos);
            }
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(reason,(const char *)&(in.front()),std::min(in.size(),(size_t)255));
            reason[std::min(in.size(),(size_t)254)]=0;
        }
    }
}

void bad_data::parse(const SQL_ROW &s) {
    {
        strncpy(name,s[0]->c_str(),20);
        name[19]=0;
    }
    {
        std::istringstream row(*(s[1]));
        row >> beam;
    }
    {
        strncpy(reason,s[2]->c_str(),255);
        reason[254]=0;
    }
}

void bad_data::parse(const std::string &s) {
    SQL_ROW row(&s,3);
    parse(row);
}

