// String.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef STRING_H
#define STRING_H

#include <iostream.h>

class String {

  struct srep {
    char *s;  // pointer on the data
    int n;    // reference counter
    srep() 
      { n = 1; }
  };
  srep *p;
  int len;
  
public:
  String();
  String(const char *);
  String(const String &);
  String(long);
  String(char);
  
  String & operator=(const char *);
  String & operator=(const String &);
  
  ~String();

  int length() const;
  int find(char);
  void fill(char);
  String pad(int);

  String subString(int);
  String subString(int, int);

  String toLower();
  String toUpper();
  String trim();
  int indexOf(char);

  char & operator[](int);
  const char & operator[](int) const;

  bool operator==(const char *) const;
  bool operator==(const String &) const;
  
  bool operator!=(const char *) const;
  bool operator!=(const String &) const;
  
  bool operator<(const String &) const;
  bool operator>(const String &) const;

  bool operator<=(const String &) const;
  bool operator>=(const String &) const;
  
  String operator+(const char *);
  String operator+(const String &);
  
  operator const char *() const;

  friend ostream & operator<<(ostream &, const String &);
  friend istream & operator>>(istream &, String &);
};

#endif
