{-
    BNF Converter: Pretty printer
    Copyright (C) 2004  Author:  BNF Converter

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module PrintBNF where

-- pretty-printer generated by the BNF converter

import AbsBNF
import Char

-- the top-level printing method
printTree :: Print a => a -> String
printTree = render . prt 0

-- you may want to change render and parenth

render :: [String] -> String
render = rend 0 where
  rend i ss = case ss of
    "["      :ts -> cons "["  $ rend i ts
    "("      :ts -> cons "("  $ rend i ts
    "{"      :ts -> cons "{"  $ new (i+1) $ rend (i+1) ts
    "}" : ";":ts -> new (i-1) $ space "}" $ cons ";" $ new (i-1) $ rend (i-1) ts
    "}"      :ts -> new (i-1) $ cons "}" $ new (i-1) $ rend (i-1) ts
    ";"      :ts -> cons ";"  $ new i $ rend i ts
    t  : "," :ts -> cons t    $ space "," $ rend i ts
    t  : ")" :ts -> cons t    $ cons ")"  $ rend i ts
    t  : "]" :ts -> cons t    $ cons "]"  $ rend i ts
    t        :ts -> space t   $ rend i ts
    _            -> ""
  cons s t  = s ++ t
  new i s   = '\n' : replicate (2*i) ' ' ++ dropWhile isSpace s
  space t s = if null s then t else t ++ " " ++ s

parenth :: [String] -> [String]
parenth ss = ["("] ++ ss ++ [")"]

-- the printer class does the job
class Print a where
  prt :: Int -> a -> [String]
  prtList :: [a] -> [String]
  prtList = concat . map (prt 0)

instance Print a => Print [a] where
  prt _ = prtList

instance Print Integer where
  prt _ = (:[]) . show

instance Print Double where
  prt _ = (:[]) . show

instance Print Char where
  prt _ s = ["'" ++ mkEsc s ++ "'"]
  prtList s = ["\"" ++ concatMap mkEsc s ++ "\""]

mkEsc s = case s of
  _ | elem s "\\\"'" -> '\\':[s]
  '\n' -> "\\n"
  '\t' -> "\\t"
  _ -> [s]

prPrec :: Int -> Int -> [String] -> [String]
prPrec i j = if j<i then parenth else id


instance Print Ident where
  prt _ (Ident i) = [i]
  prtList es = case es of
   [x] -> (concat [prt 0 x])
   x:xs -> (concat [prt 0 x , [","] , prt 0 xs])



instance Print Grammar where
  prt i e = case e of
   Grammar defs -> prPrec i 0 (concat [prt 0 defs])


instance Print Def where
  prt i e = case e of
   Rule label cat items -> prPrec i 0 (concat [prt 0 label , ["."] , prt 0 cat , ["::="] , prt 0 items])
   Comment str -> prPrec i 0 (concat [["comment"] , prt 0 str])
   Comments str0 str -> prPrec i 0 (concat [["comment"] , prt 0 str0 , prt 0 str])
   Internal label cat items -> prPrec i 0 (concat [["internal"] , prt 0 label , ["."] , prt 0 cat , ["::="] , prt 0 items])
   Token id reg -> prPrec i 0 (concat [["token"] , prt 0 id , prt 0 reg])
   Entryp ids -> prPrec i 0 (concat [["entrypoints"] , prt 0 ids])
   Separator minimumsize cat str -> prPrec i 0 (concat [["separator"] , prt 0 minimumsize , prt 0 cat , prt 0 str])
   Terminator minimumsize cat str -> prPrec i 0 (concat [["terminator"] , prt 0 minimumsize , prt 0 cat , prt 0 str])
   Coercions id n -> prPrec i 0 (concat [["coercions"] , prt 0 id , prt 0 n])
   Rules id rhss -> prPrec i 0 (concat [["rules"] , prt 0 id , ["::="] , prt 0 rhss])
   Layout strs -> prPrec i 0 (concat [["layout"] , prt 0 strs])
   LayoutStop strs -> prPrec i 0 (concat [["layout"] , ["stop"] , prt 0 strs])
   LayoutTop  -> prPrec i 0 (concat [["layout"] , ["toplevel"]])

  prtList es = case es of
   [] -> (concat [])
   x:xs -> (concat [prt 0 x , [";"] , prt 0 xs])

instance Print Item where
  prt i e = case e of
   Terminal str -> prPrec i 0 (concat [prt 0 str])
   NTerminal cat -> prPrec i 0 (concat [prt 0 cat])

  prtList es = case es of
   [] -> (concat [])
   x:xs -> (concat [prt 0 x , prt 0 xs])

instance Print Cat where
  prt i e = case e of
   ListCat cat -> prPrec i 0 (concat [["["] , prt 0 cat , ["]"]])
   IdCat id -> prPrec i 0 (concat [prt 0 id])


instance Print Label where
  prt i e = case e of
   Id id -> prPrec i 0 (concat [prt 0 id])
   Wild  -> prPrec i 0 (concat [["_"]])
   ListE  -> prPrec i 0 (concat [["["] , ["]"]])
   ListCons  -> prPrec i 0 (concat [["("] , [":"] , [")"]])
   ListOne  -> prPrec i 0 (concat [["("] , [":"] , ["["] , ["]"] , [")"]])


instance Print RHS where
  prt i e = case e of
   RHS items -> prPrec i 0 (concat [prt 0 items])

  prtList es = case es of
   [x] -> (concat [prt 0 x])
   x:xs -> (concat [prt 0 x , ["|"] , prt 0 xs])

instance Print MinimumSize where
  prt i e = case e of
   MNonempty  -> prPrec i 0 (concat [["nonempty"]])
   MEmpty  -> prPrec i 0 (concat [])


instance Print Reg where
  prt i e = case e of
   RSeq reg0 reg -> prPrec i 2 (concat [prt 2 reg0 , prt 3 reg])
   RAlt reg0 reg -> prPrec i 1 (concat [prt 1 reg0 , ["|"] , prt 2 reg])
   RMinus reg0 reg -> prPrec i 1 (concat [prt 2 reg0 , ["-"] , prt 2 reg])
   RStar reg -> prPrec i 3 (concat [prt 3 reg , ["*"]])
   RPlus reg -> prPrec i 3 (concat [prt 3 reg , ["+"]])
   ROpt reg -> prPrec i 3 (concat [prt 3 reg , ["?"]])
   REps  -> prPrec i 3 (concat [["eps"]])
   RChar c -> prPrec i 3 (concat [prt 0 c])
   RAlts str -> prPrec i 3 (concat [["["] , prt 0 str , ["]"]])
   RSeqs str -> prPrec i 3 (concat [["{"] , prt 0 str , ["}"]])
   RDigit  -> prPrec i 3 (concat [["digit"]])
   RLetter  -> prPrec i 3 (concat [["letter"]])
   RUpper  -> prPrec i 3 (concat [["upper"]])
   RLower  -> prPrec i 3 (concat [["lower"]])
   RAny  -> prPrec i 3 (concat [["char"]])



