//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LAST_FM_TAG_HH
#define BMP_LAST_FM_TAG_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include "bmp/types/types-basic.hh"
#include "bmp/types/types-library.hh"
#include "bmp/types/types-ui.hh"
#include "bmp/types/types-lastfm.hh"

#include "lastfm.hh"

#include <glibmm/markup.h>
#include <glibmm/ustring.h>
#include <gtkmm.h>
#include <libglademm.h>

using namespace Glib;

namespace Bmp
{
  namespace LastFM
  {
    class TagDialog
      : public Gtk::Dialog
    {
        TrackMetadata m_item;

      public:

        TagDialog (BaseObjectType*                  obj,
                   RefPtr<Gnome::Glade::Xml> const& xml);
        static TagDialog* create ();
        virtual ~TagDialog ();

        void run (TrackMetadata const& item);

      private:

        Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

        struct CR : public Gtk::TreeModel::ColumnRecord
        {
          Gtk::TreeModelColumn<ustring> name;
          CR () { add (name); }
        };
        CR cr; 

        Glib::RefPtr<Gtk::ListStore>        m_tag_store;
        Gtk::TreeView                     * m_tag_view;
        Gtk::ComboBox                     * m_tag_cbox;
        Gtk::Entry                        * m_tag_name;
        Gtk::Notebook                     * m_notebook;
        Gtk::Entry                        * m_entry_artist, * m_entry_album, * m_entry_title;
        Gtk::Label                        * m_label_artist, * m_label_album, * m_label_title;
        Gtk::Image                        * m_cover;

        void  on_tag_selected ();
        void  on_tag_cbox_changed ();
        void  on_tag_name_modified ();

        void  update_view ();
        void  tag ();

        int sort_func (Gtk::TreeIter const& i1,
                       Gtk::TreeIter const& i2);

        bool  m_selection_clear_block;
    };
  } // namespace LastFM
} // namespace Bmp

#endif // !BMP_LAST_FM_TAG_DIALOG_HH

