//
// (C) 2007 DEREZYNSKI Milosz
//

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <fileref.h>
#include <glibmm.h>

// Plugin-specific include
#include <taglib.h>
#include <fileref.h>
#include <tfile.h>
#include <tag.h>

#include <oggfile.h>
#include <vorbisfile.h>
#include <vorbisproperties.h>
#include <xiphcomment.h>

#include "bmp/types/types-basic.hh"
#include "bmp/types/types-library.hh"
#include "bmp/library-ops.hh"

using namespace Glib;
using namespace TagLib;
using namespace Bmp::DB;
using namespace std;

namespace Bmp
{
    void
    metadata_get_xiph (TagLib::Ogg::XiphComment * comment, Row & row)
    {
      struct {
          AttributeId     datum;
          char          * id;
      } mb_metadata_xiph[] = {
        { ATTRIBUTE_MB_ALBUM_ARTIST,                "ALBUMARTIST"                 },
        { ATTRIBUTE_MB_ALBUM_ARTIST_ID,             "MUSICBRAINZ_ALBUMARTISTID"   },
        { ATTRIBUTE_MB_ALBUM_ARTIST_SORTNAME,       "ALBUMARTISTSORT"             },
        { ATTRIBUTE_MB_TRACK_ID,                    "MUSICBRAINZ_TRACKID"         },
        { ATTRIBUTE_MB_ALBUM_ID,                    "MUSICBRAINZ_ALBUMID"         },
        { ATTRIBUTE_MB_ARTIST_ID,                   "MUSICBRAINZ_ARTISTID"        },
        { ATTRIBUTE_MB_ARTIST_SORTNAME,             "ARTISTSORT"                  },
        { ATTRIBUTE_MB_RELEASE_DATE,                "DATE"                        },
        { ATTRIBUTE_ASIN,                           "ASIN"                        },
        { ATTRIBUTE_MUSICIP_PUID,                   "MUSICIP_PUID"                },
      };

      Ogg::FieldListMap const& map (comment->fieldListMap());
      for (unsigned int n = 0; n < G_N_ELEMENTS (mb_metadata_xiph); ++n)
      {
        Ogg::FieldListMap::ConstIterator iter = map.find (mb_metadata_xiph[n].id);
        if (iter != map.end())
        {
          StringList const& list (iter->second);
          if (!list[0].isNull() && !list[0].isEmpty()) 
          {
            row.insert (std::make_pair (get_attribute_info(mb_metadata_xiph[n].datum).id, list[0].to8Bit(true)));
          }
        }
      }
    }
} // end namespace Bmp
