//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <gtkmm.h>
#include "ccwidgets.hh"

using namespace Gtk;
using namespace Glib;

namespace Bmp
{
  bool
  FilenameEntry::on_focus_in_event (GdkEventFocus * event)
  {
    int begin, end;
    if (!get_selection_bounds (begin, end))
    {
      // select the filename's basename
      ustring text (get_text ());
      ustring::size_type i (text.rfind ("."));

      if (i != ustring::npos)
      {
        select_region (0, i-1);
      }
    }
    return true;
  }
}

namespace Bmp
{
  bool
  Scroll::on_event (GdkEvent * event)
  {
    if (m_pass)
    {
      m_pass = false;
      return false;
    }

    switch (event->type)
    {
      case GDK_SCROLL:
      {
        GdkEventScroll * scroll = (GdkEventScroll*)(event);
        GdkEvent * copy = gdk_event_copy (event);

        if (scroll->direction == GDK_SCROLL_UP)
        {
          ((GdkEventScroll*)copy)->direction = GDK_SCROLL_DOWN;
        }
        else
        if (scroll->direction == GDK_SCROLL_DOWN)
        {
          ((GdkEventScroll*)copy)->direction = GDK_SCROLL_UP;
        }
          
        m_pass = true;
        gdk_event_put (copy);
        gdk_event_free (copy);
        return true;
      }
      default: ;
    }
    return false;
  }
}
