//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_BUTTON_HH
#define BMP_BUTTON_HH

#include <glibmm/ustring.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/button.h>
#include <gtkmm/label.h>
#include <sigc++/sigc++.h>

#include <boost/optional.hpp>

#include <librsvg/rsvg.h>
#include <librsvg/rsvg-cairo.h>

namespace Bmp
{
  class SourceButton : public Gtk::Button
  {
    public:

      SourceButton ();
      virtual ~SourceButton ();

      void set_image  (Glib::RefPtr<Gdk::Pixbuf> const& image);
      void set_label  (Glib::ustring const& text, bool mnemonic = true);

      void set_active (bool active = true);
      bool get_active ();

      void set_playing (bool playing = true);
      bool get_playing ();

      void clear_image ();
      void clear_label ();

    private:

      Gtk::Label                      * m_label;
      Glib::RefPtr<Gdk::Pixbuf>         m_image;

      bool m_pressed;
      bool m_inside;
      bool m_active;
      bool m_playing;

      void create_label (Glib::ustring const& text, bool mnemonic);

      RsvgHandle * _handle_background;
      RsvgHandle * _handle_outline;
      //RsvgHandle * _handle_glow;

    protected:

      virtual void on_activate ();
      virtual void on_released ();
      virtual void on_pressed ();
      virtual void on_enter ();
      virtual void on_leave ();
      virtual void on_size_request (Gtk::Requisition * req);
      virtual bool on_expose_event (GdkEventExpose * event);

  };
}

#endif //!BMP_BUTTON_HH
