//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>

namespace Bmp
{
  template <class T>
  class XThreadSig
    : public Glib::Source
  {
    public:

      static Glib::RefPtr<XThreadSig>
      create ()
      {
        return Glib::RefPtr<XThreadSig> ( new XThreadSig() );
      }

      void connect (sigc::slot<void, T> const& slot)
      {
        connect_generic (slot);
        attach ();
      }

      void emit (T const& _data)
      {
        sig_mutex.lock ();
        m_data = _data;
        do_sig = true;
        sig_mutex.unlock ();
      }

    private:

      XThreadSig () : do_sig (false) {}
      virtual ~XThreadSig () { }

      T m_data;

      Glib::Mutex sig_mutex;
      bool do_sig;

    protected:

      virtual bool prepare (int & timeout)
      {
        timeout = 1000;
        return false;
      }

      virtual bool check ()
      {
        sig_mutex.lock ();
        bool _do = do_sig;
        sig_mutex.unlock ();
        return _do; 
      }

      virtual bool dispatch (sigc::slot_base * slot)
      {
        (*static_cast<sigc::slot<void, T>*>(slot))(m_data);
        sig_mutex.lock ();
        do_sig = false;
        sig_mutex.unlock ();
        return true;
      }
  };

  //// <void>, using no arg, just signalling

  template <>
  class XThreadSig<void>
    : public Glib::Source
  {
    public:

      static Glib::RefPtr<XThreadSig>
      create ()
      {
        return Glib::RefPtr<XThreadSig> ( new XThreadSig() );
      }

      void connect (sigc::slot<void> const& slot)
      {
        connect_generic (slot);
        attach ();
      }

      void emit ()
      {
        sig_mutex.lock ();
        do_sig = true;
        sig_mutex.unlock ();
      }

    private:

      XThreadSig () : do_sig (false) {}
      virtual ~XThreadSig () { }

      Glib::Mutex sig_mutex;
      bool do_sig;

    protected:

      virtual bool prepare (int & timeout)
      {
        timeout = 1000;
        return false;
      }

      virtual bool check ()
      {
        sig_mutex.lock ();
        bool _do = do_sig;
        sig_mutex.unlock ();
        return _do; 
      }

      virtual bool dispatch (sigc::slot_base * slot)
      {
        (*static_cast<sigc::slot<void>*>(slot))();
        sig_mutex.lock ();
        do_sig = false;
        sig_mutex.unlock ();
        return true;
      }
  };
}
