//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_PATHS_HH
#define BMP_PATHS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif // HAVE_CONFIG_H

#include <string>

// Default BMP paths used repeatedly

#define BMP_COVER_IMAGE_DEFAULT       "audio-default.png"
#define BMP_COVER_IMAGE_EMPTY         "audio-empty.png"
#define BMP_COVER_IMAGE_MULTIPLE      "audio-multiple.png"

#define BMP_UI_DIR                    DATA_DIR      G_DIR_SEPARATOR_S "ui"
#define BMP_IMAGE_DIR                 DATA_DIR      G_DIR_SEPARATOR_S "images"
#define BMP_GLADE_DIR                 DATA_DIR      G_DIR_SEPARATOR_S "glade"
#define BMP_ICON_DIR                  DATA_DIR      G_DIR_SEPARATOR_S "icons"

#define BMP_IMAGE_DIR_MAIN            BMP_IMAGE_DIR G_DIR_SEPARATOR_S "main"
#define BMP_IMAGE_DIR_LASTFM          BMP_IMAGE_DIR G_DIR_SEPARATOR_S "lastfm"
#define BMP_IMAGE_DIR_DOWNLOADS       BMP_IMAGE_DIR G_DIR_SEPARATOR_S "downloads"
#define BMP_IMAGE_DIR_LIBRARY         BMP_IMAGE_DIR G_DIR_SEPARATOR_S "library"
#define BMP_IMAGE_DIR_CDDA            BMP_IMAGE_DIR G_DIR_SEPARATOR_S "cdda"
#define BMP_IMAGE_DIR_PODCAST         BMP_IMAGE_DIR G_DIR_SEPARATOR_S "podcast"
#define BMP_IMAGE_DIR_SOURCES         BMP_IMAGE_DIR G_DIR_SEPARATOR_S "sources"

#define BMP_IMAGE_DIR_PREFS           BMP_IMAGE_DIR G_DIR_SEPARATOR_S "preferences"
#define BMP_IMAGE_DIR_HAL             BMP_IMAGE_DIR G_DIR_SEPARATOR_S "hal"
#define BMP_IMAGE_DIR_RATING          BMP_IMAGE_DIR G_DIR_SEPARATOR_S "rating"
#define BMP_IMAGE_DIR_STOCK           BMP_IMAGE_DIR G_DIR_SEPARATOR_S "stock"
#define BMP_IMAGE_DIR_SVG             BMP_IMAGE_DIR G_DIR_SEPARATOR_S "svg"

#define BMP_THEME_ICON_DIR            BMP_ICON_DIR G_DIR_SEPARATOR_S "themes"
#define BMP_TRAY_ICON_DIR             BMP_ICON_DIR G_DIR_SEPARATOR_S "tray-icons"

#define BMP_TAGLIB_PLUGIN_DIR         PLUGIN_DIR         G_DIR_SEPARATOR_S "taglib"

#define BMP_VFS_PLUGIN_DIR            PLUGIN_DIR         G_DIR_SEPARATOR_S "vfs"
#define BMP_CONTAINER_PLUGIN_DIR      BMP_VFS_PLUGIN_DIR G_DIR_SEPARATOR_S "container"
#define BMP_TRANSPORT_PLUGIN_DIR      BMP_VFS_PLUGIN_DIR G_DIR_SEPARATOR_S "transport"

#define BMP_XDG_BASEDIR                   PACKAGE
#define BMP_PATH_USER_DIR                 bmp_paths[0]
#define BMP_PATH_DATA_DIR                 bmp_paths[1]

#define BMP_BASENAME_LOGS_DIR             "logs"
#define BMP_PATH_LOGS_DIR                 bmp_paths[2]

#define BMP_BASENAME_COVER_THUMB_DIR      "covers"
#define BMP_PATH_COVER_THUMB_DIR          bmp_paths[3]

#define BMP_BASENAME_LYRIC_CACHE_DIR      "lyrics"
#define BMP_PATH_LYRIC_CACHE_DIR          bmp_paths[4]

#define BMP_BASENAME_PODCAST_CACHE_DIR    "podcasts"
#define BMP_PATH_PODCAST_CACHE_DIR        bmp_paths[5]

#define BMP_PATH_CACHE_DIR                bmp_paths[6]

#define BMP_N_PATHS 7 

extern std::string bmp_paths[BMP_N_PATHS];

#endif //!BMP_PATHS_HH
