//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_SAX_BASE_PARSER
#define BMP_SAX_BASE_PARSER

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <map>

#include "xpath.hh"

struct Element_tag
{
  const char * name;
  
  operator string() const
  {
    return name;
  }
};

typedef std::map <std::string, std::string> Props; 
typedef std::map <std::string, ElementId>   NameIdMap;

// We must define Handler before the Context
struct ParseContextBase;

typedef void (*ElementHandler) (std::string const& prefix, Props & props, ParseContextBase & _context);
typedef void (*ElementHandlerEnd) (ParseContextBase & _context);
typedef void (*HandlerPCDATA) (std::string const& text, ParseContextBase & _context);

typedef std::map <Bmp::XPath, ElementHandler> HandlerMap;
typedef std::map <Bmp::XPath, ElementHandlerEnd> HandlerEndMap;
typedef std::map <Bmp::XPath, HandlerPCDATA> HandlerPCDATAMap;

struct Handler_tag
{
  const Bmp::XPath    elementId;
  ElementHandler      handler;
};

struct HandlerEnd_tag
{
  const Bmp::XPath    elementId;
  ElementHandlerEnd   handler;
};

struct HandlerPCDATA_tag
{
  const Bmp::XPath    elementId;
  HandlerPCDATA       handler;
};

// The actual context
struct ParseContextBase
{
  HandlerMap                    mHandlers;
  HandlerEndMap                 mHandlersEnd;
  HandlerPCDATAMap              mHandlersPCDATA;
  NameIdMap                     mNameIdMap;
  Bmp::XPath                    mPath;
  Props                         mProps;
  
  ParseContextBase () : mPath ("")  {}
};

  //--------- Actual Handlers 
#define HANDLER(X) \
  void  \
  X (std::string const& prefix, Props & props, ParseContextBase & _context)

#define HANDLER_END(X) \
  void  \
  X (ParseContextBase & _context)

#define HANDLER_PCDATA(X) \
  void  \
  X (std::string const& text, ParseContextBase & _context)

namespace Bmp
{
  namespace SaxParserBase
  {
    int xml_base_parse (std::string const &data, ParseContextBase & context);
    int xml_base_parse (const char * data, guint size, ParseContextBase & context);
  }
}

#endif //!BMP_MBXML_V2_BASE_PARSER
